/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.concurrent.TimeUnit;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Fuseable;
import reactor.core.publisher.FluxSource;
import reactor.core.publisher.Operators;
import reactor.core.scheduler.TimedScheduler;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

final class FluxElapsed<T>
extends FluxSource<T, Tuple2<Long, T>>
implements Fuseable {
    final TimedScheduler scheduler;

    public FluxElapsed(Publisher<T> source, TimedScheduler scheduler) {
        super(source);
        this.scheduler = scheduler;
    }

    @Override
    public void subscribe(Subscriber<? super Tuple2<Long, T>> s) {
        this.source.subscribe(new ElapsedSubscriber(s, this.scheduler));
    }

    static final class ElapsedSubscriber<T>
    implements Subscriber<T>,
    Fuseable.QueueSubscription<Tuple2<Long, T>> {
        final Subscriber<? super Tuple2<Long, T>> actual;
        final TimedScheduler scheduler;
        Subscription s;
        Fuseable.QueueSubscription<T> qs;
        long lastTime;

        public ElapsedSubscriber(Subscriber<? super Tuple2<Long, T>> actual, TimedScheduler scheduler) {
            this.actual = actual;
            this.scheduler = scheduler;
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.lastTime = this.scheduler.now(TimeUnit.MILLISECONDS);
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
            }
        }

        public void onNext(T t) {
            this.actual.onNext(this.snapshot(t));
        }

        public void onError(Throwable t) {
            this.actual.onError(t);
        }

        public void onComplete() {
            this.actual.onComplete();
        }

        public void request(long n) {
            this.s.request(n);
        }

        public void cancel() {
            this.s.cancel();
        }

        @Override
        public int requestFusion(int requestedMode) {
            Fuseable.QueueSubscription qs = Operators.as(this.s);
            if (qs != null) {
                this.qs = qs;
                return qs.requestFusion(requestedMode);
            }
            return 0;
        }

        Tuple2<Long, T> snapshot(T data) {
            long now = this.scheduler.now(TimeUnit.MILLISECONDS);
            long last = this.lastTime;
            this.lastTime = now;
            long delta = now - last;
            return Tuples.of(delta, data);
        }

        @Override
        public Tuple2<Long, T> poll() {
            Object data = this.qs.poll();
            if (data != null) {
                return this.snapshot(data);
            }
            return null;
        }

        @Override
        public int size() {
            return this.qs.size();
        }

        @Override
        public boolean isEmpty() {
            return this.qs.isEmpty();
        }

        @Override
        public void clear() {
            this.qs.clear();
        }
    }
}

