/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.function.Consumer;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Exceptions;
import reactor.core.Fuseable;
import reactor.core.Producer;
import reactor.core.Receiver;
import reactor.core.publisher.FluxSource;
import reactor.core.publisher.Operators;
import reactor.core.publisher.SignalType;

final class FluxDoFinally<T>
extends FluxSource<T, T> {
    final Consumer<SignalType> onFinally;

    static <T> Subscriber<T> createSubscriber(Publisher<? extends T> source, Subscriber<? super T> s, Consumer<SignalType> onFinally) {
        DoFinallySubscriber subscriber = source instanceof Fuseable && s instanceof Fuseable.ConditionalSubscriber ? new DoFinallyFuseableConditionalSubscriber<T>((Fuseable.ConditionalSubscriber)s, onFinally) : (source instanceof Fuseable ? new DoFinallyFuseableSubscriber<T>(s, onFinally) : (s instanceof Fuseable.ConditionalSubscriber ? new DoFinallyConditionalSubscriber((Fuseable.ConditionalSubscriber)s, onFinally) : new DoFinallySubscriber<T>(s, onFinally)));
        return subscriber;
    }

    public FluxDoFinally(Publisher<? extends T> source, Consumer<SignalType> onFinally) {
        super(source);
        this.onFinally = onFinally;
    }

    @Override
    public void subscribe(Subscriber<? super T> s) {
        this.source.subscribe(FluxDoFinally.createSubscriber(this.source, s, this.onFinally));
    }

    static final class DoFinallyFuseableConditionalSubscriber<T>
    extends DoFinallyFuseableSubscriber<T>
    implements Fuseable.ConditionalSubscriber<T> {
        DoFinallyFuseableConditionalSubscriber(Fuseable.ConditionalSubscriber<? super T> actual, Consumer<SignalType> onFinally) {
            super(actual, onFinally);
        }

        @Override
        public boolean tryOnNext(T t) {
            return ((Fuseable.ConditionalSubscriber)this.actual).tryOnNext(t);
        }
    }

    static final class DoFinallyConditionalSubscriber<T>
    extends DoFinallySubscriber<T>
    implements Fuseable.ConditionalSubscriber<T> {
        DoFinallyConditionalSubscriber(Fuseable.ConditionalSubscriber<? super T> actual, Consumer<SignalType> onFinally) {
            super(actual, onFinally);
        }

        @Override
        public boolean tryOnNext(T t) {
            return ((Fuseable.ConditionalSubscriber)this.actual).tryOnNext(t);
        }
    }

    static class DoFinallyFuseableSubscriber<T>
    extends DoFinallySubscriber<T>
    implements Fuseable,
    Fuseable.QueueSubscription<T> {
        public DoFinallyFuseableSubscriber(Subscriber<? super T> actual, Consumer<SignalType> onFinally) {
            super(actual, onFinally);
        }

        @Override
        public int requestFusion(int mode) {
            Fuseable.QueueSubscription qs = this.qs;
            if (qs != null && (mode & 4) == 0) {
                int m = qs.requestFusion(mode);
                if (m != 0) {
                    this.syncFused = m == 1;
                }
                return m;
            }
            return 0;
        }

        @Override
        public void clear() {
            if (this.qs != null) {
                this.qs.clear();
            }
        }

        @Override
        public boolean isEmpty() {
            return this.qs == null || this.qs.isEmpty();
        }

        @Override
        public T poll() {
            if (this.qs == null) {
                return null;
            }
            Object v = this.qs.poll();
            if (v == null && this.syncFused) {
                this.runFinally(SignalType.ON_COMPLETE);
            }
            return (T)v;
        }

        @Override
        public int size() {
            return this.qs == null ? 0 : this.qs.size();
        }
    }

    static class DoFinallySubscriber<T>
    implements Subscriber<T>,
    Receiver,
    Producer,
    Subscription {
        final Subscriber<? super T> actual;
        final Consumer<SignalType> onFinally;
        volatile int once;
        static final AtomicIntegerFieldUpdater<DoFinallySubscriber> ONCE = AtomicIntegerFieldUpdater.newUpdater(DoFinallySubscriber.class, "once");
        Fuseable.QueueSubscription<T> qs;
        Subscription s;
        boolean syncFused;

        DoFinallySubscriber(Subscriber<? super T> actual, Consumer<SignalType> onFinally) {
            this.actual = actual;
            this.onFinally = onFinally;
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                if (s instanceof Fuseable.QueueSubscription) {
                    this.qs = (Fuseable.QueueSubscription)s;
                }
                this.actual.onSubscribe((Subscription)this);
            }
        }

        public void onNext(T t) {
            this.actual.onNext(t);
        }

        public void onError(Throwable t) {
            this.actual.onError(t);
            this.runFinally(SignalType.ON_ERROR);
        }

        public void onComplete() {
            this.actual.onComplete();
            this.runFinally(SignalType.ON_COMPLETE);
        }

        public void cancel() {
            this.s.cancel();
            this.runFinally(SignalType.CANCEL);
        }

        public void request(long n) {
            this.s.request(n);
        }

        void runFinally(SignalType signalType) {
            if (ONCE.compareAndSet(this, 0, 1)) {
                try {
                    this.onFinally.accept(signalType);
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    Operators.onErrorDropped(ex);
                }
            }
        }

        @Override
        public Object downstream() {
            return this.actual;
        }

        @Override
        public Object upstream() {
            return this.s;
        }
    }
}

