/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Collection;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import reactor.core.Fuseable;
import reactor.core.publisher.FluxDistinct;
import reactor.core.publisher.FluxSource;
import reactor.core.publisher.Operators;

final class FluxDistinctFuseable<T, K, C extends Collection<? super K>>
extends FluxSource<T, T>
implements Fuseable {
    final Function<? super T, ? extends K> keyExtractor;
    final Supplier<C> collectionSupplier;

    public FluxDistinctFuseable(Publisher<? extends T> source, Function<? super T, ? extends K> keyExtractor, Supplier<C> collectionSupplier) {
        super(source);
        this.keyExtractor = Objects.requireNonNull(keyExtractor, "keyExtractor");
        this.collectionSupplier = Objects.requireNonNull(collectionSupplier, "collectionSupplier");
    }

    @Override
    public void subscribe(Subscriber<? super T> s) {
        Collection collection;
        try {
            collection = (Collection)this.collectionSupplier.get();
        }
        catch (Throwable e) {
            Operators.error(s, Operators.onOperatorError(e));
            return;
        }
        if (collection == null) {
            Operators.error(s, Operators.onOperatorError(new NullPointerException("The collectionSupplier returned a null collection")));
            return;
        }
        this.source.subscribe(new FluxDistinct.DistinctFuseableSubscriber<T, K, Collection>(s, collection, this.keyExtractor));
    }
}

