/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import reactor.core.Receiver;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Operators;

final class FluxDefer<T>
extends Flux<T>
implements Receiver {
    final Supplier<? extends Publisher<? extends T>> supplier;

    public FluxDefer(Supplier<? extends Publisher<? extends T>> supplier) {
        this.supplier = Objects.requireNonNull(supplier, "supplier");
    }

    @Override
    public Object upstream() {
        return this.supplier;
    }

    public void subscribe(Subscriber<? super T> s) {
        Publisher<? extends T> p;
        try {
            p = this.supplier.get();
        }
        catch (Throwable e) {
            Operators.error(s, Operators.onOperatorError(e));
            return;
        }
        if (p == null) {
            Operators.error(s, Operators.onOperatorError(new NullPointerException("The Producer returned by the supplier is null")));
            return;
        }
        p.subscribe(s);
    }
}

