/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Receiver;
import reactor.core.publisher.FluxSource;
import reactor.core.publisher.Operators;

final class FluxDefaultIfEmpty<T>
extends FluxSource<T, T> {
    final T value;

    public FluxDefaultIfEmpty(Publisher<? extends T> source, T value) {
        super(source);
        this.value = Objects.requireNonNull(value, "value");
    }

    @Override
    public void subscribe(Subscriber<? super T> s) {
        this.source.subscribe(new DefaultIfEmptySubscriber<T>(s, this.value));
    }

    static final class DefaultIfEmptySubscriber<T>
    extends Operators.MonoSubscriber<T, T>
    implements Receiver {
        Subscription s;
        boolean hasValue;

        public DefaultIfEmptySubscriber(Subscriber<? super T> actual, T value) {
            super(actual);
            this.value = value;
        }

        @Override
        public void request(long n) {
            super.request(n);
            this.s.request(n);
        }

        @Override
        public void cancel() {
            super.cancel();
            this.s.cancel();
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
            }
        }

        @Override
        public void onNext(T t) {
            if (!this.hasValue) {
                this.hasValue = true;
            }
            this.actual.onNext(t);
        }

        @Override
        public void onComplete() {
            if (this.hasValue) {
                this.actual.onComplete();
            } else {
                this.complete(this.value);
            }
        }

        @Override
        public void setValue(T value) {
        }

        @Override
        public Object upstream() {
            return this.s;
        }

        @Override
        public Object connectedInput() {
            return this.value;
        }

        @Override
        public int requestFusion(int requestedMode) {
            return 0;
        }
    }
}

