/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Cancellation;
import reactor.core.Exceptions;
import reactor.core.Producer;
import reactor.core.Trackable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;
import reactor.core.publisher.Operators;
import reactor.util.concurrent.QueueSupplier;

final class FluxCreate<T>
extends Flux<T> {
    final Consumer<? super FluxSink<T>> source;
    final FluxSink.OverflowStrategy backpressure;

    public FluxCreate(Consumer<? super FluxSink<T>> source, FluxSink.OverflowStrategy backpressure) {
        this.source = Objects.requireNonNull(source, "source");
        this.backpressure = Objects.requireNonNull(backpressure, "backpressure");
    }

    public void subscribe(Subscriber<? super T> t) {
        BaseSink sink;
        switch (this.backpressure) {
            case IGNORE: {
                sink = new IgnoreSink<T>(t);
                break;
            }
            case ERROR: {
                sink = new ErrorAsyncSink<T>(t);
                break;
            }
            case DROP: {
                sink = new DropAsyncSink<T>(t);
                break;
            }
            case LATEST: {
                sink = new LatestAsyncSink<T>(t);
                break;
            }
            default: {
                sink = new BufferAsyncSink<T>(t, QueueSupplier.SMALL_BUFFER_SIZE);
            }
        }
        t.onSubscribe(sink);
        try {
            this.source.accept(sink);
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal(ex);
            sink.error(Operators.onOperatorError(ex));
        }
    }

    static final class LatestAsyncSink<T>
    extends BaseSink<T> {
        final AtomicReference<T> queue = new AtomicReference();
        Throwable error;
        volatile boolean done;
        volatile int wip;
        static final AtomicIntegerFieldUpdater<LatestAsyncSink> WIP = AtomicIntegerFieldUpdater.newUpdater(LatestAsyncSink.class, "wip");

        public LatestAsyncSink(Subscriber<? super T> actual) {
            super(actual);
        }

        @Override
        public void next(T t) {
            this.queue.set(t);
            this.drain();
        }

        @Override
        public void error(Throwable e) {
            this.error = e;
            this.done = true;
            this.drain();
        }

        @Override
        public void complete() {
            this.done = true;
            this.drain();
        }

        @Override
        void onRequestedFromDownstream() {
            this.drain();
        }

        @Override
        void onCancel() {
            if (WIP.getAndIncrement(this) == 0) {
                this.queue.lazySet(null);
            }
        }

        void drain() {
            if (WIP.getAndIncrement(this) != 0) {
                return;
            }
            int missed = 1;
            Subscriber a = this.actual;
            AtomicReference<T> q = this.queue;
            do {
                boolean d;
                long e;
                long r = this.requested;
                for (e = 0L; e != r; ++e) {
                    boolean empty;
                    if (this.isCancelled()) {
                        q.lazySet(null);
                        return;
                    }
                    d = this.done;
                    Object o = q.getAndSet(null);
                    boolean bl = empty = o == null;
                    if (d && empty) {
                        Throwable ex = this.error;
                        if (ex != null) {
                            super.error(ex);
                        } else {
                            super.complete();
                        }
                        return;
                    }
                    if (empty) break;
                    a.onNext(o);
                }
                if (e == r) {
                    boolean empty;
                    if (this.isCancelled()) {
                        q.lazySet(null);
                        return;
                    }
                    d = this.done;
                    boolean bl = empty = q.get() == null;
                    if (d && empty) {
                        Throwable ex = this.error;
                        if (ex != null) {
                            super.error(ex);
                        } else {
                            super.complete();
                        }
                        return;
                    }
                }
                if (e == 0L) continue;
                Operators.produced(REQUESTED, this, e);
            } while ((missed = WIP.addAndGet(this, -missed)) != 0);
        }
    }

    static final class BufferAsyncSink<T>
    extends BaseSink<T> {
        final Queue<T> queue;
        Throwable error;
        volatile boolean done;
        volatile int wip;
        static final AtomicIntegerFieldUpdater<BufferAsyncSink> WIP = AtomicIntegerFieldUpdater.newUpdater(BufferAsyncSink.class, "wip");

        public BufferAsyncSink(Subscriber<? super T> actual, int capacityHint) {
            super(actual);
            this.queue = QueueSupplier.unbounded(capacityHint).get();
        }

        @Override
        public void next(T t) {
            this.queue.offer(t);
            this.drain();
        }

        @Override
        public void error(Throwable e) {
            this.error = e;
            this.done = true;
            this.drain();
        }

        @Override
        public void complete() {
            this.done = true;
            this.drain();
        }

        @Override
        void onRequestedFromDownstream() {
            this.drain();
        }

        @Override
        void onCancel() {
            if (WIP.getAndIncrement(this) == 0) {
                this.queue.clear();
            }
        }

        void drain() {
            if (WIP.getAndIncrement(this) != 0) {
                return;
            }
            int missed = 1;
            Subscriber a = this.actual;
            Queue<T> q = this.queue;
            do {
                boolean d;
                long e;
                long r = this.requested;
                for (e = 0L; e != r; ++e) {
                    boolean empty;
                    if (this.isCancelled()) {
                        q.clear();
                        return;
                    }
                    d = this.done;
                    T o = q.poll();
                    boolean bl = empty = o == null;
                    if (d && empty) {
                        Throwable ex = this.error;
                        if (ex != null) {
                            super.error(ex);
                        } else {
                            super.complete();
                        }
                        return;
                    }
                    if (empty) break;
                    a.onNext(o);
                }
                if (e == r) {
                    if (this.isCancelled()) {
                        q.clear();
                        return;
                    }
                    d = this.done;
                    boolean empty = q.isEmpty();
                    if (d && empty) {
                        Throwable ex = this.error;
                        if (ex != null) {
                            super.error(ex);
                        } else {
                            super.complete();
                        }
                        return;
                    }
                }
                if (e == 0L) continue;
                Operators.produced(REQUESTED, this, e);
            } while ((missed = WIP.addAndGet(this, -missed)) != 0);
        }
    }

    static final class ErrorAsyncSink<T>
    extends NoOverflowBaseAsyncSink<T> {
        public ErrorAsyncSink(Subscriber<? super T> actual) {
            super(actual);
        }

        @Override
        void onOverflow() {
            this.error(Exceptions.failWithOverflow());
        }
    }

    static final class DropAsyncSink<T>
    extends NoOverflowBaseAsyncSink<T> {
        public DropAsyncSink(Subscriber<? super T> actual) {
            super(actual);
        }

        @Override
        void onOverflow() {
        }
    }

    static abstract class NoOverflowBaseAsyncSink<T>
    extends BaseSink<T> {
        public NoOverflowBaseAsyncSink(Subscriber<? super T> actual) {
            super(actual);
        }

        @Override
        public final void next(T t) {
            if (this.isCancelled()) {
                return;
            }
            if (this.requested != 0L) {
                this.actual.onNext(t);
                Operators.produced(REQUESTED, this, 1L);
            } else {
                this.onOverflow();
            }
        }

        abstract void onOverflow();
    }

    static final class IgnoreSink<T>
    extends BaseSink<T> {
        public IgnoreSink(Subscriber<? super T> actual) {
            super(actual);
        }

        @Override
        public void next(T t) {
            long r;
            if (this.isCancelled()) {
                return;
            }
            this.actual.onNext(t);
            while ((r = this.requested) != 0L && !REQUESTED.compareAndSet(this, r, r - 1L)) {
            }
        }
    }

    static abstract class BaseSink<T>
    implements FluxSink<T>,
    Subscription,
    Trackable,
    Producer {
        final Subscriber<? super T> actual;
        volatile Cancellation cancel;
        static final AtomicReferenceFieldUpdater<BaseSink, Cancellation> CANCEL = AtomicReferenceFieldUpdater.newUpdater(BaseSink.class, Cancellation.class, "cancel");
        volatile long requested;
        static final AtomicLongFieldUpdater<BaseSink> REQUESTED = AtomicLongFieldUpdater.newUpdater(BaseSink.class, "requested");
        static final Cancellation CANCELLED = () -> {};

        public BaseSink(Subscriber<? super T> actual) {
            this.actual = actual;
        }

        @Override
        public void complete() {
            if (this.isCancelled()) {
                return;
            }
            try {
                this.actual.onComplete();
            }
            finally {
                this.cancelResource();
            }
        }

        @Override
        public void error(Throwable e) {
            if (this.isCancelled()) {
                return;
            }
            try {
                this.actual.onError(e);
            }
            finally {
                this.cancelResource();
            }
        }

        public final void cancel() {
            this.cancelResource();
            this.onCancel();
        }

        void cancelResource() {
            Cancellation c = this.cancel;
            if (c != CANCELLED && (c = CANCEL.getAndSet(this, CANCELLED)) != null && c != CANCELLED) {
                c.dispose();
            }
        }

        @Override
        public long requestedFromDownstream() {
            return this.requested;
        }

        @Override
        public long getCapacity() {
            return Long.MAX_VALUE;
        }

        void onCancel() {
        }

        @Override
        public final boolean isCancelled() {
            return this.cancel == CANCELLED;
        }

        public final void request(long n) {
            if (Operators.validate(n)) {
                Operators.getAndAddCap(REQUESTED, this, n);
                this.onRequestedFromDownstream();
            }
        }

        void onRequestedFromDownstream() {
        }

        public Subscriber<? super T> downstream() {
            return this.actual;
        }

        @Override
        public final void setCancellation(Cancellation c) {
            if (!CANCEL.compareAndSet(this, null, c) && this.cancel != CANCELLED && c != null) {
                c.dispose();
            }
        }

        @Override
        public final FluxSink<T> serialize() {
            return new SerializedSink(this);
        }
    }

    static final class SerializedSink<T>
    implements FluxSink<T> {
        final BaseSink<T> sink;
        volatile Throwable error;
        static final AtomicReferenceFieldUpdater<SerializedSink, Throwable> ERROR = AtomicReferenceFieldUpdater.newUpdater(SerializedSink.class, Throwable.class, "error");
        volatile int wip;
        static final AtomicIntegerFieldUpdater<SerializedSink> WIP = AtomicIntegerFieldUpdater.newUpdater(SerializedSink.class, "wip");
        final Queue<T> queue;
        volatile boolean done;

        public SerializedSink(BaseSink<T> sink) {
            this.sink = sink;
            this.queue = QueueSupplier.unbounded(QueueSupplier.XS_BUFFER_SIZE).get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void next(T t) {
            if (this.sink.isCancelled() || this.done) {
                return;
            }
            if (t == null) {
                throw new NullPointerException("t is null in sink.next(t)");
            }
            if (WIP.get(this) == 0 && WIP.compareAndSet(this, 0, 1)) {
                this.sink.next(t);
                if (WIP.decrementAndGet(this) == 0) {
                    return;
                }
            } else {
                Queue<T> q = this.queue;
                SerializedSink serializedSink = this;
                synchronized (serializedSink) {
                    q.offer(t);
                }
                if (WIP.getAndIncrement(this) != 0) {
                    return;
                }
            }
            this.drainLoop();
        }

        @Override
        public void error(Throwable t) {
            if (this.sink.isCancelled() || this.done) {
                Operators.onErrorDropped(t);
                return;
            }
            if (t == null) {
                throw new NullPointerException("t is null in sink.error(t)");
            }
            if (Exceptions.addThrowable(ERROR, this, t)) {
                this.done = true;
                this.drain();
            } else {
                Operators.onErrorDropped(t);
            }
        }

        @Override
        public void complete() {
            if (this.sink.isCancelled() || this.done) {
                return;
            }
            this.done = true;
            this.drain();
        }

        void drain() {
            if (WIP.getAndIncrement(this) == 0) {
                this.drainLoop();
            }
        }

        void drainLoop() {
            BaseSink<T> e = this.sink;
            Queue<T> q = this.queue;
            int missed = 1;
            while (true) {
                boolean empty;
                T v;
                if (e.isCancelled()) {
                    q.clear();
                    return;
                }
                if (ERROR.get(this) != null) {
                    q.clear();
                    e.error(Exceptions.terminate(ERROR, this));
                    return;
                }
                boolean d = this.done;
                try {
                    v = q.poll();
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    v = null;
                }
                boolean bl = empty = v == null;
                if (d && empty) {
                    e.complete();
                    return;
                }
                if (!empty) {
                    e.next(v);
                    continue;
                }
                if ((missed = WIP.addAndGet(this, -missed)) == 0) break;
            }
        }

        @Override
        public void setCancellation(Cancellation c) {
            this.sink.setCancellation(c);
        }

        @Override
        public long requestedFromDownstream() {
            return this.sink.requestedFromDownstream();
        }

        @Override
        public boolean isCancelled() {
            return this.sink.isCancelled();
        }

        @Override
        public FluxSink<T> serialize() {
            return this;
        }
    }
}

