/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import reactor.core.MultiReceiver;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Operators;

final class FluxConcatIterable<T>
extends Flux<T>
implements MultiReceiver {
    final Iterable<? extends Publisher<? extends T>> iterable;

    public FluxConcatIterable(Iterable<? extends Publisher<? extends T>> iterable) {
        this.iterable = Objects.requireNonNull(iterable, "iterable");
    }

    @Override
    public Iterator<?> upstreams() {
        return this.iterable.iterator();
    }

    public void subscribe(Subscriber<? super T> s) {
        Iterator<? extends Publisher<? extends T>> it;
        try {
            it = this.iterable.iterator();
        }
        catch (Throwable e) {
            Operators.error(s, Operators.onOperatorError(e));
            return;
        }
        if (it == null) {
            Operators.error(s, Operators.onOperatorError(new NullPointerException("The Iterator returned is null")));
            return;
        }
        ConcatIterableSubscriber<T> parent = new ConcatIterableSubscriber<T>(s, it);
        s.onSubscribe(parent);
        if (!parent.isCancelled()) {
            parent.onComplete();
        }
    }

    static final class ConcatIterableSubscriber<T>
    extends Operators.MultiSubscriptionSubscriber<T, T> {
        final Iterator<? extends Publisher<? extends T>> it;
        volatile int wip;
        static final AtomicIntegerFieldUpdater<ConcatIterableSubscriber> WIP = AtomicIntegerFieldUpdater.newUpdater(ConcatIterableSubscriber.class, "wip");
        long produced;

        public ConcatIterableSubscriber(Subscriber<? super T> actual, Iterator<? extends Publisher<? extends T>> it) {
            super(actual);
            this.it = it;
        }

        public void onNext(T t) {
            ++this.produced;
            this.subscriber.onNext(t);
        }

        @Override
        public void onComplete() {
            if (WIP.getAndIncrement(this) == 0) {
                Iterator<Publisher<T>> a = this.it;
                do {
                    Publisher<? extends T> p;
                    boolean b;
                    if (this.isCancelled()) {
                        return;
                    }
                    try {
                        b = a.hasNext();
                    }
                    catch (Throwable e) {
                        this.onError(Operators.onOperatorError(this, e));
                        return;
                    }
                    if (this.isCancelled()) {
                        return;
                    }
                    if (!b) {
                        this.subscriber.onComplete();
                        return;
                    }
                    try {
                        p = this.it.next();
                    }
                    catch (Throwable e) {
                        this.subscriber.onError(Operators.onOperatorError(this, e));
                        return;
                    }
                    if (this.isCancelled()) {
                        return;
                    }
                    if (p == null) {
                        this.subscriber.onError(Operators.onOperatorError(this, new NullPointerException("The Publisher returned by the iterator is null")));
                        return;
                    }
                    long c = this.produced;
                    if (c != 0L) {
                        this.produced = 0L;
                        this.produced(c);
                    }
                    p.subscribe((Subscriber)this);
                    if (!this.isCancelled()) continue;
                    return;
                } while (WIP.decrementAndGet(this) != 0);
            }
        }
    }
}

