/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import reactor.core.Exceptions;
import reactor.core.MultiReceiver;
import reactor.core.publisher.Flux;
import reactor.core.publisher.MonoIgnoreThen;
import reactor.core.publisher.Operators;

final class FluxConcatArray<T>
extends Flux<T>
implements MultiReceiver {
    final Publisher<? extends T>[] array;
    final boolean delayError;

    @SafeVarargs
    public FluxConcatArray(boolean delayError, Publisher<? extends T> ... array) {
        this.array = Objects.requireNonNull(array, "array");
        this.delayError = delayError;
    }

    @Override
    public Iterator<?> upstreams() {
        return Arrays.asList(this.array).iterator();
    }

    @Override
    public long upstreamCount() {
        return this.array.length;
    }

    public void subscribe(Subscriber<? super T> s) {
        Publisher<? extends T>[] a = this.array;
        if (a.length == 0) {
            Operators.complete(s);
            return;
        }
        if (a.length == 1) {
            Publisher<? extends T> p = a[0];
            if (p == null) {
                Operators.error(s, new NullPointerException("The single source Publisher is null"));
            } else {
                p.subscribe(s);
            }
            return;
        }
        if (this.delayError) {
            ConcatArrayDelayErrorSubscriber<T> parent = new ConcatArrayDelayErrorSubscriber<T>(s, a);
            s.onSubscribe(parent);
            if (!parent.isCancelled()) {
                parent.onComplete();
            }
            return;
        }
        ConcatArraySubscriber<T> parent = new ConcatArraySubscriber<T>(s, a);
        s.onSubscribe(parent);
        if (!parent.isCancelled()) {
            parent.onComplete();
        }
    }

    public FluxConcatArray<T> concatAdditionalSourceLast(Publisher<? extends T> source) {
        int n = this.array.length;
        Publisher[] newArray = new Publisher[n + 1];
        System.arraycopy(this.array, 0, newArray, 0, n);
        newArray[n] = source;
        return new FluxConcatArray<T>(this.delayError, newArray);
    }

    public <V> FluxConcatArray<V> concatAdditionalIgnoredLast(Publisher<? extends V> source) {
        int n = this.array.length;
        Publisher[] newArray = new Publisher[n + 1];
        System.arraycopy(this.array, 0, newArray, 0, n);
        newArray[n - 1] = new MonoIgnoreThen(newArray[n - 1]);
        newArray[n] = source;
        return new FluxConcatArray<T>(this.delayError, newArray);
    }

    public FluxConcatArray<T> concatAdditionalSourceFirst(Publisher<? extends T> source) {
        int n = this.array.length;
        Publisher[] newArray = new Publisher[n + 1];
        System.arraycopy(this.array, 0, newArray, 1, n);
        newArray[0] = source;
        return new FluxConcatArray<T>(this.delayError, newArray);
    }

    static final class ConcatArrayDelayErrorSubscriber<T>
    extends Operators.MultiSubscriptionSubscriber<T, T> {
        final Publisher<? extends T>[] sources;
        int index;
        volatile int wip;
        static final AtomicIntegerFieldUpdater<ConcatArrayDelayErrorSubscriber> WIP = AtomicIntegerFieldUpdater.newUpdater(ConcatArrayDelayErrorSubscriber.class, "wip");
        volatile Throwable error;
        static final AtomicReferenceFieldUpdater<ConcatArrayDelayErrorSubscriber, Throwable> ERROR = AtomicReferenceFieldUpdater.newUpdater(ConcatArrayDelayErrorSubscriber.class, Throwable.class, "error");
        long produced;

        public ConcatArrayDelayErrorSubscriber(Subscriber<? super T> actual, Publisher<? extends T>[] sources) {
            super(actual);
            this.sources = sources;
        }

        public void onNext(T t) {
            ++this.produced;
            this.subscriber.onNext(t);
        }

        @Override
        public void onError(Throwable t) {
            if (Exceptions.addThrowable(ERROR, this, t)) {
                this.onComplete();
            } else {
                Operators.onErrorDropped(t);
            }
        }

        @Override
        public void onComplete() {
            if (WIP.getAndIncrement(this) == 0) {
                Publisher<? extends T>[] a = this.sources;
                do {
                    if (this.isCancelled()) {
                        return;
                    }
                    int i = this.index;
                    if (i == a.length) {
                        Throwable e = Exceptions.terminate(ERROR, this);
                        if (e != null) {
                            this.subscriber.onError(e);
                        } else {
                            this.subscriber.onComplete();
                        }
                        return;
                    }
                    Publisher<? extends T> p = a[i];
                    if (p == null) {
                        this.subscriber.onError((Throwable)new NullPointerException("The " + i + "th source Publisher is null"));
                        return;
                    }
                    long c = this.produced;
                    if (c != 0L) {
                        this.produced = 0L;
                        this.produced(c);
                    }
                    p.subscribe((Subscriber)this);
                    if (this.isCancelled()) {
                        return;
                    }
                    this.index = ++i;
                } while (WIP.decrementAndGet(this) != 0);
            }
        }
    }

    static final class ConcatArraySubscriber<T>
    extends Operators.MultiSubscriptionSubscriber<T, T> {
        final Publisher<? extends T>[] sources;
        int index;
        volatile int wip;
        static final AtomicIntegerFieldUpdater<ConcatArraySubscriber> WIP = AtomicIntegerFieldUpdater.newUpdater(ConcatArraySubscriber.class, "wip");
        long produced;

        public ConcatArraySubscriber(Subscriber<? super T> actual, Publisher<? extends T>[] sources) {
            super(actual);
            this.sources = sources;
        }

        public void onNext(T t) {
            ++this.produced;
            this.subscriber.onNext(t);
        }

        @Override
        public void onComplete() {
            if (WIP.getAndIncrement(this) == 0) {
                Publisher<? extends T>[] a = this.sources;
                do {
                    if (this.isCancelled()) {
                        return;
                    }
                    int i = this.index;
                    if (i == a.length) {
                        this.subscriber.onComplete();
                        return;
                    }
                    Publisher<? extends T> p = a[i];
                    if (p == null) {
                        this.subscriber.onError((Throwable)new NullPointerException("The " + i + "th source Publisher is null"));
                        return;
                    }
                    long c = this.produced;
                    if (c != 0L) {
                        this.produced = 0L;
                        this.produced(c);
                    }
                    p.subscribe((Subscriber)this);
                    if (this.isCancelled()) {
                        return;
                    }
                    this.index = ++i;
                } while (WIP.decrementAndGet(this) != 0);
            }
        }
    }
}

