/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Collection;
import java.util.Objects;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.publisher.FluxBatch;
import reactor.core.scheduler.TimedScheduler;

final class FluxBufferTimeOrSize<T, C extends Collection<? super T>>
extends FluxBatch<T, C> {
    final Supplier<C> bufferSupplier;

    public FluxBufferTimeOrSize(Publisher<T> source, int maxSize, long timespan, TimedScheduler timer, Supplier<C> bufferSupplier) {
        super(source, maxSize, timespan, timer);
        this.bufferSupplier = Objects.requireNonNull(bufferSupplier, "bufferSupplier");
    }

    @Override
    public void subscribe(Subscriber<? super C> subscriber) {
        this.source.subscribe(new BufferAction(this.prepareSub(subscriber), this.batchSize, this.timespan, this.timer.createWorker(), this.bufferSupplier));
    }

    static final class BufferAction<T, C extends Collection<? super T>>
    extends FluxBatch.BatchAction<T, C> {
        final Supplier<C> bufferSupplier;
        volatile C values;

        public BufferAction(Subscriber<? super C> actual, int maxSize, long timespan, TimedScheduler.TimedWorker timer, Supplier<C> bufferSupplier) {
            super(actual, maxSize, false, timespan, timer);
            this.bufferSupplier = bufferSupplier;
        }

        @Override
        protected void doOnSubscribe(Subscription subscription) {
            this.values = (Collection)this.bufferSupplier.get();
            this.subscriber.onSubscribe((Subscription)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void checkedError(Throwable ev) {
            BufferAction bufferAction = this;
            synchronized (bufferAction) {
                C v = this.values;
                if (v != null) {
                    v.clear();
                    this.values = null;
                }
            }
            this.subscriber.onError(ev);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void nextCallback(T value) {
            BufferAction bufferAction = this;
            synchronized (bufferAction) {
                Object v = this.values;
                if (v == null) {
                    this.values = v = (Collection)this.bufferSupplier.get();
                }
                v.add(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void flushCallback(T ev) {
            C v = this.values;
            boolean flush = false;
            BufferAction bufferAction = this;
            synchronized (bufferAction) {
                if (v != null && !v.isEmpty()) {
                    this.values = (Collection)this.bufferSupplier.get();
                    flush = true;
                }
            }
            if (flush) {
                this.subscriber.onNext(v);
            }
        }
    }
}

