/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Exceptions;
import reactor.core.publisher.FluxSource;
import reactor.core.publisher.Operators;

final class FluxBufferBoundary<T, U, C extends Collection<? super T>>
extends FluxSource<T, C> {
    final Publisher<U> other;
    final Supplier<C> bufferSupplier;

    public FluxBufferBoundary(Publisher<? extends T> source, Publisher<U> other, Supplier<C> bufferSupplier) {
        super(source);
        this.other = Objects.requireNonNull(other, "other");
        this.bufferSupplier = Objects.requireNonNull(bufferSupplier, "bufferSupplier");
    }

    @Override
    public long getPrefetch() {
        return Long.MAX_VALUE;
    }

    @Override
    public void subscribe(Subscriber<? super C> s) {
        Collection buffer;
        try {
            buffer = (Collection)this.bufferSupplier.get();
        }
        catch (Throwable e) {
            Operators.error(s, Operators.onOperatorError(e));
            return;
        }
        if (buffer == null) {
            Operators.error(s, new NullPointerException("The bufferSupplier returned a null buffer"));
            return;
        }
        BufferBoundaryMain parent = new BufferBoundaryMain(s, buffer, this.bufferSupplier);
        BufferBoundaryOther boundary = new BufferBoundaryOther(parent);
        parent.other = boundary;
        s.onSubscribe(parent);
        this.other.subscribe(boundary);
        this.source.subscribe(parent);
    }

    static final class BufferBoundaryOther<U>
    extends Operators.DeferredSubscription
    implements Subscriber<U> {
        final BufferBoundaryMain<?, U, ?> main;

        public BufferBoundaryOther(BufferBoundaryMain<?, U, ?> main) {
            this.main = main;
        }

        public void onSubscribe(Subscription s) {
            if (this.set(s)) {
                s.request(Long.MAX_VALUE);
            }
        }

        public void onNext(U t) {
            this.main.otherNext();
        }

        public void onError(Throwable t) {
            this.main.otherError(t);
        }

        public void onComplete() {
            this.main.otherComplete();
        }
    }

    static final class BufferBoundaryMain<T, U, C extends Collection<? super T>>
    implements Subscriber<T>,
    Subscription {
        final Subscriber<? super C> actual;
        final Supplier<C> bufferSupplier;
        BufferBoundaryOther<U> other;
        C buffer;
        volatile Subscription s;
        static final AtomicReferenceFieldUpdater<BufferBoundaryMain, Subscription> S = AtomicReferenceFieldUpdater.newUpdater(BufferBoundaryMain.class, Subscription.class, "s");
        volatile long requested;
        static final AtomicLongFieldUpdater<BufferBoundaryMain> REQUESTED = AtomicLongFieldUpdater.newUpdater(BufferBoundaryMain.class, "requested");

        public BufferBoundaryMain(Subscriber<? super C> actual, C buffer, Supplier<C> bufferSupplier) {
            this.actual = actual;
            this.buffer = buffer;
            this.bufferSupplier = bufferSupplier;
        }

        public void request(long n) {
            if (Operators.validate(n)) {
                Operators.getAndAddCap(REQUESTED, this, n);
            }
        }

        void cancelMain() {
            Operators.terminate(S, this);
        }

        public void cancel() {
            this.cancelMain();
            this.other.cancel();
        }

        public void onSubscribe(Subscription s) {
            if (Operators.setOnce(S, this, s)) {
                s.request(Long.MAX_VALUE);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onNext(T t) {
            BufferBoundaryMain bufferBoundaryMain = this;
            synchronized (bufferBoundaryMain) {
                C b = this.buffer;
                if (b != null) {
                    b.add(t);
                    return;
                }
            }
            Operators.onNextDropped(t);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onError(Throwable t) {
            boolean report;
            Subscription s = this.s;
            if (s != null) {
                this.s = null;
            } else {
                Operators.onErrorDropped(t);
            }
            BufferBoundaryMain bufferBoundaryMain = this;
            synchronized (bufferBoundaryMain) {
                C b = this.buffer;
                if (b != null) {
                    this.buffer = null;
                    report = true;
                } else {
                    report = false;
                }
            }
            if (report) {
                this.other.cancel();
                this.actual.onError(t);
            } else {
                Operators.onErrorDropped(t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onComplete() {
            C b;
            Subscription s = this.s;
            if (s == null) {
                return;
            }
            this.s = null;
            BufferBoundaryMain bufferBoundaryMain = this;
            synchronized (bufferBoundaryMain) {
                b = this.buffer;
                this.buffer = null;
            }
            this.other.cancel();
            if (b != null && !b.isEmpty()) {
                if (this.emit(b)) {
                    this.actual.onComplete();
                }
            } else {
                this.actual.onComplete();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void otherNext() {
            C b;
            Collection c;
            try {
                c = (Collection)this.bufferSupplier.get();
            }
            catch (Throwable e) {
                this.otherError(Operators.onOperatorError(this.other, e));
                return;
            }
            if (c == null) {
                this.other.cancel();
                this.otherError(new NullPointerException("The bufferSupplier returned a null buffer"));
                return;
            }
            BufferBoundaryMain bufferBoundaryMain = this;
            synchronized (bufferBoundaryMain) {
                b = this.buffer;
                this.buffer = c;
            }
            if (b.isEmpty()) {
                return;
            }
            this.emit(b);
        }

        void otherError(Throwable e) {
            this.cancelMain();
            this.onError(e);
        }

        void otherComplete() {
            this.cancelMain();
            this.onComplete();
        }

        boolean emit(C b) {
            long r = this.requested;
            if (r != 0L) {
                this.actual.onNext(b);
                if (r != Long.MAX_VALUE) {
                    REQUESTED.decrementAndGet(this);
                }
                return true;
            }
            this.cancel();
            this.actual.onError((Throwable)Exceptions.failWithOverflow("Could not emit buffer due to lack of requests"));
            return false;
        }
    }
}

