/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Producer;
import reactor.core.Receiver;
import reactor.core.Trackable;
import reactor.core.publisher.FluxSource;
import reactor.core.publisher.Operators;

final class FluxAwaitOnSubscribe<T>
extends FluxSource<T, T> {
    public FluxAwaitOnSubscribe(Publisher<? extends T> source) {
        super(source);
    }

    @Override
    public void subscribe(Subscriber<? super T> s) {
        this.source.subscribe(new PostOnSubscribeSubscriber<T>(s));
    }

    static final class PostOnSubscribeSubscriber<T>
    implements Receiver,
    Producer,
    Trackable,
    Subscriber<T>,
    Subscription {
        final Subscriber<? super T> actual;
        volatile Subscription s;
        static final AtomicReferenceFieldUpdater<PostOnSubscribeSubscriber, Subscription> S = AtomicReferenceFieldUpdater.newUpdater(PostOnSubscribeSubscriber.class, Subscription.class, "s");
        volatile long requested;
        static final AtomicLongFieldUpdater<PostOnSubscribeSubscriber> REQUESTED = AtomicLongFieldUpdater.newUpdater(PostOnSubscribeSubscriber.class, "requested");

        public PostOnSubscribeSubscriber(Subscriber<? super T> actual) {
            this.actual = actual;
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                long r;
                this.actual.onSubscribe((Subscription)this);
                if (Operators.setOnce(S, this, s) && (r = REQUESTED.getAndSet(this, 0L)) != 0L) {
                    s.request(r);
                }
            }
        }

        public void onNext(T t) {
            this.actual.onNext(t);
        }

        public void onError(Throwable t) {
            this.actual.onError(t);
        }

        public void onComplete() {
            this.actual.onComplete();
        }

        public void request(long n) {
            Subscription a = this.s;
            if (a != null) {
                a.request(n);
            } else if (Operators.validate(n)) {
                long r;
                Operators.getAndAddCap(REQUESTED, this, n);
                a = this.s;
                if (a != null && (r = REQUESTED.getAndSet(this, 0L)) != 0L) {
                    a.request(n);
                }
            }
        }

        public void cancel() {
            Operators.terminate(S, this);
        }

        @Override
        public Object downstream() {
            return this.actual;
        }

        @Override
        public Object upstream() {
            return this.s;
        }

        @Override
        public long requestedFromDownstream() {
            return this.requested;
        }
    }
}

