/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import reactor.core.Fuseable;
import reactor.core.MultiReceiver;
import reactor.core.Producer;
import reactor.core.Trackable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Operators;

final class FluxArray<T>
extends Flux<T>
implements Fuseable {
    final T[] array;

    @SafeVarargs
    public FluxArray(T ... array) {
        this.array = Objects.requireNonNull(array, "array");
    }

    public static <T> void subscribe(Subscriber<? super T> s, T[] array) {
        if (array.length == 0) {
            Operators.complete(s);
            return;
        }
        if (s instanceof Fuseable.ConditionalSubscriber) {
            s.onSubscribe(new ArrayConditionalSubscription<T>((Fuseable.ConditionalSubscriber)s, array));
        } else {
            s.onSubscribe(new ArraySubscription<T>(s, array));
        }
    }

    public void subscribe(Subscriber<? super T> s) {
        FluxArray.subscribe(s, this.array);
    }

    static final class ArrayConditionalSubscription<T>
    implements Producer,
    Trackable,
    MultiReceiver,
    Fuseable.SynchronousSubscription<T> {
        final Fuseable.ConditionalSubscriber<? super T> actual;
        final T[] array;
        int index;
        volatile boolean cancelled;
        volatile long requested;
        static final AtomicLongFieldUpdater<ArrayConditionalSubscription> REQUESTED = AtomicLongFieldUpdater.newUpdater(ArrayConditionalSubscription.class, "requested");

        public ArrayConditionalSubscription(Fuseable.ConditionalSubscriber<? super T> actual, T[] array) {
            this.actual = actual;
            this.array = array;
        }

        public void request(long n) {
            if (Operators.validate(n) && Operators.getAndAddCap(REQUESTED, this, n) == 0L) {
                if (n == Long.MAX_VALUE) {
                    this.fastPath();
                } else {
                    this.slowPath(n);
                }
            }
        }

        void slowPath(long n) {
            T[] a = this.array;
            int len = a.length;
            Fuseable.ConditionalSubscriber<? super T> s = this.actual;
            int i = this.index;
            int e = 0;
            while (!this.cancelled) {
                while (i != len && (long)e != n) {
                    T t = a[i];
                    if (t == null) {
                        s.onError(new NullPointerException("The " + i + "th array element was null"));
                        return;
                    }
                    boolean b = s.tryOnNext((T)t);
                    if (this.cancelled) {
                        return;
                    }
                    ++i;
                    if (!b) continue;
                    ++e;
                }
                if (i == len) {
                    s.onComplete();
                    return;
                }
                n = this.requested;
                if (n != (long)e) continue;
                this.index = i;
                n = REQUESTED.addAndGet(this, -e);
                if (n == 0L) {
                    return;
                }
                e = 0;
            }
            return;
        }

        void fastPath() {
            T[] a = this.array;
            int len = a.length;
            Fuseable.ConditionalSubscriber<? super T> s = this.actual;
            for (int i = this.index; i != len; ++i) {
                if (this.cancelled) {
                    return;
                }
                T t = a[i];
                if (t == null) {
                    s.onError(new NullPointerException("The " + i + "th array element was null"));
                    return;
                }
                s.onNext(t);
            }
            if (this.cancelled) {
                return;
            }
            s.onComplete();
        }

        public void cancel() {
            this.cancelled = true;
        }

        @Override
        public boolean isCancelled() {
            return this.cancelled;
        }

        @Override
        public Object downstream() {
            return this.actual;
        }

        @Override
        public long requestedFromDownstream() {
            return this.requested;
        }

        @Override
        public Iterator<?> upstreams() {
            return this.array instanceof Publisher[] ? Arrays.asList(this.array).iterator() : null;
        }

        @Override
        public long upstreamCount() {
            return this.array instanceof Publisher[] ? (long)this.array.length : -1L;
        }

        @Override
        public T poll() {
            int i = this.index;
            T[] a = this.array;
            if (i != a.length) {
                T t = a[i];
                if (t == null) {
                    throw new NullPointerException();
                }
                this.index = i + 1;
                return t;
            }
            return null;
        }

        @Override
        public boolean isEmpty() {
            return this.index == this.array.length;
        }

        @Override
        public void clear() {
            this.index = this.array.length;
        }

        @Override
        public int size() {
            return this.array.length - this.index;
        }
    }

    static final class ArraySubscription<T>
    implements Producer,
    Trackable,
    MultiReceiver,
    Fuseable.SynchronousSubscription<T> {
        final Subscriber<? super T> actual;
        final T[] array;
        int index;
        volatile boolean cancelled;
        volatile long requested;
        static final AtomicLongFieldUpdater<ArraySubscription> REQUESTED = AtomicLongFieldUpdater.newUpdater(ArraySubscription.class, "requested");

        public ArraySubscription(Subscriber<? super T> actual, T[] array) {
            this.actual = actual;
            this.array = array;
        }

        public void request(long n) {
            if (Operators.validate(n) && Operators.getAndAddCap(REQUESTED, this, n) == 0L) {
                if (n == Long.MAX_VALUE) {
                    this.fastPath();
                } else {
                    this.slowPath(n);
                }
            }
        }

        void slowPath(long n) {
            T[] a = this.array;
            int len = a.length;
            Subscriber<? super T> s = this.actual;
            int i = this.index;
            int e = 0;
            while (!this.cancelled) {
                while (i != len && (long)e != n) {
                    T t = a[i];
                    if (t == null) {
                        s.onError((Throwable)new NullPointerException("The " + i + "th array element was null"));
                        return;
                    }
                    s.onNext(t);
                    if (this.cancelled) {
                        return;
                    }
                    ++i;
                    ++e;
                }
                if (i == len) {
                    s.onComplete();
                    return;
                }
                n = this.requested;
                if (n != (long)e) continue;
                this.index = i;
                n = REQUESTED.addAndGet(this, -e);
                if (n == 0L) {
                    return;
                }
                e = 0;
            }
            return;
        }

        void fastPath() {
            T[] a = this.array;
            int len = a.length;
            Subscriber<? super T> s = this.actual;
            for (int i = this.index; i != len; ++i) {
                if (this.cancelled) {
                    return;
                }
                T t = a[i];
                if (t == null) {
                    s.onError((Throwable)new NullPointerException("The " + i + "th array element was null"));
                    return;
                }
                s.onNext(t);
            }
            if (this.cancelled) {
                return;
            }
            s.onComplete();
        }

        public void cancel() {
            this.cancelled = true;
        }

        @Override
        public boolean isCancelled() {
            return this.cancelled;
        }

        @Override
        public Object downstream() {
            return this.actual;
        }

        @Override
        public long requestedFromDownstream() {
            return this.requested;
        }

        @Override
        public Iterator<?> upstreams() {
            return this.array instanceof Publisher[] ? Arrays.asList(this.array).iterator() : null;
        }

        @Override
        public long upstreamCount() {
            return this.array instanceof Publisher[] ? (long)this.array.length : -1L;
        }

        @Override
        public T poll() {
            int i = this.index;
            T[] a = this.array;
            if (i != a.length) {
                T t = a[i];
                if (t == null) {
                    throw new NullPointerException();
                }
                this.index = i + 1;
                return t;
            }
            return null;
        }

        @Override
        public boolean isEmpty() {
            return this.index == this.array.length;
        }

        @Override
        public void clear() {
            this.index = this.array.length;
        }

        @Override
        public int size() {
            return this.array.length - this.index;
        }
    }
}

