/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.LongConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.stream.Collector;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Disposable;
import reactor.core.Exceptions;
import reactor.core.Fuseable;
import reactor.core.publisher.BlockingFirstSubscriber;
import reactor.core.publisher.BlockingIterable;
import reactor.core.publisher.BlockingLastSubscriber;
import reactor.core.publisher.BufferOverflowStrategy;
import reactor.core.publisher.ConnectableFlux;
import reactor.core.publisher.FluxArray;
import reactor.core.publisher.FluxAwaitOnSubscribe;
import reactor.core.publisher.FluxBuffer;
import reactor.core.publisher.FluxBufferBoundary;
import reactor.core.publisher.FluxBufferPredicate;
import reactor.core.publisher.FluxBufferStartEnd;
import reactor.core.publisher.FluxBufferTimeOrSize;
import reactor.core.publisher.FluxCancelOn;
import reactor.core.publisher.FluxCombineLatest;
import reactor.core.publisher.FluxConcatArray;
import reactor.core.publisher.FluxConcatIterable;
import reactor.core.publisher.FluxConcatMap;
import reactor.core.publisher.FluxCreate;
import reactor.core.publisher.FluxDefaultIfEmpty;
import reactor.core.publisher.FluxDefer;
import reactor.core.publisher.FluxDelaySubscription;
import reactor.core.publisher.FluxDematerialize;
import reactor.core.publisher.FluxDetach;
import reactor.core.publisher.FluxDistinct;
import reactor.core.publisher.FluxDistinctFuseable;
import reactor.core.publisher.FluxDistinctUntilChanged;
import reactor.core.publisher.FluxDoFinally;
import reactor.core.publisher.FluxDoFinallyFuseable;
import reactor.core.publisher.FluxElapsed;
import reactor.core.publisher.FluxEmpty;
import reactor.core.publisher.FluxError;
import reactor.core.publisher.FluxFilter;
import reactor.core.publisher.FluxFilterFuseable;
import reactor.core.publisher.FluxFirstEmitting;
import reactor.core.publisher.FluxFlatMap;
import reactor.core.publisher.FluxFlattenIterable;
import reactor.core.publisher.FluxGenerate;
import reactor.core.publisher.FluxGroupBy;
import reactor.core.publisher.FluxGroupJoin;
import reactor.core.publisher.FluxHandle;
import reactor.core.publisher.FluxHandleFuseable;
import reactor.core.publisher.FluxHide;
import reactor.core.publisher.FluxInterval;
import reactor.core.publisher.FluxIterable;
import reactor.core.publisher.FluxJoin;
import reactor.core.publisher.FluxJust;
import reactor.core.publisher.FluxMap;
import reactor.core.publisher.FluxMapFuseable;
import reactor.core.publisher.FluxMapSignal;
import reactor.core.publisher.FluxMaterialize;
import reactor.core.publisher.FluxMerge;
import reactor.core.publisher.FluxMergeSequential;
import reactor.core.publisher.FluxNever;
import reactor.core.publisher.FluxOnBackpressureBuffer;
import reactor.core.publisher.FluxOnBackpressureBufferStrategy;
import reactor.core.publisher.FluxOnBackpressureDrop;
import reactor.core.publisher.FluxOnBackpressureLatest;
import reactor.core.publisher.FluxPeek;
import reactor.core.publisher.FluxPeekFuseable;
import reactor.core.publisher.FluxPeekStateful;
import reactor.core.publisher.FluxPublish;
import reactor.core.publisher.FluxPublishMulticast;
import reactor.core.publisher.FluxPublishOn;
import reactor.core.publisher.FluxRange;
import reactor.core.publisher.FluxRepeat;
import reactor.core.publisher.FluxRepeatPredicate;
import reactor.core.publisher.FluxRepeatWhen;
import reactor.core.publisher.FluxReplay;
import reactor.core.publisher.FluxResume;
import reactor.core.publisher.FluxRetry;
import reactor.core.publisher.FluxRetryPredicate;
import reactor.core.publisher.FluxRetryWhen;
import reactor.core.publisher.FluxSample;
import reactor.core.publisher.FluxSampleFirst;
import reactor.core.publisher.FluxSampleTimeout;
import reactor.core.publisher.FluxScan;
import reactor.core.publisher.FluxScanSeed;
import reactor.core.publisher.FluxSink;
import reactor.core.publisher.FluxSkip;
import reactor.core.publisher.FluxSkipLast;
import reactor.core.publisher.FluxSkipUntil;
import reactor.core.publisher.FluxSkipUntilOther;
import reactor.core.publisher.FluxSkipWhile;
import reactor.core.publisher.FluxSource;
import reactor.core.publisher.FluxStream;
import reactor.core.publisher.FluxSubscribeOn;
import reactor.core.publisher.FluxSubscribeOnCallable;
import reactor.core.publisher.FluxSubscribeOnValue;
import reactor.core.publisher.FluxSwitchIfEmpty;
import reactor.core.publisher.FluxSwitchMap;
import reactor.core.publisher.FluxTake;
import reactor.core.publisher.FluxTakeFuseable;
import reactor.core.publisher.FluxTakeLast;
import reactor.core.publisher.FluxTakeLastOne;
import reactor.core.publisher.FluxTakeUntil;
import reactor.core.publisher.FluxTakeUntilOther;
import reactor.core.publisher.FluxTakeWhile;
import reactor.core.publisher.FluxTimeout;
import reactor.core.publisher.FluxUsing;
import reactor.core.publisher.FluxWindow;
import reactor.core.publisher.FluxWindowBoundary;
import reactor.core.publisher.FluxWindowOnCancel;
import reactor.core.publisher.FluxWindowStartEnd;
import reactor.core.publisher.FluxWindowTimeOrSize;
import reactor.core.publisher.FluxWithLatestFrom;
import reactor.core.publisher.FluxZip;
import reactor.core.publisher.FluxZipIterable;
import reactor.core.publisher.GroupedFlux;
import reactor.core.publisher.Hooks;
import reactor.core.publisher.LambdaSubscriber;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoAll;
import reactor.core.publisher.MonoAny;
import reactor.core.publisher.MonoCallable;
import reactor.core.publisher.MonoCollect;
import reactor.core.publisher.MonoCollectList;
import reactor.core.publisher.MonoCount;
import reactor.core.publisher.MonoElementAt;
import reactor.core.publisher.MonoHasElements;
import reactor.core.publisher.MonoIgnoreThen;
import reactor.core.publisher.MonoProcessor;
import reactor.core.publisher.MonoReduce;
import reactor.core.publisher.MonoReduceSeed;
import reactor.core.publisher.MonoSingle;
import reactor.core.publisher.MonoSource;
import reactor.core.publisher.MonoStreamCollector;
import reactor.core.publisher.MonoSupplier;
import reactor.core.publisher.MonoTakeLastOne;
import reactor.core.publisher.MutableNextSignal;
import reactor.core.publisher.ParallelFlux;
import reactor.core.publisher.Signal;
import reactor.core.publisher.SignalLogger;
import reactor.core.publisher.SignalType;
import reactor.core.publisher.SynchronousSink;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;
import reactor.core.scheduler.TimedScheduler;
import reactor.util.concurrent.QueueSupplier;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuple3;
import reactor.util.function.Tuple4;
import reactor.util.function.Tuple5;
import reactor.util.function.Tuple6;
import reactor.util.function.Tuples;

public abstract class Flux<T>
implements Publisher<T> {
    static final BiFunction TUPLE2_BIFUNCTION = Tuples::of;
    static final Supplier LIST_SUPPLIER = ArrayList::new;
    static final Supplier SET_SUPPLIER = HashSet::new;
    static final BooleanSupplier ALWAYS_BOOLEAN_SUPPLIER = () -> true;
    static final Function HASHCODE_EXTRACTOR = Object::hashCode;
    static final Function IDENTITY_FUNCTION = Function.identity();

    @SafeVarargs
    public static <T, V> Flux<V> combineLatest(Function<Object[], V> combinator, Publisher<? extends T> ... sources) {
        return Flux.combineLatest(combinator, QueueSupplier.XS_BUFFER_SIZE, sources);
    }

    @SafeVarargs
    public static <T, V> Flux<V> combineLatest(Function<Object[], V> combinator, int prefetch, Publisher<? extends T> ... sources) {
        if (sources.length == 0) {
            return Flux.empty();
        }
        if (sources.length == 1) {
            Publisher<? extends T> source = sources[0];
            if (source instanceof Fuseable) {
                return Flux.onAssembly(new FluxMapFuseable<Object, Object>(source, v -> combinator.apply(new Object[]{v})));
            }
            return Flux.onAssembly(new FluxMap<Object, Object>(source, v -> combinator.apply(new Object[]{v})));
        }
        return Flux.onAssembly(new FluxCombineLatest<T, V>(sources, combinator, QueueSupplier.get(prefetch), prefetch));
    }

    public static <T1, T2, V> Flux<V> combineLatest(Publisher<? extends T1> source1, Publisher<? extends T2> source2, BiFunction<? super T1, ? super T2, ? extends V> combinator) {
        return Flux.combineLatest((Object[] tuple) -> combinator.apply((Object)tuple[0], (Object)tuple[1]), source1, source2);
    }

    public static <T1, T2, T3, V> Flux<V> combineLatest(Publisher<? extends T1> source1, Publisher<? extends T2> source2, Publisher<? extends T3> source3, Function<Object[], V> combinator) {
        return Flux.combineLatest(combinator, source1, source2, source3);
    }

    public static <T1, T2, T3, T4, V> Flux<V> combineLatest(Publisher<? extends T1> source1, Publisher<? extends T2> source2, Publisher<? extends T3> source3, Publisher<? extends T4> source4, Function<Object[], V> combinator) {
        return Flux.combineLatest(combinator, source1, source2, source3, source4);
    }

    public static <T1, T2, T3, T4, T5, V> Flux<V> combineLatest(Publisher<? extends T1> source1, Publisher<? extends T2> source2, Publisher<? extends T3> source3, Publisher<? extends T4> source4, Publisher<? extends T5> source5, Function<Object[], V> combinator) {
        return Flux.combineLatest(combinator, source1, source2, source3, source4, source5);
    }

    public static <T1, T2, T3, T4, T5, T6, V> Flux<V> combineLatest(Publisher<? extends T1> source1, Publisher<? extends T2> source2, Publisher<? extends T3> source3, Publisher<? extends T4> source4, Publisher<? extends T5> source5, Publisher<? extends T6> source6, Function<Object[], V> combinator) {
        return Flux.combineLatest(combinator, source1, source2, source3, source4, source5, source6);
    }

    public static <T, V> Flux<V> combineLatest(Iterable<? extends Publisher<? extends T>> sources, Function<Object[], V> combinator) {
        return Flux.combineLatest(sources, QueueSupplier.XS_BUFFER_SIZE, combinator);
    }

    public static <T, V> Flux<V> combineLatest(Iterable<? extends Publisher<? extends T>> sources, int prefetch, Function<Object[], V> combinator) {
        return Flux.onAssembly(new FluxCombineLatest(sources, combinator, QueueSupplier.get(prefetch), prefetch));
    }

    public static <T> Flux<T> concat(Iterable<? extends Publisher<? extends T>> sources) {
        return Flux.onAssembly(new FluxConcatIterable(sources));
    }

    public static <T> Flux<T> concat(Publisher<? extends Publisher<? extends T>> sources) {
        return Flux.concat(sources, QueueSupplier.XS_BUFFER_SIZE);
    }

    public static <T> Flux<T> concat(Publisher<? extends Publisher<? extends T>> sources, int prefetch) {
        return Flux.onAssembly(new FluxConcatMap(sources, Flux.identityFunction(), QueueSupplier.get(prefetch), prefetch, FluxConcatMap.ErrorMode.IMMEDIATE));
    }

    @SafeVarargs
    public static <T> Flux<T> concat(Publisher<? extends T> ... sources) {
        return Flux.onAssembly(new FluxConcatArray<T>(false, sources));
    }

    public static <T> Flux<T> concatDelayError(Publisher<? extends Publisher<? extends T>> sources) {
        return Flux.concatDelayError(sources, QueueSupplier.XS_BUFFER_SIZE);
    }

    public static <T> Flux<T> concatDelayError(Publisher<? extends Publisher<? extends T>> sources, int prefetch) {
        return Flux.onAssembly(new FluxConcatMap(sources, Flux.identityFunction(), QueueSupplier.get(prefetch), prefetch, FluxConcatMap.ErrorMode.END));
    }

    public static <T> Flux<T> concatDelayError(Publisher<? extends Publisher<? extends T>> sources, boolean delayUntilEnd, int prefetch) {
        return Flux.onAssembly(new FluxConcatMap(sources, Flux.identityFunction(), QueueSupplier.get(prefetch), prefetch, delayUntilEnd ? FluxConcatMap.ErrorMode.END : FluxConcatMap.ErrorMode.BOUNDARY));
    }

    @SafeVarargs
    public static <T> Flux<T> concatDelayError(Publisher<? extends T> ... sources) {
        return Flux.onAssembly(new FluxConcatArray<T>(true, sources));
    }

    public static <T> Flux<T> create(Consumer<? super FluxSink<T>> emitter) {
        return Flux.create(emitter, FluxSink.OverflowStrategy.BUFFER);
    }

    public static <T> Flux<T> create(Consumer<? super FluxSink<T>> emitter, FluxSink.OverflowStrategy backpressure) {
        return Flux.onAssembly(new FluxCreate(emitter, backpressure));
    }

    public static <T> Flux<T> defer(Supplier<? extends Publisher<T>> supplier) {
        return Flux.onAssembly(new FluxDefer(supplier));
    }

    public static <T> Flux<T> empty() {
        return FluxEmpty.instance();
    }

    public static <T> Flux<T> error(Throwable error) {
        return Flux.error(error, false);
    }

    public static <O> Flux<O> error(Throwable throwable, boolean whenRequested) {
        return Flux.onAssembly(new FluxError(throwable, whenRequested));
    }

    @SafeVarargs
    public static <I> Flux<I> firstEmitting(Publisher<? extends I> ... sources) {
        return Flux.onAssembly(new FluxFirstEmitting<I>(sources));
    }

    public static <I> Flux<I> firstEmitting(Iterable<? extends Publisher<? extends I>> sources) {
        return Flux.onAssembly(new FluxFirstEmitting(sources));
    }

    public static <T> Flux<T> from(Publisher<? extends T> source) {
        if (source instanceof Flux) {
            Flux casted = (Flux)source;
            return casted;
        }
        if (source instanceof Fuseable.ScalarCallable) {
            Object t = ((Fuseable.ScalarCallable)source).call();
            if (t != null) {
                return Flux.just(t);
            }
            return Flux.empty();
        }
        return FluxSource.wrap(source);
    }

    public static <T> Flux<T> fromArray(T[] array) {
        if (array.length == 0) {
            return Flux.empty();
        }
        if (array.length == 1) {
            return Flux.just(array[0]);
        }
        return Flux.onAssembly(new FluxArray<T>(array));
    }

    public static <T> Flux<T> fromIterable(Iterable<? extends T> it) {
        return Flux.onAssembly(new FluxIterable<T>(it));
    }

    public static <T> Flux<T> fromStream(Stream<? extends T> s) {
        return Flux.onAssembly(new FluxStream<T>(s));
    }

    public static <T> Flux<T> generate(Consumer<SynchronousSink<T>> generator) {
        Objects.requireNonNull(generator, "generator");
        return Flux.onAssembly(new FluxGenerate(generator));
    }

    public static <T, S> Flux<T> generate(Callable<S> stateSupplier, BiFunction<S, SynchronousSink<T>, S> generator) {
        return Flux.onAssembly(new FluxGenerate<T, S>(stateSupplier, generator));
    }

    public static <T, S> Flux<T> generate(Callable<S> stateSupplier, BiFunction<S, SynchronousSink<T>, S> generator, Consumer<? super S> stateConsumer) {
        return Flux.onAssembly(new FluxGenerate<T, S>(stateSupplier, generator, stateConsumer));
    }

    public static Flux<Long> interval(Duration period) {
        return Flux.intervalMillis(period.toMillis());
    }

    public static Flux<Long> interval(Duration delay, Duration period) {
        return Flux.intervalMillis(delay.toMillis(), period.toMillis());
    }

    public static Flux<Long> intervalMillis(long period) {
        return Flux.intervalMillis(period, Schedulers.timer());
    }

    public static Flux<Long> intervalMillis(long period, TimedScheduler timer) {
        return Flux.onAssembly(new FluxInterval(period, period, TimeUnit.MILLISECONDS, timer));
    }

    public static Flux<Long> intervalMillis(long delay, long period) {
        return Flux.intervalMillis(delay, period, Schedulers.timer());
    }

    public static Flux<Long> intervalMillis(long delay, long period, TimedScheduler timer) {
        return Flux.onAssembly(new FluxInterval(delay, period, TimeUnit.MILLISECONDS, timer));
    }

    @SafeVarargs
    public static <T> Flux<T> just(T ... data) {
        return Flux.fromArray(data);
    }

    public static <T> Flux<T> just(T data) {
        return Flux.onAssembly(new FluxJust<T>(data));
    }

    public static <T> Flux<T> merge(Publisher<? extends Publisher<? extends T>> source) {
        return Flux.merge(source, QueueSupplier.SMALL_BUFFER_SIZE, QueueSupplier.XS_BUFFER_SIZE);
    }

    public static <T> Flux<T> merge(Publisher<? extends Publisher<? extends T>> source, int concurrency) {
        return Flux.merge(source, concurrency, QueueSupplier.XS_BUFFER_SIZE);
    }

    public static <T> Flux<T> merge(Publisher<? extends Publisher<? extends T>> source, int concurrency, int prefetch) {
        return Flux.onAssembly(new FluxFlatMap(source, Flux.identityFunction(), false, concurrency, QueueSupplier.get(concurrency), prefetch, QueueSupplier.get(prefetch)));
    }

    public static <I> Flux<I> merge(Iterable<? extends Publisher<? extends I>> sources) {
        return Flux.merge(Flux.fromIterable(sources));
    }

    @SafeVarargs
    public static <I> Flux<I> merge(Publisher<? extends I> ... sources) {
        return Flux.merge(QueueSupplier.XS_BUFFER_SIZE, sources);
    }

    @SafeVarargs
    public static <I> Flux<I> merge(int prefetch, Publisher<? extends I> ... sources) {
        return Flux.merge(prefetch, false, sources);
    }

    @SafeVarargs
    public static <I> Flux<I> merge(int prefetch, boolean delayError, Publisher<? extends I> ... sources) {
        if (sources.length == 0) {
            return Flux.empty();
        }
        if (sources.length == 1) {
            return Flux.from(sources[0]);
        }
        return Flux.onAssembly(new FluxMerge<I>(sources, delayError, sources.length, QueueSupplier.get(sources.length), prefetch, QueueSupplier.get(prefetch)));
    }

    public static <T> Flux<T> mergeSequential(Publisher<? extends Publisher<? extends T>> sources) {
        return Flux.mergeSequential(sources, false, QueueSupplier.SMALL_BUFFER_SIZE, QueueSupplier.XS_BUFFER_SIZE);
    }

    public static <T> Flux<T> mergeSequential(Publisher<? extends Publisher<? extends T>> sources, boolean delayError, int maxConcurrency, int prefetch) {
        return Flux.onAssembly(new FluxMergeSequential(sources, Flux.identityFunction(), maxConcurrency, prefetch, delayError ? FluxConcatMap.ErrorMode.END : FluxConcatMap.ErrorMode.IMMEDIATE));
    }

    @SafeVarargs
    public static <I> Flux<I> mergeSequential(Publisher<? extends I> ... sources) {
        return Flux.mergeSequential(QueueSupplier.XS_BUFFER_SIZE, false, sources);
    }

    @SafeVarargs
    public static <I> Flux<I> mergeSequential(int prefetch, boolean delayError, Publisher<? extends I> ... sources) {
        if (sources.length == 0) {
            return Flux.empty();
        }
        if (sources.length == 1) {
            return Flux.from(sources[0]);
        }
        return Flux.onAssembly(new FluxMergeSequential(new FluxArray<Publisher<? extends I>>(sources), Flux.identityFunction(), sources.length, prefetch, delayError ? FluxConcatMap.ErrorMode.END : FluxConcatMap.ErrorMode.IMMEDIATE));
    }

    public static <I> Flux<I> mergeSequential(Iterable<? extends Publisher<? extends I>> sources) {
        return Flux.mergeSequential(sources, false, QueueSupplier.SMALL_BUFFER_SIZE, QueueSupplier.XS_BUFFER_SIZE);
    }

    public static <I> Flux<I> mergeSequential(Iterable<? extends Publisher<? extends I>> sources, boolean delayError, int maxConcurrency, int prefetch) {
        return Flux.onAssembly(new FluxMergeSequential(new FluxIterable<Publisher<? extends I>>(sources), Flux.identityFunction(), maxConcurrency, prefetch, delayError ? FluxConcatMap.ErrorMode.END : FluxConcatMap.ErrorMode.IMMEDIATE));
    }

    public static <T> Flux<T> never() {
        return FluxNever.instance();
    }

    public static Flux<Integer> range(int start, int count) {
        if (count == 1) {
            return Flux.just(Integer.valueOf(start));
        }
        if (count == 0) {
            return Flux.empty();
        }
        return Flux.onAssembly(new FluxRange(start, count));
    }

    public static <T> Flux<T> switchOnNext(Publisher<? extends Publisher<? extends T>> mergedPublishers) {
        return Flux.switchOnNext(mergedPublishers, QueueSupplier.XS_BUFFER_SIZE);
    }

    public static <T> Flux<T> switchOnNext(Publisher<? extends Publisher<? extends T>> mergedPublishers, int prefetch) {
        return Flux.onAssembly(new FluxSwitchMap(mergedPublishers, Flux.identityFunction(), QueueSupplier.get(prefetch), prefetch));
    }

    public static <T, D> Flux<T> using(Callable<? extends D> resourceSupplier, Function<? super D, ? extends Publisher<? extends T>> sourceSupplier, Consumer<? super D> resourceCleanup) {
        return Flux.using(resourceSupplier, sourceSupplier, resourceCleanup, true);
    }

    public static <T, D> Flux<T> using(Callable<? extends D> resourceSupplier, Function<? super D, ? extends Publisher<? extends T>> sourceSupplier, Consumer<? super D> resourceCleanup, boolean eager) {
        return Flux.onAssembly(new FluxUsing(resourceSupplier, sourceSupplier, resourceCleanup, eager));
    }

    public static <T1, T2, O> Flux<O> zip(Publisher<? extends T1> source1, Publisher<? extends T2> source2, BiFunction<? super T1, ? super T2, ? extends O> combinator) {
        return Flux.onAssembly(new FluxZip<T1, O>(source1, source2, combinator, QueueSupplier.xs(), QueueSupplier.XS_BUFFER_SIZE));
    }

    public static <T1, T2> Flux<Tuple2<T1, T2>> zip(Publisher<? extends T1> source1, Publisher<? extends T2> source2) {
        return Flux.zip(source1, source2, Flux.tuple2Function());
    }

    public static <T1, T2, T3> Flux<Tuple3<T1, T2, T3>> zip(Publisher<? extends T1> source1, Publisher<? extends T2> source2, Publisher<? extends T3> source3) {
        return Flux.zip(Tuples.fn3(), source1, source2, source3);
    }

    public static <T1, T2, T3, T4> Flux<Tuple4<T1, T2, T3, T4>> zip(Publisher<? extends T1> source1, Publisher<? extends T2> source2, Publisher<? extends T3> source3, Publisher<? extends T4> source4) {
        return Flux.zip(Tuples.fn4(), source1, source2, source3, source4);
    }

    public static <T1, T2, T3, T4, T5> Flux<Tuple5<T1, T2, T3, T4, T5>> zip(Publisher<? extends T1> source1, Publisher<? extends T2> source2, Publisher<? extends T3> source3, Publisher<? extends T4> source4, Publisher<? extends T5> source5) {
        return Flux.zip(Tuples.fn5(), source1, source2, source3, source4, source5);
    }

    public static <T1, T2, T3, T4, T5, T6> Flux<Tuple6<T1, T2, T3, T4, T5, T6>> zip(Publisher<? extends T1> source1, Publisher<? extends T2> source2, Publisher<? extends T3> source3, Publisher<? extends T4> source4, Publisher<? extends T5> source5, Publisher<? extends T6> source6) {
        return Flux.zip(Tuples.fn6(), source1, source2, source3, source4, source5, source6);
    }

    public static Flux<Tuple2> zip(Iterable<? extends Publisher<?>> sources) {
        return Flux.zip(sources, Tuples.fnAny());
    }

    public static <O> Flux<O> zip(Iterable<? extends Publisher<?>> sources, Function<? super Object[], ? extends O> combinator) {
        return Flux.zip(sources, QueueSupplier.XS_BUFFER_SIZE, combinator);
    }

    public static <O> Flux<O> zip(Iterable<? extends Publisher<?>> sources, int prefetch, Function<? super Object[], ? extends O> combinator) {
        return Flux.onAssembly(new FluxZip(sources, combinator, QueueSupplier.get(prefetch), prefetch));
    }

    @SafeVarargs
    public static <I, O> Flux<O> zip(Function<? super Object[], ? extends O> combinator, Publisher<? extends I> ... sources) {
        return Flux.zip(combinator, QueueSupplier.XS_BUFFER_SIZE, sources);
    }

    @SafeVarargs
    public static <I, O> Flux<O> zip(Function<? super Object[], ? extends O> combinator, int prefetch, Publisher<? extends I> ... sources) {
        if (sources.length == 0) {
            return Flux.empty();
        }
        if (sources.length == 1) {
            Publisher<? extends I> source = sources[0];
            if (source instanceof Fuseable) {
                return Flux.onAssembly(new FluxMapFuseable<Object, Object>(source, v -> combinator.apply(new Object[]{v})));
            }
            return Flux.onAssembly(new FluxMap<Object, Object>(source, v -> combinator.apply(new Object[]{v})));
        }
        return Flux.onAssembly(new FluxZip<I, O>(sources, combinator, QueueSupplier.get(prefetch), prefetch));
    }

    public static <TUPLE extends Tuple2, V> Flux<V> zip(Publisher<? extends Publisher<?>> sources, final Function<? super TUPLE, ? extends V> combinator) {
        return Flux.onAssembly(new FluxBuffer(sources, Integer.MAX_VALUE, Flux.listSupplier()).flatMap(new Function<List<? extends Publisher<?>>, Publisher<V>>(){

            @Override
            public Publisher<V> apply(List<? extends Publisher<?>> publishers) {
                return Flux.zip(Tuples.fnAny(combinator), publishers.toArray(new Publisher[publishers.size()]));
            }
        }));
    }

    public final Mono<Boolean> all(Predicate<? super T> predicate) {
        return Mono.onAssembly(new MonoAll<T>(this, predicate));
    }

    public final Mono<Boolean> any(Predicate<? super T> predicate) {
        return Mono.onAssembly(new MonoAny<T>(this, predicate));
    }

    public final <P> P as(Function<? super Flux<T>, P> transformer) {
        return transformer.apply(this);
    }

    public final Flux<T> awaitOnSubscribe() {
        return Flux.onAssembly(new FluxAwaitOnSubscribe(this));
    }

    public final T blockFirst() {
        BlockingFirstSubscriber subscriber = new BlockingFirstSubscriber();
        this.subscribe(subscriber);
        return subscriber.blockingGet();
    }

    public final T blockFirst(Duration d) {
        return this.blockFirstMillis(d.toMillis());
    }

    public final T blockFirstMillis(long timeout) {
        BlockingFirstSubscriber subscriber = new BlockingFirstSubscriber();
        this.subscribe(subscriber);
        return subscriber.blockingGet(timeout, TimeUnit.MILLISECONDS);
    }

    public final T blockLast() {
        BlockingLastSubscriber subscriber = new BlockingLastSubscriber();
        this.subscribe(subscriber);
        return subscriber.blockingGet();
    }

    public final T blockLast(Duration d) {
        return this.blockLastMillis(d.toMillis());
    }

    public final T blockLastMillis(long timeout) {
        BlockingLastSubscriber subscriber = new BlockingLastSubscriber();
        this.subscribe(subscriber);
        return subscriber.blockingGet(timeout, TimeUnit.MILLISECONDS);
    }

    public final Flux<List<T>> buffer() {
        return this.buffer(Integer.MAX_VALUE);
    }

    public final Flux<List<T>> buffer(int maxSize) {
        return this.buffer(maxSize, Flux.listSupplier());
    }

    public final <C extends Collection<? super T>> Flux<C> buffer(int maxSize, Supplier<C> bufferSupplier) {
        return Flux.onAssembly(new FluxBuffer(this, maxSize, bufferSupplier));
    }

    public final Flux<List<T>> buffer(int maxSize, int skip) {
        return this.buffer(maxSize, skip, Flux.listSupplier());
    }

    public final <C extends Collection<? super T>> Flux<C> buffer(int maxSize, int skip, Supplier<C> bufferSupplier) {
        return Flux.onAssembly(new FluxBuffer(this, maxSize, skip, bufferSupplier));
    }

    public final Flux<List<T>> buffer(Publisher<?> other) {
        return this.buffer(other, Flux.listSupplier());
    }

    public final <C extends Collection<? super T>> Flux<C> buffer(Publisher<?> other, Supplier<C> bufferSupplier) {
        return Flux.onAssembly(new FluxBufferBoundary(this, other, bufferSupplier));
    }

    public final <U, V> Flux<List<T>> buffer(Publisher<U> bucketOpening, Function<? super U, ? extends Publisher<V>> closeSelector) {
        return this.buffer(bucketOpening, closeSelector, Flux.listSupplier());
    }

    public final <U, V, C extends Collection<? super T>> Flux<C> buffer(Publisher<U> bucketOpening, Function<? super U, ? extends Publisher<V>> closeSelector, Supplier<C> bufferSupplier) {
        return Flux.onAssembly(new FluxBufferStartEnd(this, bucketOpening, closeSelector, bufferSupplier, QueueSupplier.xs()));
    }

    public final Flux<List<T>> buffer(Duration timespan) {
        return this.bufferMillis(timespan.toMillis(), Schedulers.timer());
    }

    public final Flux<List<T>> buffer(Duration timespan, Duration timeshift) {
        return this.bufferMillis(timespan.toMillis(), timeshift.toMillis(), Schedulers.timer());
    }

    public final Flux<List<T>> buffer(int maxSize, Duration timespan) {
        return this.buffer(maxSize, timespan, Flux.listSupplier());
    }

    public final <C extends Collection<? super T>> Flux<C> buffer(int maxSize, Duration timespan, Supplier<C> bufferSupplier) {
        return this.bufferMillis(maxSize, timespan.toMillis(), Schedulers.timer(), bufferSupplier);
    }

    public final Flux<List<T>> bufferMillis(long timespan) {
        return this.bufferMillis(timespan, Schedulers.timer());
    }

    public final Flux<List<T>> bufferMillis(long timespan, TimedScheduler timer) {
        return this.buffer(Flux.intervalMillis(timespan, timer));
    }

    public final Flux<List<T>> bufferMillis(long timespan, long timeshift) {
        return this.bufferMillis(timespan, timeshift, Schedulers.timer());
    }

    public final Flux<List<T>> bufferMillis(long timespan, long timeshift, TimedScheduler timer) {
        if (timespan == timeshift) {
            return this.bufferMillis(timespan, timer);
        }
        return this.buffer(Flux.intervalMillis(0L, timeshift, timer), (? super U aLong) -> Mono.delayMillis(timespan, timer));
    }

    public final Flux<List<T>> bufferMillis(int maxSize, long timespan) {
        return this.bufferMillis(maxSize, timespan, Schedulers.timer());
    }

    public final Flux<List<T>> bufferMillis(int maxSize, long timespan, TimedScheduler timer) {
        return this.bufferMillis(maxSize, timespan, timer, Flux.listSupplier());
    }

    public final <C extends Collection<? super T>> Flux<C> bufferMillis(int maxSize, long timespan, TimedScheduler timer, Supplier<C> bufferSupplier) {
        return Flux.onAssembly(new FluxBufferTimeOrSize(this, maxSize, timespan, timer, bufferSupplier));
    }

    public final Flux<List<T>> bufferUntil(Predicate<? super T> predicate) {
        return Flux.onAssembly(new FluxBufferPredicate(this, predicate, Flux.listSupplier(), FluxBufferPredicate.Mode.UNTIL));
    }

    public final Flux<List<T>> bufferUntil(Predicate<? super T> predicate, boolean cutBefore) {
        return Flux.onAssembly(new FluxBufferPredicate(this, predicate, Flux.listSupplier(), cutBefore ? FluxBufferPredicate.Mode.UNTIL_CUT_BEFORE : FluxBufferPredicate.Mode.UNTIL));
    }

    public final Flux<List<T>> bufferWhile(Predicate<? super T> predicate) {
        return Flux.onAssembly(new FluxBufferPredicate(this, predicate, Flux.listSupplier(), FluxBufferPredicate.Mode.WHILE));
    }

    public final Flux<T> cache() {
        return this.cache(Integer.MAX_VALUE);
    }

    public final Flux<T> cache(int history) {
        return this.replay(history).autoConnect();
    }

    public final Flux<T> cache(Duration ttl) {
        return this.replay(Integer.MAX_VALUE, ttl).autoConnect();
    }

    public final Flux<T> cache(int history, Duration ttl) {
        return this.replay(history, ttl).autoConnect();
    }

    public final <E> Flux<E> cast(Class<E> clazz) {
        Objects.requireNonNull(clazz, "clazz");
        return this.map(clazz::cast);
    }

    public final Flux<T> cancelOn(Scheduler scheduler) {
        return Flux.onAssembly(new FluxCancelOn(this, scheduler));
    }

    public final <E> Mono<E> collect(Supplier<E> containerSupplier, BiConsumer<E, ? super T> collector) {
        return Mono.onAssembly(new MonoCollect<T, E>(this, containerSupplier, collector));
    }

    public final <R, A> Mono<R> collect(Collector<T, A, R> collector) {
        return Mono.onAssembly(new MonoStreamCollector<T, A, R>(this, collector));
    }

    public final Mono<List<T>> collectList() {
        if (this instanceof Callable) {
            if (this instanceof Fuseable.ScalarCallable) {
                Fuseable.ScalarCallable scalarCallable = (Fuseable.ScalarCallable)((Object)this);
                Object v = scalarCallable.call();
                if (v == null) {
                    return Mono.onAssembly(new MonoSupplier(Flux.listSupplier()));
                }
                return Mono.just(v).map((? super T u) -> {
                    List list = Flux.listSupplier().get();
                    list.add(u);
                    return list;
                });
            }
            Callable thiz = (Callable)((Object)this);
            return Mono.onAssembly(new MonoCallable<Object>(thiz).map((? super T u) -> {
                List list = Flux.listSupplier().get();
                list.add(u);
                return list;
            }));
        }
        return Mono.onAssembly(new MonoCollectList(this, Flux.listSupplier()));
    }

    public final <K> Mono<Map<K, T>> collectMap(Function<? super T, ? extends K> keyExtractor) {
        return this.collectMap(keyExtractor, Flux.identityFunction());
    }

    public final <K, V> Mono<Map<K, V>> collectMap(Function<? super T, ? extends K> keyExtractor, Function<? super T, ? extends V> valueExtractor) {
        return this.collectMap(keyExtractor, valueExtractor, () -> new HashMap());
    }

    public final <K, V> Mono<Map<K, V>> collectMap(Function<? super T, ? extends K> keyExtractor, Function<? super T, ? extends V> valueExtractor, Supplier<Map<K, V>> mapSupplier) {
        Objects.requireNonNull(keyExtractor, "Key extractor is null");
        Objects.requireNonNull(valueExtractor, "Value extractor is null");
        Objects.requireNonNull(mapSupplier, "Map supplier is null");
        return this.collect(mapSupplier, (m, d) -> m.put(keyExtractor.apply(d), valueExtractor.apply(d)));
    }

    public final <K> Mono<Map<K, Collection<T>>> collectMultimap(Function<? super T, ? extends K> keyExtractor) {
        return this.collectMultimap(keyExtractor, Flux.identityFunction());
    }

    public final <K, V> Mono<Map<K, Collection<V>>> collectMultimap(Function<? super T, ? extends K> keyExtractor, Function<? super T, ? extends V> valueExtractor) {
        return this.collectMultimap(keyExtractor, valueExtractor, () -> new HashMap());
    }

    public final <K, V> Mono<Map<K, Collection<V>>> collectMultimap(Function<? super T, ? extends K> keyExtractor, Function<? super T, ? extends V> valueExtractor, Supplier<Map<K, Collection<V>>> mapSupplier) {
        Objects.requireNonNull(keyExtractor, "Key extractor is null");
        Objects.requireNonNull(valueExtractor, "Value extractor is null");
        Objects.requireNonNull(mapSupplier, "Map supplier is null");
        return this.collect(mapSupplier, (m, d) -> {
            Object key = keyExtractor.apply(d);
            ArrayList values = (ArrayList)m.get(key);
            if (values == null) {
                values = new ArrayList();
                m.put(key, values);
            }
            values.add(valueExtractor.apply(d));
        });
    }

    public final Mono<List<T>> collectSortedList() {
        return this.collectSortedList(null);
    }

    public final Mono<List<T>> collectSortedList(Comparator<? super T> comparator) {
        return this.collectList().map((? super T list) -> {
            if (comparator != null) {
                Collections.sort(list, comparator);
            } else {
                List l = list;
                Collections.sort(l);
            }
            return list;
        });
    }

    public final <V> Flux<V> compose(Function<? super Flux<T>, ? extends Publisher<V>> transformer) {
        return Flux.defer(() -> (Publisher)transformer.apply(this));
    }

    public final <V> Flux<V> concatMap(Function<? super T, ? extends Publisher<? extends V>> mapper) {
        return this.concatMap(mapper, QueueSupplier.XS_BUFFER_SIZE);
    }

    public final <V> Flux<V> concatMap(Function<? super T, ? extends Publisher<? extends V>> mapper, int prefetch) {
        return Flux.onAssembly(new FluxConcatMap(this, mapper, QueueSupplier.get(prefetch), prefetch, FluxConcatMap.ErrorMode.IMMEDIATE));
    }

    public final <V> Flux<V> concatMapDelayError(Function<? super T, Publisher<? extends V>> mapper) {
        return this.concatMapDelayError(mapper, QueueSupplier.XS_BUFFER_SIZE);
    }

    public final <V> Flux<V> concatMapDelayError(Function<? super T, ? extends Publisher<? extends V>> mapper, int prefetch) {
        return Flux.onAssembly(new FluxConcatMap(this, mapper, QueueSupplier.get(prefetch), prefetch, FluxConcatMap.ErrorMode.BOUNDARY));
    }

    public final <V> Flux<V> concatMapDelayError(Function<? super T, ? extends Publisher<? extends V>> mapper, boolean delayUntilEnd, int prefetch) {
        return Flux.onAssembly(new FluxConcatMap(this, mapper, QueueSupplier.get(prefetch), prefetch, delayUntilEnd ? FluxConcatMap.ErrorMode.END : FluxConcatMap.ErrorMode.BOUNDARY));
    }

    public final <R> Flux<R> concatMapIterable(Function<? super T, ? extends Iterable<? extends R>> mapper) {
        return this.concatMapIterable(mapper, QueueSupplier.XS_BUFFER_SIZE);
    }

    public final <R> Flux<R> concatMapIterable(Function<? super T, ? extends Iterable<? extends R>> mapper, int prefetch) {
        return Flux.onAssembly(new FluxFlattenIterable(this, mapper, prefetch, QueueSupplier.get(prefetch)));
    }

    public final Flux<T> concatWith(Publisher<? extends T> other) {
        if (this instanceof FluxConcatArray) {
            FluxConcatArray fluxConcatArray = (FluxConcatArray)this;
            return fluxConcatArray.concatAdditionalSourceLast(other);
        }
        return Flux.concat(this, other);
    }

    public final Mono<Long> count() {
        return Mono.onAssembly(new MonoCount(this));
    }

    public final Flux<T> defaultIfEmpty(T defaultV) {
        return Flux.onAssembly(new FluxDefaultIfEmpty<T>(this, defaultV));
    }

    public final Flux<T> delay(Duration delay) {
        return this.delayMillis(delay.toMillis());
    }

    public final Flux<T> delayMillis(long delay) {
        return this.delayMillis(delay, Schedulers.timer());
    }

    public final Flux<T> delayMillis(long delay, TimedScheduler timer) {
        return this.concatMap(t -> Mono.delayMillis(delay, timer).map((? super T i) -> t));
    }

    public final Flux<T> delaySubscription(Duration delay) {
        return this.delaySubscriptionMillis(delay.toMillis(), Schedulers.timer());
    }

    public final <U> Flux<T> delaySubscription(Publisher<U> subscriptionDelay) {
        return Flux.onAssembly(new FluxDelaySubscription(this, subscriptionDelay));
    }

    public final Flux<T> delaySubscriptionMillis(long delay) {
        return this.delaySubscriptionMillis(delay, Schedulers.timer());
    }

    public final Flux<T> delaySubscriptionMillis(long delay, TimedScheduler timer) {
        return this.delaySubscription(Mono.delayMillis(delay, timer));
    }

    public final <X> Flux<X> dematerialize() {
        Flux thiz = this;
        return Flux.onAssembly(new FluxDematerialize(thiz));
    }

    public final Flux<T> distinct() {
        return Flux.onAssembly(new FluxDistinct(this, Flux.hashcodeSupplier(), Flux.hashSetSupplier()));
    }

    public final <V> Flux<T> distinct(Function<? super T, ? extends V> keySelector) {
        if (this instanceof Fuseable) {
            return Flux.onAssembly(new FluxDistinctFuseable(this, keySelector, Flux.hashSetSupplier()));
        }
        return Flux.onAssembly(new FluxDistinct(this, keySelector, Flux.hashSetSupplier()));
    }

    public final Flux<T> distinctUntilChanged() {
        return this.distinctUntilChanged(Flux.hashcodeSupplier());
    }

    public final <V> Flux<T> distinctUntilChanged(Function<? super T, ? extends V> keySelector) {
        return Flux.onAssembly(new FluxDistinctUntilChanged<T, V>(this, keySelector));
    }

    public final Flux<T> doAfterTerminate(Runnable afterTerminate) {
        Objects.requireNonNull(afterTerminate, "afterTerminate");
        return Flux.doOnSignal(this, null, null, null, null, afterTerminate, null, null);
    }

    public final Flux<T> doOnCancel(Runnable onCancel) {
        Objects.requireNonNull(onCancel, "onCancel");
        return Flux.doOnSignal(this, null, null, null, null, null, null, onCancel);
    }

    public final Flux<T> doOnComplete(Runnable onComplete) {
        Objects.requireNonNull(onComplete, "onComplete");
        return Flux.doOnSignal(this, null, null, null, onComplete, null, null, null);
    }

    public final Flux<T> doOnEach(Consumer<? super Signal<T>> signalConsumer) {
        Objects.requireNonNull(signalConsumer, "signalConsumer");
        return Flux.doOnSignalStateful(this, MutableNextSignal::undefined, null, (v, s) -> signalConsumer.accept(s.mutate(v)), (e, s) -> signalConsumer.accept(Signal.error(e)), s -> signalConsumer.accept(Signal.complete()), null, null, null);
    }

    public final Flux<T> doOnError(Consumer<? super Throwable> onError) {
        Objects.requireNonNull(onError, "onError");
        return Flux.doOnSignal(this, null, null, onError, null, null, null, null);
    }

    public final <E extends Throwable> Flux<T> doOnError(Class<E> exceptionType, Consumer<? super E> onError) {
        Objects.requireNonNull(exceptionType, "type");
        Consumer<? super E> handler = onError;
        return this.doOnError(exceptionType::isInstance, handler);
    }

    public final Flux<T> doOnError(Predicate<? super Throwable> predicate, Consumer<? super Throwable> onError) {
        Objects.requireNonNull(predicate, "predicate");
        return this.doOnError(t -> {
            if (predicate.test((Throwable)t)) {
                onError.accept((Throwable)t);
            }
        });
    }

    public final Flux<T> doOnNext(Consumer<? super T> onNext) {
        Objects.requireNonNull(onNext, "onNext");
        return Flux.doOnSignal(this, null, onNext, null, null, null, null, null);
    }

    public final Flux<T> doOnRequest(LongConsumer consumer) {
        Objects.requireNonNull(consumer, "consumer");
        return Flux.doOnSignal(this, null, null, null, null, null, consumer, null);
    }

    public final Flux<T> doOnSubscribe(Consumer<? super Subscription> onSubscribe) {
        Objects.requireNonNull(onSubscribe, "onSubscribe");
        return Flux.doOnSignal(this, onSubscribe, null, null, null, null, null, null);
    }

    public final Flux<T> doOnTerminate(Runnable onTerminate) {
        Objects.requireNonNull(onTerminate, "onTerminate");
        return Flux.doOnSignal(this, null, null, e -> onTerminate.run(), onTerminate, null, null, null);
    }

    public final Flux<T> doFinally(Consumer<SignalType> onFinally) {
        Objects.requireNonNull(onFinally, "onFinally");
        FluxSource fluxDoFinally = this instanceof Fuseable ? new FluxDoFinallyFuseable(this, onFinally) : new FluxDoFinally(this, onFinally);
        return Flux.onAssembly(fluxDoFinally);
    }

    public final Flux<Tuple2<Long, T>> elapsed() {
        return this.elapsed(Schedulers.timer());
    }

    public final Flux<Tuple2<Long, T>> elapsed(TimedScheduler scheduler) {
        return Flux.onAssembly(new FluxElapsed(this, scheduler));
    }

    public final Mono<T> elementAt(int index) {
        return Mono.onAssembly(new MonoElementAt(this, index));
    }

    public final Mono<T> elementAt(int index, T defaultValue) {
        return Mono.onAssembly(new MonoElementAt<T>(this, index, defaultValue));
    }

    public final Flux<T> filter(Predicate<? super T> p) {
        if (this instanceof Fuseable) {
            return Flux.onAssembly(new FluxFilterFuseable<T>(this, p));
        }
        return Flux.onAssembly(new FluxFilter<T>(this, p));
    }

    public final Flux<T> firstEmittingWith(Publisher<? extends T> other) {
        FluxFirstEmitting publisherAmb;
        FluxFirstEmitting<? extends T> result;
        if (this instanceof FluxFirstEmitting && (result = (publisherAmb = (FluxFirstEmitting)this).ambAdditionalSource(other)) != null) {
            return result;
        }
        return Flux.firstEmitting(this, other);
    }

    public final <R> Flux<R> flatMap(Function<? super T, ? extends Publisher<? extends R>> mapper) {
        return this.flatMap(mapper, QueueSupplier.SMALL_BUFFER_SIZE, QueueSupplier.XS_BUFFER_SIZE);
    }

    public final <V> Flux<V> flatMap(Function<? super T, ? extends Publisher<? extends V>> mapper, int concurrency) {
        return this.flatMap(mapper, concurrency, QueueSupplier.XS_BUFFER_SIZE);
    }

    public final <V> Flux<V> flatMap(Function<? super T, ? extends Publisher<? extends V>> mapper, int concurrency, int prefetch) {
        return this.flatMap(mapper, false, concurrency, prefetch);
    }

    public final <V> Flux<V> flatMap(Function<? super T, ? extends Publisher<? extends V>> mapper, boolean delayError, int concurrency, int prefetch) {
        return Flux.onAssembly(new FluxFlatMap(this, mapper, delayError, concurrency, QueueSupplier.get(concurrency), prefetch, QueueSupplier.get(prefetch)));
    }

    public final <R> Flux<R> flatMap(Function<? super T, ? extends Publisher<? extends R>> mapperOnNext, Function<Throwable, ? extends Publisher<? extends R>> mapperOnError, Supplier<? extends Publisher<? extends R>> mapperOnComplete) {
        return Flux.onAssembly(new FluxFlatMap(new FluxMapSignal<T, Publisher<? extends R>>(this, mapperOnNext, mapperOnError, mapperOnComplete), Flux.identityFunction(), false, QueueSupplier.XS_BUFFER_SIZE, QueueSupplier.xs(), QueueSupplier.XS_BUFFER_SIZE, QueueSupplier.xs()));
    }

    public final <R> Flux<R> flatMapIterable(Function<? super T, ? extends Iterable<? extends R>> mapper) {
        return this.flatMapIterable(mapper, QueueSupplier.SMALL_BUFFER_SIZE);
    }

    public final <R> Flux<R> flatMapIterable(Function<? super T, ? extends Iterable<? extends R>> mapper, int prefetch) {
        return Flux.onAssembly(new FluxFlattenIterable(this, mapper, prefetch, QueueSupplier.get(prefetch)));
    }

    public final <R> Flux<R> flatMapSequential(Function<? super T, ? extends Publisher<? extends R>> mapper) {
        return this.flatMapSequential(mapper, QueueSupplier.SMALL_BUFFER_SIZE);
    }

    public final <R> Flux<R> flatMapSequential(Function<? super T, ? extends Publisher<? extends R>> mapper, int maxConcurrency) {
        return this.flatMapSequential(mapper, maxConcurrency, QueueSupplier.XS_BUFFER_SIZE);
    }

    public final <R> Flux<R> flatMapSequential(Function<? super T, ? extends Publisher<? extends R>> mapper, int maxConcurrency, int prefetch) {
        return this.flatMapSequential(mapper, false, maxConcurrency, prefetch);
    }

    public final <R> Flux<R> flatMapSequential(Function<? super T, ? extends Publisher<? extends R>> mapper, boolean delayError, int maxConcurrency, int prefetch) {
        return Flux.onAssembly(new FluxMergeSequential(this, mapper, maxConcurrency, prefetch, delayError ? FluxConcatMap.ErrorMode.END : FluxConcatMap.ErrorMode.IMMEDIATE));
    }

    public long getPrefetch() {
        return -1L;
    }

    public final <K> Flux<GroupedFlux<K, T>> groupBy(Function<? super T, ? extends K> keyMapper) {
        return this.groupBy(keyMapper, Flux.identityFunction());
    }

    public final <K, V> Flux<GroupedFlux<K, V>> groupBy(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper) {
        return Flux.onAssembly(new FluxGroupBy<T, K, V>(this, keyMapper, valueMapper, QueueSupplier.small(), QueueSupplier.unbounded(), QueueSupplier.SMALL_BUFFER_SIZE));
    }

    public final <TRight, TLeftEnd, TRightEnd, R> Flux<R> groupJoin(Publisher<? extends TRight> other, Function<? super T, ? extends Publisher<TLeftEnd>> leftEnd, Function<? super TRight, ? extends Publisher<TRightEnd>> rightEnd, BiFunction<? super T, ? super Flux<TRight>, ? extends R> resultSelector) {
        return new FluxGroupJoin(this, other, leftEnd, rightEnd, resultSelector, QueueSupplier.unbounded(QueueSupplier.XS_BUFFER_SIZE), QueueSupplier.unbounded(QueueSupplier.XS_BUFFER_SIZE));
    }

    public final <R> Flux<R> handle(BiConsumer<? super T, SynchronousSink<R>> handler) {
        if (this instanceof Fuseable) {
            return Flux.onAssembly(new FluxHandleFuseable<T, R>(this, handler));
        }
        return Flux.onAssembly(new FluxHandle<T, R>(this, handler));
    }

    public final Mono<Boolean> hasElement(T value) {
        return this.any(t -> Objects.equals(value, t));
    }

    public final Mono<Boolean> hasElements() {
        return Mono.onAssembly(new MonoHasElements(this));
    }

    public final Flux<T> hide() {
        return new FluxHide(this);
    }

    public final Mono<T> ignoreElements() {
        return Mono.ignoreElements(this);
    }

    public final <TRight, TLeftEnd, TRightEnd, R> Flux<R> join(Publisher<? extends TRight> other, Function<? super T, ? extends Publisher<TLeftEnd>> leftEnd, Function<? super TRight, ? extends Publisher<TRightEnd>> rightEnd, BiFunction<? super T, ? super TRight, ? extends R> resultSelector) {
        return new FluxJoin(this, other, leftEnd, rightEnd, resultSelector, QueueSupplier.unbounded(QueueSupplier.XS_BUFFER_SIZE));
    }

    public final Mono<T> last() {
        if (this instanceof Callable) {
            Callable thiz = (Callable)((Object)this);
            return Flux.convertToMono(thiz);
        }
        return Mono.onAssembly(new MonoTakeLastOne(this));
    }

    public final Mono<T> last(T defaultValue) {
        if (this instanceof Callable) {
            Callable thiz = (Callable)((Object)this);
            return Flux.convertToMono(thiz);
        }
        return Mono.onAssembly(new MonoTakeLastOne<T>(this, defaultValue));
    }

    public final Flux<T> limitRate(int prefetchRate) {
        return Flux.onAssembly(this.publishOn(Schedulers.immediate(), prefetchRate));
    }

    public final Flux<T> log() {
        return this.log(null, Level.INFO, new SignalType[0]);
    }

    public final Flux<T> log(String category) {
        return this.log(category, Level.INFO, new SignalType[0]);
    }

    public final Flux<T> log(String category, Level level, SignalType ... options) {
        return this.log(category, level, false, options);
    }

    public final Flux<T> log(String category, Level level, boolean showOperatorLine, SignalType ... options) {
        SignalLogger log = new SignalLogger(this, category, level, showOperatorLine, options);
        return Flux.doOnSignal(this, log.onSubscribeCall(), log.onNextCall(), log.onErrorCall(), log.onCompleteCall(), log.onAfterTerminateCall(), log.onRequestCall(), log.onCancelCall());
    }

    public final <V> Flux<V> map(Function<? super T, ? extends V> mapper) {
        if (this instanceof Fuseable) {
            return Flux.onAssembly(new FluxMapFuseable<T, V>(this, mapper));
        }
        return Flux.onAssembly(new FluxMap<T, V>(this, mapper));
    }

    public final Flux<T> mapError(Function<? super Throwable, ? extends Throwable> mapper) {
        return this.onErrorResumeWith(e -> Mono.error((Throwable)mapper.apply((Throwable)e)));
    }

    public final <E extends Throwable> Flux<T> mapError(Class<E> type, Function<? super E, ? extends Throwable> mapper) {
        Function<? super E, ? extends Throwable> handler = mapper;
        return this.mapError(type::isInstance, handler);
    }

    public final Flux<T> mapError(Predicate<? super Throwable> predicate, Function<? super Throwable, ? extends Throwable> mapper) {
        return this.onErrorResumeWith(predicate, (? super Throwable e) -> Mono.error((Throwable)mapper.apply((Throwable)e)));
    }

    public final Flux<Signal<T>> materialize() {
        return Flux.onAssembly(new FluxMaterialize(this));
    }

    public final Flux<T> mergeWith(Publisher<? extends T> other) {
        if (this instanceof FluxMerge) {
            FluxMerge fluxMerge = (FluxMerge)this;
            return fluxMerge.mergeAdditionalSource(other, QueueSupplier::get);
        }
        return Flux.merge(this, other);
    }

    public final Mono<T> next() {
        return Mono.from(this);
    }

    public final <U> Flux<U> ofType(Class<U> clazz) {
        Objects.requireNonNull(clazz, "clazz");
        return this.filter(o -> clazz.isAssignableFrom(o.getClass())).cast(clazz);
    }

    public final Flux<T> onBackpressureBuffer() {
        return Flux.onAssembly(new FluxOnBackpressureBuffer(this, QueueSupplier.SMALL_BUFFER_SIZE, true, null));
    }

    public final Flux<T> onBackpressureBuffer(int maxSize) {
        return Flux.onAssembly(new FluxOnBackpressureBuffer(this, maxSize, false, null));
    }

    public final Flux<T> onBackpressureBuffer(int maxSize, Consumer<? super T> onOverflow) {
        Objects.requireNonNull(onOverflow, "onOverflow");
        return Flux.onAssembly(new FluxOnBackpressureBuffer<T>(this, maxSize, false, onOverflow));
    }

    public final Flux<T> onBackpressureBuffer(int maxSize, BufferOverflowStrategy bufferOverflowStrategy) {
        Objects.requireNonNull(bufferOverflowStrategy, "bufferOverflowStrategy");
        return Flux.onAssembly(new FluxOnBackpressureBufferStrategy(this, maxSize, null, bufferOverflowStrategy));
    }

    public final Flux<T> onBackpressureBuffer(int maxSize, Consumer<? super T> onBufferOverflow, BufferOverflowStrategy bufferOverflowStrategy) {
        Objects.requireNonNull(onBufferOverflow, "onBufferOverflow");
        Objects.requireNonNull(bufferOverflowStrategy, "bufferOverflowStrategy");
        return Flux.onAssembly(new FluxOnBackpressureBufferStrategy<T>(this, maxSize, onBufferOverflow, bufferOverflowStrategy));
    }

    public final Flux<T> onBackpressureDrop() {
        return Flux.onAssembly(new FluxOnBackpressureDrop(this));
    }

    public final Flux<T> onBackpressureDrop(Consumer<? super T> onDropped) {
        return Flux.onAssembly(new FluxOnBackpressureDrop<T>(this, onDropped));
    }

    public final Flux<T> onBackpressureError() {
        return this.onBackpressureDrop(t -> {
            throw Exceptions.failWithOverflow();
        });
    }

    public final Flux<T> onBackpressureLatest() {
        return Flux.onAssembly(new FluxOnBackpressureLatest(this));
    }

    public final Flux<T> onErrorResumeWith(Function<? super Throwable, ? extends Publisher<? extends T>> fallback) {
        return Flux.onAssembly(new FluxResume(this, fallback));
    }

    public final <E extends Throwable> Flux<T> onErrorResumeWith(Class<E> type, Function<? super E, ? extends Publisher<? extends T>> fallback) {
        Objects.requireNonNull(type, "type");
        Function<? super E, ? extends Publisher<? extends T>> handler = fallback;
        return this.onErrorResumeWith(type::isInstance, handler);
    }

    public final Flux<T> onErrorResumeWith(Predicate<? super Throwable> predicate, Function<? super Throwable, ? extends Publisher<? extends T>> fallback) {
        Objects.requireNonNull(predicate, "predicate");
        return this.onErrorResumeWith(e -> predicate.test((Throwable)e) ? (Publisher)fallback.apply((Throwable)e) : Flux.error(e));
    }

    public final Flux<T> onErrorReturn(T fallbackValue) {
        return this.switchOnError(Flux.just(fallbackValue));
    }

    public final <E extends Throwable> Flux<T> onErrorReturn(Class<E> type, T fallbackValue) {
        return this.switchOnError(type, Flux.just(fallbackValue));
    }

    public final <E extends Throwable> Flux<T> onErrorReturn(Predicate<? super Throwable> predicate, T fallbackValue) {
        return this.switchOnError(predicate, Flux.just(fallbackValue));
    }

    public final Flux<T> onTerminateDetach() {
        return new FluxDetach(this);
    }

    public final ParallelFlux<T> parallel() {
        return this.parallel(Runtime.getRuntime().availableProcessors());
    }

    public final ParallelFlux<T> parallel(int parallelism) {
        return this.parallel(parallelism, QueueSupplier.SMALL_BUFFER_SIZE);
    }

    public final ParallelFlux<T> parallel(int parallelism, int prefetch) {
        return ParallelFlux.from(this, parallelism, prefetch, QueueSupplier.get(prefetch));
    }

    public final ConnectableFlux<T> publish() {
        return this.publish(QueueSupplier.SMALL_BUFFER_SIZE);
    }

    public final ConnectableFlux<T> publish(int prefetch) {
        return Flux.onAssembly(new FluxPublish(this, prefetch, QueueSupplier.get(prefetch)));
    }

    public final <R> Flux<R> publish(Function<? super Flux<T>, ? extends Publisher<? extends R>> transform) {
        return this.publish(transform, QueueSupplier.SMALL_BUFFER_SIZE);
    }

    public final <R> Flux<R> publish(Function<? super Flux<T>, ? extends Publisher<? extends R>> transform, int prefetch) {
        return Flux.onAssembly(new FluxPublishMulticast(this, transform, prefetch, QueueSupplier.get(prefetch)));
    }

    public final Mono<T> publishNext() {
        return Mono.onAssembly(new MonoProcessor(this));
    }

    public final Flux<T> publishOn(Scheduler scheduler) {
        return this.publishOn(scheduler, QueueSupplier.SMALL_BUFFER_SIZE);
    }

    public final Flux<T> publishOn(Scheduler scheduler, int prefetch) {
        if (this instanceof Fuseable.ScalarCallable) {
            Object value = ((Fuseable.ScalarCallable)((Object)this)).call();
            return Flux.onAssembly(new FluxSubscribeOnValue(value, scheduler));
        }
        return Flux.onAssembly(new FluxPublishOn(this, scheduler, true, prefetch, QueueSupplier.get(prefetch)));
    }

    public final Mono<T> reduce(BiFunction<T, T, T> aggregator) {
        if (this instanceof Callable) {
            Callable thiz = (Callable)((Object)this);
            return Flux.convertToMono(thiz);
        }
        return Mono.onAssembly(new MonoReduce<T>(this, aggregator));
    }

    public final <A> Mono<A> reduce(A initial, BiFunction<A, ? super T, A> accumulator) {
        return this.reduceWith(() -> initial, accumulator);
    }

    public final <A> Mono<A> reduceWith(Supplier<A> initial, BiFunction<A, ? super T, A> accumulator) {
        return Mono.onAssembly(new MonoReduceSeed<T, A>(this, initial, accumulator));
    }

    public final Flux<T> repeat() {
        return this.repeat(ALWAYS_BOOLEAN_SUPPLIER);
    }

    public final Flux<T> repeat(BooleanSupplier predicate) {
        return Flux.onAssembly(new FluxRepeatPredicate(this, predicate));
    }

    public final Flux<T> repeat(long numRepeat) {
        return Flux.onAssembly(new FluxRepeat(this, numRepeat));
    }

    public final Flux<T> repeat(long numRepeat, BooleanSupplier predicate) {
        return Flux.defer(() -> this.repeat(Flux.countingBooleanSupplier(predicate, numRepeat)));
    }

    public final Flux<T> repeatWhen(Function<Flux<Long>, ? extends Publisher<?>> whenFactory) {
        return Flux.onAssembly(new FluxRepeatWhen(this, whenFactory));
    }

    public final ConnectableFlux<T> replay() {
        return this.replay(Integer.MAX_VALUE);
    }

    public final ConnectableFlux<T> replay(int history) {
        return Flux.onAssembly(new FluxReplay(this, history, 0L, null));
    }

    public final ConnectableFlux<T> replay(Duration ttl) {
        return this.replay(Integer.MAX_VALUE, ttl);
    }

    public final ConnectableFlux<T> replay(int history, Duration ttl) {
        return this.replayMillis(history, ttl.toMillis(), Schedulers.timer());
    }

    public final ConnectableFlux<T> replayMillis(long ttl, TimedScheduler timer) {
        return this.replayMillis(Integer.MAX_VALUE, ttl, timer);
    }

    public final ConnectableFlux<T> replayMillis(int history, long ttl, TimedScheduler timer) {
        Objects.requireNonNull(timer, "timer");
        return Flux.onAssembly(new FluxReplay(this, history, ttl, timer));
    }

    public final Flux<T> retry() {
        return this.retry(Long.MAX_VALUE);
    }

    public final Flux<T> retry(long numRetries) {
        return new FluxRetry(this, numRetries);
    }

    public final Flux<T> retry(Predicate<Throwable> retryMatcher) {
        return Flux.onAssembly(new FluxRetryPredicate(this, retryMatcher));
    }

    public final Flux<T> retry(long numRetries, Predicate<Throwable> retryMatcher) {
        return Flux.defer(() -> this.retry(Flux.countingPredicate(retryMatcher, numRetries)));
    }

    public final Flux<T> retryWhen(Function<Flux<Throwable>, ? extends Publisher<?>> whenFactory) {
        return Flux.onAssembly(new FluxRetryWhen(this, whenFactory));
    }

    public final Flux<T> sample(Duration timespan) {
        return this.sampleMillis(timespan.toMillis());
    }

    public final <U> Flux<T> sample(Publisher<U> sampler) {
        return Flux.onAssembly(new FluxSample(this, sampler));
    }

    public final Flux<T> sampleFirst(Duration timespan) {
        return this.sampleFirstMillis(timespan.toMillis());
    }

    public final <U> Flux<T> sampleFirst(Function<? super T, ? extends Publisher<U>> samplerFactory) {
        return Flux.onAssembly(new FluxSampleFirst(this, samplerFactory));
    }

    public final Flux<T> sampleFirstMillis(long timespan) {
        return this.sampleFirst((? super T t) -> Mono.delayMillis(timespan));
    }

    public final Flux<T> sampleMillis(long timespan) {
        return this.sample(Flux.intervalMillis(timespan));
    }

    public final <U> Flux<T> sampleTimeout(Function<? super T, ? extends Publisher<U>> throttlerFactory) {
        return Flux.onAssembly(new FluxSampleTimeout(this, throttlerFactory, QueueSupplier.unbounded(QueueSupplier.XS_BUFFER_SIZE)));
    }

    public final <U> Flux<T> sampleTimeout(Function<? super T, ? extends Publisher<U>> throttlerFactory, int maxConcurrency) {
        if (maxConcurrency == Integer.MAX_VALUE) {
            return this.sampleTimeout(throttlerFactory);
        }
        return Flux.onAssembly(new FluxSampleTimeout(this, throttlerFactory, QueueSupplier.get(maxConcurrency)));
    }

    public final Flux<T> scan(BiFunction<T, T, T> accumulator) {
        return Flux.onAssembly(new FluxScan<T>(this, accumulator));
    }

    public final <A> Flux<A> scan(A initial, BiFunction<A, ? super T, A> accumulator) {
        Objects.requireNonNull(initial, "seed");
        return this.scanWith(() -> initial, accumulator);
    }

    public final <A> Flux<A> scanWith(Supplier<A> initial, BiFunction<A, ? super T, A> accumulator) {
        return Flux.onAssembly(new FluxScanSeed<T, A>(this, initial, accumulator));
    }

    public final Flux<T> share() {
        return this.publish().refCount();
    }

    public final Mono<T> single() {
        if (this instanceof Callable) {
            if (this instanceof Fuseable.ScalarCallable) {
                Fuseable.ScalarCallable scalarCallable = (Fuseable.ScalarCallable)((Object)this);
                Object v = scalarCallable.call();
                if (v == null) {
                    return Mono.error(new NoSuchElementException("Source was a (constant) empty"));
                }
                return Mono.just(v);
            }
            Callable thiz = (Callable)((Object)this);
            return Mono.onAssembly(new MonoCallable(thiz));
        }
        return Mono.onAssembly(new MonoSingle(this));
    }

    public final Mono<T> single(T defaultValue) {
        if (this instanceof Callable) {
            if (this instanceof Fuseable.ScalarCallable) {
                Fuseable.ScalarCallable scalarCallable = (Fuseable.ScalarCallable)((Object)this);
                Object v = scalarCallable.call();
                if (v == null) {
                    return Mono.just(defaultValue);
                }
                return Mono.just(v);
            }
            Callable thiz = (Callable)((Object)this);
            return Mono.onAssembly(new MonoCallable(thiz));
        }
        return Mono.onAssembly(new MonoSingle<T>(this, defaultValue, false));
    }

    public final Mono<T> singleOrEmpty() {
        if (this instanceof Callable) {
            Callable thiz = (Callable)((Object)this);
            return Flux.convertToMono(thiz);
        }
        return Mono.onAssembly(new MonoSingle<Object>(this, null, true));
    }

    public final Flux<T> skip(long skipped) {
        if (skipped > 0L) {
            return Flux.onAssembly(new FluxSkip(this, skipped));
        }
        return this;
    }

    public final Flux<T> skip(Duration timespan) {
        return this.skipMillis(timespan.toMillis(), Schedulers.timer());
    }

    public final Flux<T> skipLast(int n) {
        return Flux.onAssembly(new FluxSkipLast(this, n));
    }

    public final Flux<T> skipMillis(long timespan) {
        if (timespan != 0L) {
            return this.skipUntilOther(Mono.delayMillis(timespan, Schedulers.timer()));
        }
        return this;
    }

    public final Flux<T> skipMillis(long timespan, TimedScheduler timer) {
        if (timespan != 0L) {
            return this.skipUntilOther(Mono.delayMillis(timespan, timer));
        }
        return this;
    }

    public final Flux<T> skipUntil(Predicate<? super T> untilPredicate) {
        return Flux.onAssembly(new FluxSkipUntil<T>(this, untilPredicate));
    }

    public final Flux<T> skipUntilOther(Publisher<?> other) {
        return Flux.onAssembly(new FluxSkipUntilOther(this, other));
    }

    public final Flux<T> skipWhile(Predicate<? super T> skipPredicate) {
        return Flux.onAssembly(new FluxSkipWhile<T>(this, skipPredicate));
    }

    public final Flux<T> sort() {
        return this.collectSortedList().flatMapIterable(Flux.identityFunction());
    }

    public final Flux<T> sort(Comparator<? super T> sortFunction) {
        return this.collectSortedList(sortFunction).flatMapIterable(Flux.identityFunction());
    }

    public final Flux<T> startWith(Iterable<? extends T> iterable) {
        return this.startWith((Publisher<? extends T>)Flux.fromIterable(iterable));
    }

    @SafeVarargs
    public final Flux<T> startWith(T ... values) {
        return this.startWith((Publisher<? extends T>)Flux.just(values));
    }

    public final Flux<T> startWith(Publisher<? extends T> publisher) {
        if (this instanceof FluxConcatArray) {
            FluxConcatArray fluxConcatArray = (FluxConcatArray)this;
            return fluxConcatArray.concatAdditionalSourceFirst(publisher);
        }
        return Flux.concat(publisher, this);
    }

    public final Disposable subscribe() {
        return this.subscribe(null, null, null);
    }

    public final Disposable subscribe(int prefetch) {
        return this.subscribe(null, null, null, prefetch);
    }

    public final Disposable subscribe(Consumer<? super T> consumer) {
        Objects.requireNonNull(consumer, "consumer");
        return this.subscribe(consumer, null, null);
    }

    public final Disposable subscribe(Consumer<? super T> consumer, int prefetch) {
        Objects.requireNonNull(consumer, "consumer");
        return this.subscribe(consumer, null, null, prefetch);
    }

    public final Disposable subscribe(Consumer<? super T> consumer, Consumer<? super Throwable> errorConsumer) {
        Objects.requireNonNull(errorConsumer, "errorConsumer");
        return this.subscribe(consumer, errorConsumer, null);
    }

    public final Disposable subscribe(Consumer<? super T> consumer, Consumer<? super Throwable> errorConsumer, Runnable completeConsumer) {
        return this.subscribe(consumer, errorConsumer, completeConsumer, null);
    }

    public final Disposable subscribe(Consumer<? super T> consumer, Consumer<? super Throwable> errorConsumer, Runnable completeConsumer, Consumer<? super Subscription> subscriptionConsumer) {
        LambdaSubscriber<? super T> consumerAction = new LambdaSubscriber<T>(consumer, errorConsumer, completeConsumer, subscriptionConsumer);
        this.subscribe(consumerAction);
        return consumerAction;
    }

    @Deprecated
    public final Disposable subscribe(Consumer<? super T> consumer, Consumer<? super Throwable> errorConsumer, Runnable completeConsumer, int prefetch) {
        return this.subscribe(consumer, errorConsumer, completeConsumer, null, prefetch);
    }

    @Deprecated
    public final Disposable subscribe(Consumer<? super T> consumer, Consumer<? super Throwable> errorConsumer, Runnable completeConsumer, Consumer<? super Subscription> subscriptionConsumer, int prefetch) {
        int c = Math.min(Integer.MAX_VALUE, prefetch);
        LambdaSubscriber<? super T> consumerAction = new LambdaSubscriber<T>(consumer, errorConsumer, completeConsumer, subscriptionConsumer);
        Flux<T> tail = c == Integer.MAX_VALUE ? this : this.publishOn(Schedulers.immediate(), c);
        return tail.subscribeWith(consumerAction);
    }

    public final Flux<T> subscribeOn(Scheduler scheduler) {
        if (this instanceof Callable) {
            if (this instanceof Fuseable.ScalarCallable) {
                Object value = ((Fuseable.ScalarCallable)((Object)this)).call();
                return Flux.onAssembly(new FluxSubscribeOnValue(value, scheduler));
            }
            Callable c = (Callable)((Object)this);
            return Flux.onAssembly(new FluxSubscribeOnCallable(c, scheduler));
        }
        return Flux.onAssembly(new FluxSubscribeOn(this, scheduler));
    }

    public final <E extends Subscriber<? super T>> E subscribeWith(E subscriber) {
        this.subscribe(subscriber);
        return subscriber;
    }

    public final Flux<T> switchIfEmpty(Publisher<? extends T> alternate) {
        return Flux.onAssembly(new FluxSwitchIfEmpty<T>(this, alternate));
    }

    public final <V> Flux<V> switchMap(Function<? super T, Publisher<? extends V>> fn) {
        return this.switchMap(fn, QueueSupplier.XS_BUFFER_SIZE);
    }

    public final <V> Flux<V> switchMap(Function<? super T, Publisher<? extends V>> fn, int prefetch) {
        return Flux.onAssembly(new FluxSwitchMap<T, V>(this, fn, QueueSupplier.get(prefetch), prefetch));
    }

    public final <E extends Throwable> Flux<T> switchOnError(Class<E> type, Publisher<? extends T> fallback) {
        return this.onErrorResumeWith(type, (? super E t) -> fallback);
    }

    public final Flux<T> switchOnError(Predicate<? super Throwable> predicate, Publisher<? extends T> fallback) {
        return this.onErrorResumeWith(predicate, (? super Throwable t) -> fallback);
    }

    public final Flux<T> switchOnError(Publisher<? extends T> fallback) {
        return this.onErrorResumeWith(t -> fallback);
    }

    public final Flux<T> take(long n) {
        if (this instanceof Fuseable) {
            return Flux.onAssembly(new FluxTakeFuseable(this, n));
        }
        return Flux.onAssembly(new FluxTake(this, n));
    }

    public final Flux<T> take(Duration timespan) {
        return this.takeMillis(timespan.toMillis(), Schedulers.timer());
    }

    public final Flux<T> takeLast(int n) {
        if (n == 1) {
            return Flux.onAssembly(new FluxTakeLastOne(this));
        }
        return Flux.onAssembly(new FluxTakeLast(this, n));
    }

    public final Flux<T> takeMillis(long timespan) {
        return this.takeMillis(timespan, Schedulers.timer());
    }

    public final Flux<T> takeMillis(long timespan, TimedScheduler timer) {
        if (timespan != 0L) {
            return this.takeUntilOther(Mono.delayMillis(timespan, timer));
        }
        return this.take(0L);
    }

    public final Flux<T> takeUntil(Predicate<? super T> predicate) {
        return Flux.onAssembly(new FluxTakeUntil<T>(this, predicate));
    }

    public final Flux<T> takeUntilOther(Publisher<?> other) {
        return Flux.onAssembly(new FluxTakeUntilOther(this, other));
    }

    public final Flux<T> takeWhile(Predicate<? super T> continuePredicate) {
        return Flux.onAssembly(new FluxTakeWhile<T>(this, continuePredicate));
    }

    public final Mono<Void> then() {
        MonoIgnoreThen then = new MonoIgnoreThen(this);
        return Mono.onAssembly(then);
    }

    @Deprecated
    public final Mono<Void> then(Publisher<Void> other) {
        return this.thenEmpty(other);
    }

    public final Mono<Void> thenEmpty(Publisher<Void> other) {
        MonoIgnoreThen ignored = new MonoIgnoreThen(this);
        Mono<Void> then = ignored.then(MonoSource.wrap(other));
        return Mono.onAssembly(then);
    }

    public final Mono<Void> then(Supplier<? extends Publisher<Void>> afterSupplier) {
        return this.thenEmpty(Flux.defer(afterSupplier));
    }

    public final <V> Flux<V> thenMany(Publisher<V> other) {
        if (this instanceof FluxConcatArray) {
            FluxConcatArray fluxConcatArray = (FluxConcatArray)this;
            return fluxConcatArray.concatAdditionalIgnoredLast(other);
        }
        Flux<T> concat = Flux.concat(this.ignoreElements(), other);
        return concat;
    }

    public final <V> Flux<V> thenMany(Supplier<? extends Publisher<V>> afterSupplier) {
        return this.thenMany(Flux.defer(afterSupplier));
    }

    public final Flux<T> timeout(Duration timeout) {
        return this.timeout(timeout, null);
    }

    public final Flux<T> timeout(Duration timeout, Publisher<? extends T> fallback) {
        return this.timeoutMillis(timeout.toMillis(), fallback, Schedulers.timer());
    }

    public final <U> Flux<T> timeout(Publisher<U> firstTimeout) {
        return this.timeout(firstTimeout, (? super T t) -> Flux.never());
    }

    public final <U, V> Flux<T> timeout(Publisher<U> firstTimeout, Function<? super T, ? extends Publisher<V>> nextTimeoutFactory) {
        return Flux.onAssembly(new FluxTimeout(this, firstTimeout, nextTimeoutFactory));
    }

    public final <U, V> Flux<T> timeout(Publisher<U> firstTimeout, Function<? super T, ? extends Publisher<V>> nextTimeoutFactory, Publisher<? extends T> fallback) {
        return Flux.onAssembly(new FluxTimeout(this, firstTimeout, nextTimeoutFactory, fallback));
    }

    public final Flux<T> timeoutMillis(long timeout) {
        return this.timeoutMillis(timeout, null, Schedulers.timer());
    }

    public final Flux<T> timeoutMillis(long timeout, TimedScheduler timer) {
        return this.timeoutMillis(timeout, null, timer);
    }

    public final Flux<T> timeoutMillis(long timeout, Publisher<? extends T> fallback) {
        return this.timeoutMillis(timeout, fallback, Schedulers.timer());
    }

    public final Flux<T> timeoutMillis(long timeout, Publisher<? extends T> fallback, TimedScheduler timer) {
        Mono<Long> _timer = Mono.delayMillis(timeout, timer).otherwiseReturn(0L);
        Function<Object, Publisher> rest = o -> _timer;
        if (fallback == null) {
            return this.timeout(_timer, rest);
        }
        return this.timeout(_timer, rest, fallback);
    }

    public final Flux<Tuple2<Long, T>> timestamp() {
        return this.timestamp(Schedulers.timer());
    }

    public final Flux<Tuple2<Long, T>> timestamp(TimedScheduler scheduler) {
        return this.map(d -> Tuples.of(scheduler.now(TimeUnit.MILLISECONDS), d));
    }

    public final Iterable<T> toIterable() {
        return this.toIterable(QueueSupplier.SMALL_BUFFER_SIZE);
    }

    public final Iterable<T> toIterable(long batchSize) {
        return this.toIterable(batchSize, null);
    }

    public final Iterable<T> toIterable(long batchSize, Supplier<Queue<T>> queueProvider) {
        Supplier<Queue<Object>> provider = queueProvider == null ? QueueSupplier.get((int)Math.min(Integer.MAX_VALUE, batchSize)) : queueProvider;
        return new BlockingIterable<T>(this, batchSize, provider);
    }

    public Stream<T> toStream() {
        return this.toStream(QueueSupplier.SMALL_BUFFER_SIZE);
    }

    public Stream<T> toStream(int batchSize) {
        Supplier provider = QueueSupplier.get(batchSize);
        return new BlockingIterable(this, batchSize, provider).stream();
    }

    public final <V> Flux<V> transform(Function<? super Flux<T>, ? extends Publisher<V>> transformer) {
        return Flux.from(transformer.apply(this));
    }

    public final Flux<Flux<T>> window() {
        return Flux.onAssembly(new FluxWindowOnCancel(this, QueueSupplier.unbounded(QueueSupplier.XS_BUFFER_SIZE)));
    }

    public final Flux<Flux<T>> window(int maxSize) {
        return Flux.onAssembly(new FluxWindow(this, maxSize, QueueSupplier.get(maxSize)));
    }

    public final Flux<Flux<T>> window(int maxSize, int skip) {
        return Flux.onAssembly(new FluxWindow(this, maxSize, skip, QueueSupplier.xs(), QueueSupplier.xs()));
    }

    public final Flux<Flux<T>> window(Publisher<?> boundary) {
        return Flux.onAssembly(new FluxWindowBoundary(this, boundary, QueueSupplier.unbounded(QueueSupplier.XS_BUFFER_SIZE), QueueSupplier.unbounded(QueueSupplier.XS_BUFFER_SIZE)));
    }

    public final <U, V> Flux<Flux<T>> window(Publisher<U> bucketOpening, Function<? super U, ? extends Publisher<V>> closeSelector) {
        return Flux.onAssembly(new FluxWindowStartEnd(this, bucketOpening, closeSelector, QueueSupplier.unbounded(QueueSupplier.XS_BUFFER_SIZE), QueueSupplier.unbounded(QueueSupplier.XS_BUFFER_SIZE)));
    }

    public final Flux<Flux<T>> window(Duration timespan) {
        return this.windowMillis(timespan.toMillis());
    }

    public final Flux<Flux<T>> window(Duration timespan, Duration timeshift) {
        return this.windowMillis(timespan.toMillis(), timeshift.toMillis(), Schedulers.timer());
    }

    public final Flux<Flux<T>> window(int maxSize, Duration timespan) {
        return this.windowMillis(maxSize, timespan.toMillis(), Schedulers.timer());
    }

    public final Flux<Flux<T>> windowMillis(long timespan) {
        return this.windowMillis(timespan, Schedulers.timer());
    }

    public final Flux<Flux<T>> windowMillis(long timespan, TimedScheduler timer) {
        return this.window(Flux.intervalMillis(timespan, timer));
    }

    public final Flux<Flux<T>> windowMillis(long timespan, long timeshift, TimedScheduler timer) {
        if (timeshift == timespan) {
            return this.windowMillis(timespan);
        }
        return this.window(Flux.intervalMillis(0L, timeshift, timer), (? super U aLong) -> Mono.delayMillis(timespan, timer));
    }

    public final Flux<Flux<T>> windowMillis(int maxSize, long timespan) {
        return this.windowMillis(maxSize, timespan, Schedulers.timer());
    }

    public final Flux<Flux<T>> windowMillis(int maxSize, long timespan, TimedScheduler timer) {
        return Flux.onAssembly(new FluxWindowTimeOrSize(this, maxSize, timespan, timer));
    }

    public final <U, R> Flux<R> withLatestFrom(Publisher<? extends U> other, BiFunction<? super T, ? super U, ? extends R> resultSelector) {
        return Flux.onAssembly(new FluxWithLatestFrom<T, U, R>(this, other, resultSelector));
    }

    public final <T2> Flux<Tuple2<T, T2>> zipWith(Publisher<? extends T2> source2) {
        return this.zipWith(source2, Flux.tuple2Function());
    }

    public final <T2, V> Flux<V> zipWith(Publisher<? extends T2> source2, BiFunction<? super T, ? super T2, ? extends V> combinator) {
        FluxZip o;
        FluxZip result;
        if (this instanceof FluxZip && (result = (o = (FluxZip)this).zipAdditionalSource(source2, combinator)) != null) {
            return result;
        }
        return Flux.zip(this, source2, combinator);
    }

    public final <T2, V> Flux<V> zipWith(Publisher<? extends T2> source2, int prefetch, BiFunction<? super T, ? super T2, ? extends V> combinator) {
        return Flux.zip((? super Object[] objects) -> combinator.apply((Object)objects[0], (Object)objects[1]), prefetch, this, source2);
    }

    public final <T2> Flux<Tuple2<T, T2>> zipWith(Publisher<? extends T2> source2, int prefetch) {
        return this.zipWith(source2, prefetch, Flux.tuple2Function());
    }

    public final <T2> Flux<Tuple2<T, T2>> zipWithIterable(Iterable<? extends T2> iterable) {
        return this.zipWithIterable(iterable, Flux.tuple2Function());
    }

    public final <T2, V> Flux<V> zipWithIterable(Iterable<? extends T2> iterable, BiFunction<? super T, ? super T2, ? extends V> zipper) {
        return Flux.onAssembly(new FluxZipIterable<T, T2, V>(this, iterable, zipper));
    }

    protected static <T> Flux<T> onAssembly(Flux<T> source) {
        Hooks.OnOperatorCreate<?> hook = Hooks.onOperatorCreate;
        if (hook == null) {
            return source;
        }
        return (Flux)hook.apply((Publisher<?>)source);
    }

    protected static <T> ConnectableFlux<T> onAssembly(ConnectableFlux<T> source) {
        Hooks.OnOperatorCreate<?> hook = Hooks.onOperatorCreate;
        if (hook == null) {
            return source;
        }
        return (ConnectableFlux)hook.apply((Publisher<?>)source);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    static <T> Flux<T> doOnSignal(Publisher<T> source, Consumer<? super Subscription> onSubscribe, Consumer<? super T> onNext, Consumer<? super Throwable> onError, Runnable onComplete, Runnable onAfterTerminate, LongConsumer onRequest, Runnable onCancel) {
        if (source instanceof Fuseable) {
            return Flux.onAssembly(new FluxPeekFuseable<T>(source, onSubscribe, onNext, onError, onComplete, onAfterTerminate, onRequest, onCancel));
        }
        return Flux.onAssembly(new FluxPeek<T>(source, onSubscribe, onNext, onError, onComplete, onAfterTerminate, onRequest, onCancel));
    }

    static <T, S> Flux<T> doOnSignalStateful(Publisher<T> source, Supplier<S> stateSeeder, BiConsumer<? super Subscription, S> onSubscribe, BiConsumer<? super T, S> onNext, BiConsumer<? super Throwable, S> onError, Consumer<S> onComplete, Consumer<S> onAfterTerminate, BiConsumer<Long, S> onRequest, Consumer<S> onCancel) {
        return Flux.onAssembly(new FluxPeekStateful<T, S>(source, stateSeeder, onSubscribe, onNext, onError, onComplete, onAfterTerminate, onRequest, onCancel));
    }

    static <T> Mono<T> convertToMono(Callable<T> supplier) {
        if (supplier instanceof Fuseable.ScalarCallable) {
            Fuseable.ScalarCallable scalarCallable = (Fuseable.ScalarCallable)supplier;
            Object v = scalarCallable.call();
            if (v == null) {
                return Mono.empty();
            }
            return Mono.just(v);
        }
        return Mono.onAssembly(new MonoCallable<T>(supplier));
    }

    static BooleanSupplier countingBooleanSupplier(final BooleanSupplier predicate, final long max) {
        if (max <= 0L) {
            return predicate;
        }
        return new BooleanSupplier(){
            long n;

            @Override
            public boolean getAsBoolean() {
                return this.n++ < max && predicate.getAsBoolean();
            }
        };
    }

    static <O> Predicate<O> countingPredicate(final Predicate<O> predicate, final long max) {
        if (max == 0L) {
            return predicate;
        }
        return new Predicate<O>(){
            long n;

            @Override
            public boolean test(O o) {
                return this.n++ < max && predicate.test(o);
            }
        };
    }

    static <O> Supplier<Set<O>> hashSetSupplier() {
        return SET_SUPPLIER;
    }

    static <O> Supplier<List<O>> listSupplier() {
        return LIST_SUPPLIER;
    }

    static <U, V> Function<U, V> hashcodeSupplier() {
        return HASHCODE_EXTRACTOR;
    }

    static <T> Function<T, T> identityFunction() {
        return IDENTITY_FUNCTION;
    }

    static <A, B> BiFunction<A, B, Tuple2<A, B>> tuple2Function() {
        return TUPLE2_BIFUNCTION;
    }
}

