/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Exceptions;
import reactor.core.MultiProducer;
import reactor.core.Producer;
import reactor.core.Receiver;
import reactor.core.Trackable;
import reactor.core.publisher.EventLoopProcessor;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxProcessor;
import reactor.core.publisher.Operators;
import reactor.core.publisher.RingBuffer;
import reactor.util.concurrent.QueueSupplier;

public final class EmitterProcessor<T>
extends FluxProcessor<T, T>
implements MultiProducer,
Receiver {
    final int maxConcurrency;
    final int bufferSize;
    final int limit;
    final boolean autoCancel;
    Subscription upstreamSubscription;
    private volatile RingBuffer<EventLoopProcessor.Slot<T>> emitBuffer;
    private volatile boolean done;
    static final EmitterSubscriber<?>[] EMPTY = new EmitterSubscriber[0];
    static final EmitterSubscriber<?>[] CANCELLED = new EmitterSubscriber[0];
    private volatile Throwable error;
    static final AtomicReferenceFieldUpdater<EmitterProcessor, Throwable> ERROR = AtomicReferenceFieldUpdater.newUpdater(EmitterProcessor.class, Throwable.class, "error");
    volatile EmitterSubscriber<?>[] subscribers;
    static final AtomicReferenceFieldUpdater<EmitterProcessor, EmitterSubscriber[]> SUBSCRIBERS = AtomicReferenceFieldUpdater.newUpdater(EmitterProcessor.class, EmitterSubscriber[].class, "subscribers");
    private volatile int running;
    static final AtomicIntegerFieldUpdater<EmitterProcessor> RUNNING = AtomicIntegerFieldUpdater.newUpdater(EmitterProcessor.class, "running");
    private volatile int outstanding;
    static final AtomicIntegerFieldUpdater<EmitterProcessor> OUTSTANDING = AtomicIntegerFieldUpdater.newUpdater(EmitterProcessor.class, "outstanding");
    boolean firstDrain = true;

    public static <E> EmitterProcessor<E> create() {
        return EmitterProcessor.create(true);
    }

    public static <E> EmitterProcessor<E> create(boolean autoCancel) {
        return EmitterProcessor.create(QueueSupplier.SMALL_BUFFER_SIZE, autoCancel);
    }

    public static <E> EmitterProcessor<E> create(int bufferSize) {
        return EmitterProcessor.create(bufferSize, Integer.MAX_VALUE);
    }

    public static <E> EmitterProcessor<E> create(int bufferSize, int concurrency) {
        return EmitterProcessor.create(bufferSize, concurrency, true);
    }

    public static <E> EmitterProcessor<E> create(int bufferSize, boolean autoCancel) {
        return EmitterProcessor.create(bufferSize, Integer.MAX_VALUE, autoCancel);
    }

    public static <E> EmitterProcessor<E> create(int bufferSize, int concurrency, boolean autoCancel) {
        return new EmitterProcessor(autoCancel, concurrency, bufferSize);
    }

    public Subscription upstream() {
        return this.upstreamSubscription;
    }

    EmitterProcessor(boolean autoCancel, int maxConcurrency, int bufferSize) {
        this.autoCancel = autoCancel;
        this.maxConcurrency = maxConcurrency;
        this.bufferSize = bufferSize;
        this.limit = Math.max(1, bufferSize / 2);
        OUTSTANDING.lazySet(this, bufferSize);
        SUBSCRIBERS.lazySet(this, EMPTY);
    }

    @Override
    public void subscribe(Subscriber<? super T> s) {
        super.subscribe(s);
        EmitterSubscriber<T> inner = new EmitterSubscriber<T>(this, s);
        try {
            this.addInner(inner);
            if (this.upstreamSubscription != null) {
                inner.start();
            }
        }
        catch (Throwable t) {
            if (Exceptions.isCancel(t)) {
                return;
            }
            this.removeInner(inner, EMPTY);
            Operators.error(s, t);
        }
    }

    public EmitterProcessor<T> connect() {
        this.onSubscribe(Operators.emptySubscription());
        return this;
    }

    @Override
    public long getPending() {
        return this.emitBuffer == null ? -1L : (long)this.emitBuffer.getPending();
    }

    public void onNext(T t) {
        if (t == null) {
            throw Exceptions.argumentIsNullException();
        }
        EmitterSubscriber<?>[] inner = this.subscribers;
        if (this.autoCancel && inner == CANCELLED) {
            return;
        }
        int n = inner.length;
        if (n != 0) {
            long seq = -1L;
            if (this.upstreamSubscription != Operators.emptySubscription()) {
                int outstanding = this.outstanding;
                if (outstanding != 0) {
                    OUTSTANDING.decrementAndGet(this);
                } else {
                    this.buffer(t);
                    this.drain();
                    return;
                }
            }
            for (int i = 0; i < n; ++i) {
                RingBuffer.Sequence poll;
                EmitterSubscriber<?> is = inner[i];
                if (is.done) {
                    this.removeInner(is, this.autoCancel ? CANCELLED : EMPTY);
                    if (!this.autoCancel || this.subscribers != CANCELLED) continue;
                    if (RUNNING.compareAndSet(this, 0, 1)) {
                        this.cancel();
                    }
                    return;
                }
                long r = ((EmitterSubscriber)is).requested;
                is.unbounded = r == Long.MAX_VALUE;
                RingBuffer.Sequence sequence = poll = is.unbounded ? null : is.pollCursor;
                if (r > 0L && poll == null) {
                    if (r != Long.MAX_VALUE) {
                        EmitterSubscriber.REQUESTED.decrementAndGet(is);
                    }
                    is.actual.onNext(t);
                    continue;
                }
                if (seq == -1L) {
                    seq = this.buffer(t);
                    this.startAllTrackers(inner, seq, i + 1);
                    continue;
                }
                if (poll != null) continue;
                is.startTracking(seq);
            }
            if (RUNNING.getAndIncrement(this) != 0) {
                return;
            }
            this.drainLoop();
        } else {
            this.buffer(t);
        }
    }

    public void onError(Throwable t) {
        if (t == null) {
            throw Exceptions.argumentIsNullException();
        }
        if (this.autoCancel && this.done) {
            Operators.onErrorDropped(t);
        }
        this.reportError(t);
        this.done = true;
        this.drain();
    }

    public void onComplete() {
        if (this.done) {
            return;
        }
        this.done = true;
        this.drain();
    }

    public void onSubscribe(Subscription s) {
        if (Operators.validate(this.upstreamSubscription, s)) {
            this.upstreamSubscription = s;
            try {
                EmitterSubscriber<?>[] innerSubscribers = this.subscribers;
                if (innerSubscribers != CANCELLED && innerSubscribers.length != 0) {
                    for (int i = 0; i < innerSubscribers.length; ++i) {
                        innerSubscribers[i].start();
                    }
                }
            }
            catch (Throwable t) {
                this.onError(Operators.onOperatorError(s, t));
            }
        }
    }

    @Override
    public Throwable getError() {
        return this.error;
    }

    @Override
    public boolean isCancelled() {
        return this.autoCancel && this.subscribers == CANCELLED;
    }

    @Override
    public final long getCapacity() {
        return this.bufferSize;
    }

    @Override
    public boolean isStarted() {
        return this.upstreamSubscription != null;
    }

    @Override
    public boolean isTerminated() {
        return this.done && (this.emitBuffer == null || this.emitBuffer.getPending() == 0);
    }

    @Override
    public long limit() {
        return this.limit;
    }

    @Override
    public long expectedFromUpstream() {
        return this.outstanding;
    }

    RingBuffer<EventLoopProcessor.Slot<T>> getMainQueue() {
        RingBuffer<EventLoopProcessor.Slot<Object>> q = this.emitBuffer;
        if (q == null) {
            this.emitBuffer = q = EventLoopProcessor.createSingleProducer(this.bufferSize);
        }
        return q;
    }

    final long buffer(T value) {
        RingBuffer<EventLoopProcessor.Slot<T>> q = this.getMainQueue();
        long seq = q.next();
        q.get((long)seq).value = value;
        q.publish(seq);
        return seq;
    }

    final void drain() {
        if (RUNNING.getAndIncrement(this) == 0) {
            this.drainLoop();
        }
    }

    final void drainLoop() {
        int missed = 1;
        RingBuffer<EventLoopProcessor.Slot<T>> q = null;
        do {
            EmitterSubscriber<?>[] inner;
            if ((inner = this.subscribers) == CANCELLED) {
                this.cancel();
                return;
            }
            boolean d = this.done;
            if (d && inner == EMPTY) {
                return;
            }
            int n = inner.length;
            if (n == 0) continue;
            for (int i = 0; i < n; ++i) {
                long _r;
                EmitterSubscriber<?> is = inner[i];
                long r = ((EmitterSubscriber)is).requested;
                if (is.done) {
                    this.removeInner(is, this.autoCancel ? CANCELLED : EMPTY);
                    if (!this.autoCancel || this.subscribers != CANCELLED) continue;
                    this.cancel();
                    return;
                }
                if (q == null) {
                    q = this.emitBuffer;
                }
                RingBuffer.Sequence innerSequence = is.pollCursor;
                if (!is.unbounded && innerSequence != null && r > 0L) {
                    _r = r;
                    boolean unbounded = _r == Long.MAX_VALUE;
                    long cursor = innerSequence.getAsLong();
                    long max = q.getCursor();
                    while (_r != 0L && max >= ++cursor) {
                        Object oo = q.get((long)cursor).value;
                        innerSequence.set(cursor);
                        is.actual.onNext(oo);
                        if (unbounded) continue;
                        --_r;
                    }
                    if (!unbounded && r > _r) {
                        EmitterSubscriber.REQUESTED.addAndGet(is, _r - r);
                    }
                } else {
                    _r = 0L;
                }
                if (!d) continue;
                this.checkTerminal(is, innerSequence, _r);
            }
            if (!this.done && this.firstDrain) {
                Subscription s = this.upstreamSubscription;
                if (s == null) continue;
                this.firstDrain = false;
                s.request((long)this.bufferSize);
                continue;
            }
            if (q != null) {
                this.requestMore(q.getPending());
                continue;
            }
            this.requestMore(0);
        } while ((missed = RUNNING.addAndGet(this, -missed)) != 0);
    }

    final void checkTerminal(EmitterSubscriber<T> is, RingBuffer.Sequence innerSequence, long r) {
        Throwable e = this.error;
        if (e != null && r == 0L || innerSequence == null || is.unbounded || innerSequence.getAsLong() >= this.emitBuffer.getCursor()) {
            this.removeInner(is, EMPTY);
            if (!is.done) {
                if (e == null) {
                    is.actual.onComplete();
                } else {
                    is.actual.onError(e);
                }
            }
        }
    }

    final void startAllTrackers(EmitterSubscriber<?>[] inner, long seq, int size) {
        for (int i = 0; i < size - 1; ++i) {
            RingBuffer.Sequence poll = inner[i].pollCursor;
            if (poll != null) continue;
            inner[i].startTracking(seq + 1L);
        }
        inner[size - 1].startTracking(seq);
    }

    final void reportError(Throwable t) {
        ERROR.compareAndSet(this, null, t);
    }

    final void addInner(EmitterSubscriber<T> inner) {
        EmitterSubscriber[] b;
        EmitterSubscriber<?>[] a;
        do {
            int n;
            if ((a = this.subscribers) == CANCELLED) {
                Flux.empty().subscribe(inner.actual);
            }
            if ((n = a.length) + 1 > this.maxConcurrency) {
                throw Exceptions.failWithOverflow();
            }
            b = new EmitterSubscriber[n + 1];
            System.arraycopy(a, 0, b, 0, n);
            b[n] = inner;
        } while (!SUBSCRIBERS.compareAndSet(this, a, b));
    }

    final void removeInner(EmitterSubscriber<?> inner, EmitterSubscriber<?>[] lastRemoved) {
        EmitterSubscriber<?>[] b;
        EmitterSubscriber<?>[] a;
        do {
            if ((a = this.subscribers) == CANCELLED || a == EMPTY) {
                return;
            }
            int n = a.length;
            int j = -1;
            for (int i = 0; i < n; ++i) {
                if (a[i] != inner) continue;
                j = i;
                break;
            }
            if (j < 0) {
                return;
            }
            if (n == 1) {
                b = lastRemoved;
                continue;
            }
            b = new EmitterSubscriber[n - 1];
            System.arraycopy(a, 0, b, 0, j);
            System.arraycopy(a, j + 1, b, j, n - j - 1);
        } while (!SUBSCRIBERS.compareAndSet(this, a, b));
        RingBuffer.Sequence poll = inner.pollCursor;
        if (poll != null) {
            this.getMainQueue().removeGatingSequence(poll);
        }
    }

    final void requestMore(int buffered) {
        Subscription subscription = this.upstreamSubscription;
        if (subscription == Operators.emptySubscription()) {
            return;
        }
        if (buffered < this.bufferSize) {
            int r = this.outstanding;
            if (r > this.limit) {
                return;
            }
            int toRequest = this.bufferSize - r - buffered;
            if (toRequest > 0 && subscription != null) {
                OUTSTANDING.addAndGet(this, toRequest);
                subscription.request((long)toRequest);
            }
        }
    }

    final void cancel() {
        Subscription s;
        if (!this.done && (s = this.upstreamSubscription) != null) {
            this.upstreamSubscription = null;
            s.cancel();
        }
    }

    @Override
    public Iterator<?> downstreams() {
        return Arrays.asList(this.subscribers).iterator();
    }

    @Override
    public long downstreamCount() {
        return this.subscribers.length;
    }

    @Override
    public String toString() {
        return "{done: " + this.done + (this.error != null ? ", error: '" + this.error.getMessage() + "', " : "") + ", outstanding: " + this.outstanding + ", pending: " + this.emitBuffer + '}';
    }

    static final class EmitterSubscriber<T>
    implements Subscription,
    Trackable,
    Receiver,
    Producer {
        public static final long MASK_NOT_SUBSCRIBED = Long.MIN_VALUE;
        final EmitterProcessor<T> parent;
        final Subscriber<? super T> actual;
        volatile boolean done;
        boolean unbounded = false;
        private volatile long requested = Long.MIN_VALUE;
        static final AtomicLongFieldUpdater<EmitterSubscriber> REQUESTED = AtomicLongFieldUpdater.newUpdater(EmitterSubscriber.class, "requested");
        volatile RingBuffer.Sequence pollCursor;
        static final AtomicReferenceFieldUpdater<EmitterSubscriber, RingBuffer.Sequence> CURSOR = AtomicReferenceFieldUpdater.newUpdater(EmitterSubscriber.class, RingBuffer.Sequence.class, "pollCursor");

        public EmitterSubscriber(EmitterProcessor<T> parent, Subscriber<? super T> actual) {
            this.actual = actual;
            this.parent = parent;
        }

        public void request(long n) {
            if (Operators.checkRequest(n, this.actual)) {
                Operators.getAndAddCap(REQUESTED, this, n);
                if (RUNNING.getAndIncrement(this.parent) == 0) {
                    this.parent.drainLoop();
                }
            }
        }

        public void cancel() {
            this.done = true;
            this.parent.drain();
        }

        @Override
        public long requestedFromDownstream() {
            return this.requested;
        }

        @Override
        public long getCapacity() {
            return this.parent.bufferSize;
        }

        void startTracking(long seq) {
            RingBuffer.Sequence pollSequence = RingBuffer.newSequence(seq - 1L);
            if (CURSOR.compareAndSet(this, null, pollSequence)) {
                ((EmitterProcessor)this.parent).emitBuffer.addGatingSequence(pollSequence);
            }
        }

        void start() {
            if (REQUESTED.compareAndSet(this, Long.MIN_VALUE, 0L)) {
                RingBuffer ringBuffer = ((EmitterProcessor)this.parent).emitBuffer;
                if (ringBuffer != null) {
                    this.startTracking(Math.max(0L, ringBuffer.getMinimumGatingSequence() + 1L));
                }
                this.actual.onSubscribe((Subscription)this);
            }
        }

        @Override
        public boolean isCancelled() {
            return this.done;
        }

        @Override
        public long getPending() {
            return this.pollCursor == null || this.done ? -1L : ((EmitterProcessor)this.parent).emitBuffer.getCursor() - this.pollCursor.getAsLong();
        }

        @Override
        public boolean isStarted() {
            return this.parent.isStarted();
        }

        @Override
        public boolean isTerminated() {
            return this.parent.isTerminated();
        }

        @Override
        public Object upstream() {
            return this.parent;
        }

        public Subscriber<? super T> downstream() {
            return this.actual;
        }
    }
}

