/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Exceptions;
import reactor.core.Producer;
import reactor.core.Trackable;
import reactor.core.publisher.Operators;

public final class BlockingSink<E>
implements Producer,
Subscription,
Trackable,
Consumer<E>,
Closeable {
    final Subscriber<? super E> actual;
    volatile long requested;
    Throwable uncaughtException;
    volatile boolean cancelled;
    static final Predicate NEVER = o -> false;
    static final AtomicLongFieldUpdater<BlockingSink> REQUESTED = AtomicLongFieldUpdater.newUpdater(BlockingSink.class, "requested");

    public static <E> BlockingSink<E> create(Subscriber<? super E> subscriber, boolean autostart) {
        BlockingSink<E> sub = new BlockingSink<E>(subscriber);
        if (autostart) {
            sub.start();
        }
        return sub;
    }

    public static <E> BlockingSink<E> create(Subscriber<? super E> subscriber) {
        return BlockingSink.create(subscriber, true);
    }

    protected BlockingSink(Subscriber<? super E> actual) {
        this.actual = actual;
    }

    @Override
    public void accept(E e) {
        while (this.emit(e) == Emission.BACKPRESSURED) {
            LockSupport.parkNanos(1L);
        }
    }

    public void cancel() {
        this.cancelled = true;
    }

    @Override
    public void close() throws IOException {
        this.finish();
    }

    public Subscriber<? super E> downstream() {
        return this.actual;
    }

    public void next(E t) {
        Emission emission = this.emit(t);
        if (emission.isOk()) {
            return;
        }
        if (emission.isBackpressured()) {
            Operators.reportMoreProduced();
            return;
        }
        if (emission.isCancelled()) {
            Operators.onNextDropped(t);
            return;
        }
        if (this.getError() != null) {
            throw Exceptions.bubble(this.getError());
        }
        throw new IllegalStateException("Emission has failed");
    }

    public Emission emit(E data) {
        if (this.uncaughtException != null) {
            return Emission.FAILED;
        }
        if (this.cancelled) {
            return Emission.CANCELLED;
        }
        try {
            long u;
            long r;
            while ((r = this.requested) != 0L && r != Long.MAX_VALUE && !REQUESTED.compareAndSet(this, r, u = Operators.subOrZero(r, 1L))) {
            }
            if (r == 0L) {
                return Emission.BACKPRESSURED;
            }
            this.actual.onNext(data);
            return Emission.OK;
        }
        catch (Throwable t) {
            if (Exceptions.isCancel(t)) {
                return Emission.CANCELLED;
            }
            Exceptions.throwIfFatal(t);
            this.uncaughtException = t;
            if (this.cancelled) {
                return Emission.FAILED;
            }
            this.actual.onError(t);
            return Emission.FAILED;
        }
    }

    public void error(Throwable error) {
        if (this.uncaughtException == null) {
            this.uncaughtException = error;
            if (this.cancelled) {
                IllegalStateException ise = new IllegalStateException("Session has been cancelled previously");
                ise.addSuppressed(error);
                throw ise;
            }
        } else {
            IllegalStateException ise = new IllegalStateException("Session already failed");
            ise.addSuppressed(error);
            throw ise;
        }
        this.cancelled = true;
        this.actual.onError(error);
    }

    public Emission finish() {
        if (this.uncaughtException != null) {
            return Emission.FAILED;
        }
        if (this.cancelled) {
            return Emission.CANCELLED;
        }
        try {
            this.cancelled = true;
            this.actual.onComplete();
            return Emission.OK;
        }
        catch (Throwable t) {
            if (Exceptions.isCancel(t)) {
                return Emission.CANCELLED;
            }
            Exceptions.throwIfFatal(t);
            this.uncaughtException = Exceptions.unwrap(t);
            return Emission.FAILED;
        }
    }

    @Override
    public long getCapacity() {
        return Trackable.class.isAssignableFrom(this.actual.getClass()) ? ((Trackable)this.actual).getCapacity() : Long.MAX_VALUE;
    }

    @Override
    public Throwable getError() {
        return this.uncaughtException;
    }

    public boolean hasFailed() {
        return this.uncaughtException != null;
    }

    public boolean hasRequested() {
        return !this.cancelled && this.requested != 0L;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    public void complete() {
        this.finish();
    }

    public void request(long n) {
        if (Operators.checkRequest(n, this.actual)) {
            Operators.getAndAddCap(REQUESTED, this, n);
        }
    }

    @Override
    public long requestedFromDownstream() {
        return this.requested;
    }

    public void start() {
        try {
            this.actual.onSubscribe((Subscription)this);
        }
        catch (Throwable t) {
            this.uncaughtException = t;
            Operators.error(this.actual, t);
        }
    }

    public void stop() {
        this.cancelled = true;
    }

    public long submit(E data) {
        return this.submit(data, -1L, TimeUnit.MILLISECONDS, NEVER);
    }

    public long submit(E data, long timeout) {
        return this.submit(data, timeout, TimeUnit.MILLISECONDS, NEVER);
    }

    public long submit(E data, long timeout, Predicate<E> dropPredicate) {
        return this.submit(data, timeout, TimeUnit.MILLISECONDS, dropPredicate);
    }

    public long submit(E data, long timeout, TimeUnit unit) {
        return this.submit(data, timeout, unit, NEVER);
    }

    public long submit(E data, long timeout, TimeUnit unit, Predicate<E> dropPredicate) {
        Emission res;
        long start = System.currentTimeMillis();
        long timespan = timeout != -1L ? start + TimeUnit.MILLISECONDS.convert(timeout, unit) : Long.MAX_VALUE;
        try {
            while ((res = this.emit(data)).isBackpressured()) {
                if (timeout != -1L && System.currentTimeMillis() > timespan) {
                    if (!dropPredicate.test(data)) break;
                    timespan += TimeUnit.MILLISECONDS.convert(timeout, unit);
                }
                Thread.sleep(10L);
            }
        }
        catch (InterruptedException ie) {
            return -1L;
        }
        return res == Emission.OK ? unit.convert(System.currentTimeMillis() - start, TimeUnit.MILLISECONDS) : -1L;
    }

    public String toString() {
        return "BlockingSink{requested=" + this.requested + ", uncaughtException=" + this.uncaughtException + ", cancelled=" + this.cancelled + '}';
    }

    public static enum Emission {
        FAILED,
        BACKPRESSURED,
        OK,
        CANCELLED;


        public boolean isBackpressured() {
            return this == BACKPRESSURED;
        }

        public boolean isCancelled() {
            return this == CANCELLED;
        }

        public boolean isFailed() {
            return this == FAILED;
        }

        public boolean isOk() {
            return this == OK;
        }
    }
}

