/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Queue;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Exceptions;
import reactor.core.Receiver;
import reactor.core.Trackable;
import reactor.core.publisher.Operators;

final class BlockingIterable<T>
implements Iterable<T>,
Receiver,
Trackable {
    final Publisher<? extends T> source;
    final long batchSize;
    final Supplier<Queue<T>> queueSupplier;

    public BlockingIterable(Publisher<? extends T> source, long batchSize, Supplier<Queue<T>> queueSupplier) {
        if (batchSize <= 0L) {
            throw new IllegalArgumentException("batchSize > 0 required but it was " + batchSize);
        }
        this.source = Objects.requireNonNull(source, "source");
        this.batchSize = batchSize;
        this.queueSupplier = Objects.requireNonNull(queueSupplier, "queueSupplier");
    }

    @Override
    public Iterator<T> iterator() {
        SubscriberIterator<T> it = this.createIterator();
        this.source.subscribe(it);
        return it;
    }

    @Override
    public Spliterator<T> spliterator() {
        return this.stream().spliterator();
    }

    public Stream<T> stream() {
        SubscriberIterator<T> it = this.createIterator();
        this.source.subscribe(it);
        Spliterator<T> sp = Spliterators.spliteratorUnknownSize(it, 0);
        return (Stream)StreamSupport.stream(sp, false).onClose(it);
    }

    SubscriberIterator<T> createIterator() {
        Queue<T> q;
        try {
            q = this.queueSupplier.get();
        }
        catch (Throwable e) {
            throw Exceptions.propagate(e);
        }
        if (q == null) {
            throw new NullPointerException("The queueSupplier returned a null queue");
        }
        return new SubscriberIterator<T>(q, this.batchSize);
    }

    @Override
    public long getCapacity() {
        return this.batchSize;
    }

    @Override
    public Object upstream() {
        return this.source;
    }

    @Override
    public long getPending() {
        return 0L;
    }

    static final class SubscriberIterator<T>
    implements Subscriber<T>,
    Iterator<T>,
    Runnable,
    Receiver,
    Trackable {
        final Queue<T> queue;
        final long batchSize;
        final long limit;
        final Lock lock;
        final Condition condition;
        long produced;
        volatile Subscription s;
        static final AtomicReferenceFieldUpdater<SubscriberIterator, Subscription> S = AtomicReferenceFieldUpdater.newUpdater(SubscriberIterator.class, Subscription.class, "s");
        volatile boolean done;
        Throwable error;
        volatile boolean cancelled;

        public SubscriberIterator(Queue<T> queue, long batchSize) {
            this.queue = queue;
            this.batchSize = batchSize;
            this.limit = batchSize - (batchSize >> 2);
            this.lock = new ReentrantLock();
            this.condition = this.lock.newCondition();
        }

        @Override
        public boolean hasNext() {
            block5: while (true) {
                if (this.cancelled) {
                    return false;
                }
                boolean d = this.done;
                boolean empty = this.queue.isEmpty();
                if (d) {
                    Throwable e = this.error;
                    if (e != null) {
                        throw Exceptions.propagate(e);
                    }
                    if (empty) {
                        return false;
                    }
                }
                if (!empty) break;
                this.lock.lock();
                try {
                    while (true) {
                        if (this.cancelled || this.done || !this.queue.isEmpty()) continue block5;
                        this.condition.await();
                    }
                }
                catch (InterruptedException ex) {
                    this.run();
                    throw Exceptions.propagate(ex);
                }
                finally {
                    this.lock.unlock();
                    continue;
                }
                break;
            }
            return true;
        }

        @Override
        public T next() {
            if (this.hasNext()) {
                T v = this.queue.poll();
                if (v == null) {
                    this.run();
                    throw new IllegalStateException("Queue empty?!");
                }
                long p = this.produced + 1L;
                if (p == this.limit) {
                    this.produced = 0L;
                    this.s.request(p);
                } else {
                    this.produced = p;
                }
                return v;
            }
            throw new NoSuchElementException();
        }

        public void onSubscribe(Subscription s) {
            if (Operators.setOnce(S, this, s)) {
                s.request(this.batchSize);
            }
        }

        public void onNext(T t) {
            if (!this.queue.offer(t)) {
                Operators.terminate(S, this);
                this.onError(Exceptions.failWithOverflow("Queue full?!"));
            } else {
                this.signalConsumer();
            }
        }

        public void onError(Throwable t) {
            this.error = t;
            this.done = true;
            this.signalConsumer();
        }

        public void onComplete() {
            this.done = true;
            this.signalConsumer();
        }

        void signalConsumer() {
            this.lock.lock();
            try {
                this.condition.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public void run() {
            Operators.terminate(S, this);
            this.signalConsumer();
        }

        @Override
        public Object upstream() {
            return this.s;
        }

        @Override
        public boolean isStarted() {
            return this.s != null && !this.done && this.s != Operators.cancelledSubscription();
        }

        @Override
        public boolean isTerminated() {
            return this.done || this.s == Operators.cancelledSubscription();
        }
    }
}

