/*
 * Decompiled with CFR 0.152.
 */
package reactor.adapter.misc;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import reactor.core.Cancellation;
import reactor.core.Exceptions;
import reactor.core.publisher.Operators;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.TimedScheduler;

public final class SwingScheduler
implements TimedScheduler {
    public static TimedScheduler create() {
        return new SwingScheduler();
    }

    SwingScheduler() {
    }

    public Cancellation schedule(Runnable task) {
        SwingScheduledDirectAction a = new SwingScheduledDirectAction(task);
        SwingUtilities.invokeLater(a);
        return a;
    }

    public Cancellation schedule(Runnable task, long delay, TimeUnit unit) {
        if (delay <= 0L) {
            return this.schedule(task);
        }
        Timer timer = new Timer((int)unit.toMillis(delay), null);
        timer.setRepeats(false);
        timer.addActionListener(e -> {
            try {
                task.run();
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                Operators.onErrorDropped((Throwable)ex);
            }
        });
        timer.start();
        return timer::stop;
    }

    public Cancellation schedulePeriodically(Runnable task, long initialDelay, long period, TimeUnit unit) {
        Timer timer = new Timer((int)unit.toMillis(period), null);
        timer.setInitialDelay((int)unit.toMillis(initialDelay));
        timer.addActionListener(e -> {
            try {
                task.run();
            }
            catch (Throwable ex) {
                timer.stop();
                Exceptions.throwIfFatal((Throwable)ex);
                Operators.onErrorDropped((Throwable)ex);
            }
        });
        timer.start();
        return timer::stop;
    }

    public TimedScheduler.TimedWorker createWorker() {
        return new SwingSchedulerWorker();
    }

    static final class SwingScheduledDirectAction
    extends AtomicBoolean
    implements Runnable,
    Cancellation {
        private static final long serialVersionUID = 2378266891882031635L;
        final Runnable action;

        public SwingScheduledDirectAction(Runnable action) {
            this.action = action;
        }

        @Override
        public void run() {
            if (!this.get()) {
                try {
                    this.action.run();
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal((Throwable)ex);
                    Operators.onErrorDropped((Throwable)ex);
                }
            }
        }

        public void dispose() {
            this.set(true);
        }
    }

    static final class SwingSchedulerWorker
    implements TimedScheduler.TimedWorker {
        volatile boolean unsubscribed;
        Set<Timer> tasks = new HashSet<Timer>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            Set<Timer> set;
            if (this.unsubscribed) {
                return;
            }
            this.unsubscribed = true;
            SwingSchedulerWorker swingSchedulerWorker = this;
            synchronized (swingSchedulerWorker) {
                set = this.tasks;
                this.tasks = null;
            }
            if (set != null) {
                for (Timer t : set) {
                    t.stop();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void remove(Timer timer) {
            if (this.unsubscribed) {
                return;
            }
            SwingSchedulerWorker swingSchedulerWorker = this;
            synchronized (swingSchedulerWorker) {
                if (this.unsubscribed) {
                    return;
                }
                this.tasks.remove(timer);
            }
        }

        public Cancellation schedule(Runnable action) {
            if (!this.unsubscribed) {
                SwingScheduledDirectAction a = new SwingScheduledDirectAction(action);
                SwingUtilities.invokeLater(a);
                return a;
            }
            return Scheduler.REJECTED;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Cancellation schedule(Runnable action, long delayTime, TimeUnit unit) {
            if (delayTime <= 0L) {
                return this.schedule(action);
            }
            if (this.unsubscribed) {
                return Scheduler.REJECTED;
            }
            Timer timer = new Timer((int)unit.toMillis(delayTime), null);
            timer.setRepeats(false);
            SwingSchedulerWorker swingSchedulerWorker = this;
            synchronized (swingSchedulerWorker) {
                if (this.unsubscribed) {
                    return Scheduler.REJECTED;
                }
                this.tasks.add(timer);
            }
            timer.addActionListener(e -> {
                try {
                    try {
                        action.run();
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal((Throwable)ex);
                        Operators.onErrorDropped((Throwable)ex);
                    }
                }
                finally {
                    this.remove(timer);
                }
            });
            timer.start();
            if (this.unsubscribed) {
                timer.stop();
                return Scheduler.REJECTED;
            }
            return () -> {
                timer.stop();
                this.remove(timer);
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Cancellation schedulePeriodically(Runnable task, long initialDelay, long period, TimeUnit unit) {
            if (this.unsubscribed) {
                return Scheduler.REJECTED;
            }
            Timer timer = new Timer((int)unit.toMillis(period), null);
            timer.setInitialDelay((int)unit.toMillis(initialDelay));
            SwingSchedulerWorker swingSchedulerWorker = this;
            synchronized (swingSchedulerWorker) {
                if (this.unsubscribed) {
                    return Scheduler.REJECTED;
                }
                this.tasks.add(timer);
            }
            timer.addActionListener(e -> {
                try {
                    task.run();
                }
                catch (Throwable ex) {
                    timer.stop();
                    this.remove(timer);
                    Exceptions.throwIfFatal((Throwable)ex);
                    Operators.onErrorDropped((Throwable)ex);
                }
            });
            timer.start();
            if (this.unsubscribed) {
                timer.stop();
                return Scheduler.REJECTED;
            }
            return () -> {
                timer.stop();
                this.remove(timer);
            };
        }
    }
}

