package io.privy.logging

import io.privy.di.PrivyAppId
import me.tatarka.inject.annotations.Inject

@Inject
public class RealPrivyLogger(
  private val level: PrivyLogLevel,
  private val appId: PrivyAppId,
) : PrivyLogger {
  // Whitelist of app ids that we print internal logs for
  private val internalAppIds = listOf(
    "clpijy3tw0001kz0g6ixs9z15"
  )

  private val printLogs = level != PrivyLogLevel.NONE
  private val printInternalLogs = appId in internalAppIds

  override fun debug(message: String) {
    if (level == PrivyLogLevel.DEBUG || level == PrivyLogLevel.VERBOSE) {
      printMessage(message)
    }
  }

  override fun info(message: String) {
    if (level == PrivyLogLevel.INFO || level == PrivyLogLevel.VERBOSE) {
      printMessage(message)
    }
  }

  override fun warning(message: String) {
    if (level == PrivyLogLevel.WARNING || level == PrivyLogLevel.VERBOSE) {
      printMessage(message)
    }
  }

  override fun error(message: String, error: Throwable?) {
    if (level == PrivyLogLevel.ERROR || level == PrivyLogLevel.VERBOSE) {
      printMessage(message)
    }
  }

  override fun internal(message: String) {
    if (printInternalLogs) {
      if (level == PrivyLogLevel.ERROR || level == PrivyLogLevel.VERBOSE) {
        printMessage(message)
      }
    }
  }

  private fun printMessage(message: String) {
    if (printLogs) {
      println("Privy: $message")
    }
  }
}
