package io.privy.analytics.persistence

import androidx.datastore.core.DataStore
import androidx.datastore.core.handlers.ReplaceFileCorruptionHandler
import androidx.datastore.preferences.core.PreferenceDataStoreFactory
import androidx.datastore.preferences.core.Preferences
import okio.Path.Companion.toPath

@Suppress("EXPECT_ACTUAL_CLASSIFIERS_ARE_IN_BETA_WARNING")
public expect interface ClientAnalyticsIdDataStoreBindings

public data class ClientAnalyticsIdDataStoreHolder(val dataStore: DataStore<Preferences>)

// Preferences file must have .preferences_pb extension
internal const val dataStoreFileName = "client-analytics-id.preferences_pb"

internal fun createDataStoreWithPath(
    corruptionHandler: ReplaceFileCorruptionHandler<Preferences>,
    producePath: () -> String
): DataStore<Preferences> =
    PreferenceDataStoreFactory.createWithPath(
        corruptionHandler = corruptionHandler, produceFile = { producePath().toPath() })
