package io.privy.analytics.persistence

import android.content.Context
import androidx.datastore.core.handlers.ReplaceFileCorruptionHandler
import androidx.datastore.preferences.core.emptyPreferences
import io.privy.di.KmpAppScope
import me.tatarka.inject.annotations.Provides

@Suppress("EXPECT_ACTUAL_CLASSIFIERS_ARE_IN_BETA_WARNING")
public actual interface ClientAnalyticsIdDataStoreBindings {
  @Provides
  @KmpAppScope
  public fun provideClientAnalyticsIdDataStore(context: Context): ClientAnalyticsIdDataStoreHolder {
    return ClientAnalyticsIdDataStoreHolder(
        createDataStoreWithPath(
            corruptionHandler =
                ReplaceFileCorruptionHandler {
                  // if file is corrupted, empty it out
                  emptyPreferences()
                },
            producePath = { context.filesDir.resolve(dataStoreFileName).absolutePath }))
  }
}
