package io.privy.analytics.persistence

import androidx.datastore.preferences.core.edit
import androidx.datastore.preferences.core.stringPreferencesKey
import io.privy.di.KmpAppScope
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.map
import me.tatarka.inject.annotations.Inject

public interface ClientAnalyticsIdDataStore {
  public val clientId: Flow<String?>

  public suspend fun saveClientId(clientAnalyticsId: String)

  public suspend fun clearClientId()
}

@Inject
@KmpAppScope
public class RealClientAnalyticsIdDataStore(
    clientAnalyticsIdDataStoreHolder: ClientAnalyticsIdDataStoreHolder,
) : ClientAnalyticsIdDataStore {
  private val dataStore = clientAnalyticsIdDataStoreHolder.dataStore
  private val clientAnalyticsIdKey = stringPreferencesKey(name = "client_analytics_id")

  override val clientId: Flow<String?> =
      dataStore.data.map { preferences -> preferences[clientAnalyticsIdKey] }

  override suspend fun saveClientId(clientAnalyticsId: String) {
    dataStore.edit { prefs -> prefs[clientAnalyticsIdKey] = clientAnalyticsId }
  }

  override suspend fun clearClientId() {
    dataStore.edit { prefs -> prefs.remove(clientAnalyticsIdKey) }
  }
}
