package io.privy.analytics

import io.privy.analytics.persistence.ClientAnalyticsIdDataStore
import kotlinx.coroutines.flow.firstOrNull
import me.tatarka.inject.annotations.Inject

@Inject
public class RealClientAnalyticsIdRepository(
    private val clientAnalyticsIdDataStore: ClientAnalyticsIdDataStore,
) : ClientAnalyticsIdRepository {
  override suspend fun loadClientAnalyticsId(): String {
    val persistedClientId = clientAnalyticsIdDataStore.clientId.firstOrNull()

    return if (persistedClientId != null) {
      persistedClientId
    } else {
      val uuid = generateUuid().lowercase()
      // store client id after it's generated
      clientAnalyticsIdDataStore.saveClientId(uuid)
      uuid
    }
  }

  override suspend fun clearClientAnalyticsId() {
    clientAnalyticsIdDataStore.clearClientId()
  }
}
