package io.privy.auth.siwe

/** Parameters for generating a SIWE message. */
public data class SiweMessageParams(
    /// The app's domain, e.g. "my-domain.com"
    val appDomain: String,

    /// The app's uri, e.g. "https://my-domain.com"
    val appUri: String,

    /// EVM Chain ID, e.g. "1" for Ethereum Mainnet"
    val chainId: String,

    /// The wallet's address being used to sign in
    val walletAddress: String
)
