package io.privy.auth.oAuth

/**
 * Helper interface for generating PKCE (Proof Key for Code Exchange) parameters.
 */
public interface PKCEHelper {
    /**
     * Creates a cryptographic random string to be used as the code_verifier in PKCE.
     *
     * @return A cryptographic random string to be used as a code_verifier in PKCE.
     */
   public fun generateCodeVerifier(): String

    /**
     * Generates a state code to be used in the OAuth flow. State code can be a random set of characters,
     * or optionally can be used to store state information. In either case, it is used by the client to verify
     * that it is communicating with the same server throughout the auth process.
     *
     * @return A valid state code to be used in PKCE flow.
     */
   public fun generateStateCode(): String

    /**
     * Derives the code_challenge from the code verifier, using SHA 256.
     *
     * @param codeVerifier The code verifier string.
     * @return The code_challenge derived from the provided code verifier.
     */
  public  fun deriveCodeChallenge(codeVerifier: String): String
}
