package io.privy.auth.internal

public sealed interface InternalAuthState {
  public data object NotReady : InternalAuthState

  public data object Unauthenticated : InternalAuthState

  // User is authenticated and has a valid auth session
  public data class Authenticated(val session: InternalAuthSession) : InternalAuthState

  public fun isAuthenticated(): Boolean {
    return this is Authenticated
  }

  /**
   * Extension function on auth state that specifies if the user's auth state has been determined.
   * The user's auth state is considered determined when it's set to something other than "NotReady".
   */
  public fun hasBeenDetermined(): Boolean {
    return this !is NotReady
  }
}
