package io.privy.auth.customAuth

import io.privy.auth.PrivyUser

public typealias TokenProvider = suspend () -> String?

public interface LoginWithCustomAuth {
  /**
   * Sets the token provider function.
   *
   * This function should return the current user's access token from your custom authentication
   * provider as a `String`. If the user is not authenticated, this callback should return null.
   *
   * @param tokenProvider The callback function Privy uses to obtain your user's access token.
   */
  public fun setTokenProvider(tokenProvider: TokenProvider)

  /**
   * Attempts to log the user in using the access token retrieved from `tokenProvider` set at Privy
   * initialization.
   *
   * @return A Result type with the PrivyUser object if login attempt was successful, or a
   *   Result.failure otherwise.
   */
  public suspend fun loginWithCustomAccessToken(): Result<PrivyUser>
}
