package io.privy.auth.session.internal

import io.privy.auth.internal.InternalAuthSession
import io.privy.auth.persistence.InternalAuthSessionTokens
import kotlinx.serialization.encodeToString
import kotlinx.serialization.json.Json
import me.tatarka.inject.annotations.Inject

public interface InternalAuthSessionSerializer {
  public fun serialize(internalAuthSession: InternalAuthSession): String

  public fun deserializeOrNull(json: String): InternalAuthSessionTokens?
}

@Inject
public class RealInternalAuthSessionSerializer : InternalAuthSessionSerializer {
  private val internalAuthSessionSerializer = Json {
    prettyPrint = true
    isLenient = true
    ignoreUnknownKeys = true
    explicitNulls = false
  }

  override fun serialize(internalAuthSession: InternalAuthSession): String {
    // grab tokens from auth session
    val authSessionTokens =
        InternalAuthSessionTokens(
            accessToken = internalAuthSession.accessToken,
            refreshToken = internalAuthSession.refreshToken,
            loginMethod = internalAuthSession.loginMethod,
            identityToken = internalAuthSession.identityToken)

    return internalAuthSessionSerializer.encodeToString(authSessionTokens)
  }

  override fun deserializeOrNull(json: String): InternalAuthSessionTokens? {
    return try {
      internalAuthSessionSerializer.decodeFromString<InternalAuthSessionTokens>(json)
    } catch (e: Exception) {
      null
    }
  }
}
