package io.privy.auth

import io.privy.auth.oAuth.OAuthProvider
import io.privy.auth.siwe.SiweLoginParams

public sealed interface LoginType {
  public data class CustomAccessToken(val token: String) : LoginType

  public data class Sms(val phoneNumber: String, val code: String) : LoginType

  public data class Email(val emailAddress: String, val code: String) : LoginType

  public data class Siwe(val params: SiweLoginParams) : LoginType

  public data class OAuth(
    val provider: OAuthProvider,
    val authorizationCode: String,
    val codeVerifier: String,
    val stateCode: String
  ) : LoginType
}


