/*
 * Decompiled with CFR 0.152.
 */
package io.praesid.livestats;

import io.praesid.livestats.LiveStats;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Stats
implements Serializable {
    private static final Logger log = LogManager.getLogger();
    public final String name;
    public final int decays;
    public final long n;
    public final Double decayedN;
    public final Double min;
    public final Double decayedMin;
    public final Double max;
    public final Double decayedMax;
    public final Double mean;
    public final Double variance;
    public final Double skewness;
    public final Double kurtosis;
    public final Map<Double, Double> quantiles;

    public Stats(String name, LiveStats stats) {
        this.name = name;
        this.n = stats.num();
        this.min = Stats.specialFloatsToNull(name, "min", stats.minimum());
        this.max = Stats.specialFloatsToNull(name, "max", stats.maximum());
        this.mean = Stats.specialFloatsToNull(name, "mean", stats.mean());
        this.variance = Stats.specialFloatsToNull(name, "variance", stats.variance());
        this.skewness = Stats.specialFloatsToNull(name, "skewness", stats.skewness());
        this.kurtosis = Stats.specialFloatsToNull(name, "kurtosis", stats.kurtosis());
        this.quantiles = Collections.unmodifiableMap(stats.quantiles());
        this.decayedMin = Stats.specialFloatsToNull(name, "decayedMin", stats.decayedMinimum());
        this.decayedMax = Stats.specialFloatsToNull(name, "decayedMax", stats.decayedMaximum());
        this.decayedN = Stats.specialFloatsToNull(name, "decayedN", stats.decayedNum());
        this.decays = stats.decayCount();
    }

    public Stats(String name, long n, double min, double max, double mean, double variance, double skewness, double kurtosis, Map<Double, Double> quantiles) {
        this.name = name;
        this.decays = 0;
        this.n = n;
        this.decayedN = n;
        this.min = min;
        this.decayedMin = min;
        this.max = max;
        this.decayedMax = max;
        this.mean = mean;
        this.variance = variance;
        this.skewness = skewness;
        this.kurtosis = kurtosis;
        this.quantiles = Collections.unmodifiableMap(quantiles);
    }

    private static Double specialFloatsToNull(String name, String var, double value) {
        if (Double.isNaN(value)) {
            log.debug("{}: {} is NaN", new Object[]{name, var});
            return null;
        }
        if (Double.isInfinite(value)) {
            log.debug("{}: {} is infinite", new Object[]{name, var});
            return null;
        }
        return value;
    }

    public String toString() {
        return "Stats(name=" + this.name + ", decays=" + this.decays + ", n=" + this.n + ", decayedN=" + this.decayedN + ", min=" + this.min + ", decayedMin=" + this.decayedMin + ", max=" + this.max + ", decayedMax=" + this.decayedMax + ", mean=" + this.mean + ", variance=" + this.variance + ", skewness=" + this.skewness + ", kurtosis=" + this.kurtosis + ", quantiles=" + this.quantiles + ")";
    }
}

