/*
 * Decompiled with CFR 0.152.
 */
package io.praesid.livestats;

import io.praesid.livestats.DecayConfig;
import io.praesid.livestats.LiveStats;
import io.praesid.livestats.Stats;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.StampedLock;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.concurrent.GuardedBy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class ServiceStats {
    private static final Logger log = LogManager.getLogger();
    private static final ServiceStats NOOP = new NoopServiceStats();
    private static final StampedLock lock = new StampedLock();
    @GuardedBy(value="lock")
    private static ServiceStats instance = null;

    private ServiceStats() {
    }

    public void put(String key, long nanos) {
        this.addTiming(key, nanos, System.nanoTime());
    }

    public void complete(String key, long startNanos) {
        long endNanos = System.nanoTime();
        this.addTiming(key, endNanos - startNanos, endNanos);
    }

    public <T> CompletableFuture<T> timingOnCompletion(String name, Supplier<CompletableFuture<T>> subject) {
        long startNanos = System.nanoTime();
        CompletableFuture<T> future = subject.get();
        future.whenComplete((result, thrown) -> {
            if (thrown == null) {
                this.complete(ServiceStats.appendSubType(name, true, false), startNanos);
            } else {
                this.complete(ServiceStats.appendSubType(name, false, true), startNanos);
            }
        });
        return future;
    }

    public <T> CompletableFuture<T> timingOnCompletion(String name, Supplier<CompletableFuture<T>> subject, Predicate<T> successful) {
        long start = System.nanoTime();
        CompletableFuture<T> future = subject.get();
        future.whenComplete((result, thrown) -> {
            if (thrown == null) {
                long end = System.nanoTime();
                this.addTiming(ServiceStats.appendSubType(name, successful.test(result), false), end - start, end);
            } else {
                this.complete(ServiceStats.appendSubType(name, false, true), start);
            }
        });
        return future;
    }

    public <T> T collectTiming(String name, Supplier<T> subject) {
        long startNanos = System.nanoTime();
        boolean error = false;
        try {
            T t = subject.get();
            return t;
        }
        catch (Throwable t) {
            error = true;
            throw t;
        }
        finally {
            this.complete(ServiceStats.appendSubType(name, true, error), startNanos);
        }
    }

    public <T> T collectTimingWithThrownFailures(String name, Supplier<T> subject, Predicate<Throwable> expected) {
        long start = System.nanoTime();
        boolean success = false;
        boolean error = false;
        long end = -1L;
        try {
            T result = subject.get();
            end = System.nanoTime();
            success = true;
            T t = result;
            return t;
        }
        catch (Throwable t) {
            end = System.nanoTime();
            error = !expected.test(t);
            throw t;
        }
        finally {
            this.addTiming(ServiceStats.appendSubType(name, success, error), end - start, end);
        }
    }

    public <T> T collectTiming(String name, Supplier<T> subject, Predicate<T> successful) {
        long start = System.nanoTime();
        boolean success = false;
        boolean error = false;
        long end = -1L;
        try {
            T result = subject.get();
            end = System.nanoTime();
            success = successful.test(result);
            T t = result;
            return t;
        }
        catch (Throwable t) {
            end = System.nanoTime();
            error = true;
            throw t;
        }
        finally {
            this.addTiming(ServiceStats.appendSubType(name, success, error), end - start, end);
        }
    }

    public abstract Stats[] consume();

    public abstract Stream<Stats> get(String ... var1);

    protected abstract void addTiming(String var1, long var2, long var4);

    private static String appendSubType(String name, boolean success, boolean error) {
        String subType = error ? "error" : (success ? "success" : "failure");
        return name + '/' + subType;
    }

    public static void disable() {
        long stamp = lock.writeLock();
        instance = null;
        lock.unlock(stamp);
    }

    public static void configure(double ... quantiles) {
        ServiceStats.configure(DecayConfig.NEVER, quantiles);
    }

    public static void configure(DecayConfig decayConfig, double ... quantiles) {
        ServiceStats.configure(decayConfig, Collections.emptyMap(), quantiles);
    }

    public static void configure(DecayConfig defaultDecayConfig, Map<String, DecayConfig> decayConfigMap, double ... quantiles) {
        long stamp = lock.writeLock();
        instance = new RealServiceStats(defaultDecayConfig, decayConfigMap, quantiles);
        lock.unlock(stamp);
    }

    public static ServiceStats instance() {
        long optimisticStamp = lock.tryOptimisticRead();
        ServiceStats myInstance = instance;
        if (!lock.validate(optimisticStamp)) {
            long readStamp = lock.readLock();
            myInstance = instance;
            lock.unlock(readStamp);
        }
        return myInstance == null ? NOOP : myInstance;
    }

    private static class RealServiceStats
    extends ServiceStats {
        private final ConcurrentMap<String, LiveStats> stats = new ConcurrentHashMap<String, LiveStats>();
        private final Function<String, DecayConfig> getDecayConfig = key -> decayConfigMap.getOrDefault(key, defaultDecayConfig);
        private final double[] quantiles;

        private RealServiceStats(DecayConfig defaultDecayConfig, Map<String, DecayConfig> decayConfigMap, double ... quantiles) {
            this.quantiles = Arrays.copyOf(quantiles, quantiles.length);
        }

        @Override
        public Stats[] consume() {
            TreeMap<String, LiveStats> savedStats = new TreeMap<String, LiveStats>(this.stats);
            savedStats.keySet().forEach(this.stats::remove);
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e2) {
                Thread.currentThread().interrupt();
            }
            return (Stats[])savedStats.entrySet().stream().peek(e -> ((LiveStats)e.getValue()).decayByTime()).map(e -> new Stats((String)e.getKey(), (LiveStats)e.getValue())).toArray(Stats[]::new);
        }

        @Override
        public Stream<Stats> get(String ... statsNames) {
            Map<String, LiveStats> statsToReturn = statsNames.length == 0 ? Collections.unmodifiableMap(this.stats) : Arrays.stream(statsNames).collect(Collectors.toMap(Function.identity(), this.stats::get));
            return statsToReturn.entrySet().stream().peek(e -> ((LiveStats)e.getValue()).decayByTime()).map(e -> new Stats((String)e.getKey(), (LiveStats)e.getValue()));
        }

        @Override
        protected void addTiming(String key, long nanos, long endNanos) {
            this.stats.computeIfAbsent(key, name -> new LiveStats(this.getDecayConfig.apply((String)name), this.quantiles)).add(nanos);
            if (log.isTraceEnabled()) {
                long overhead = System.nanoTime() - endNanos;
                this.stats.computeIfAbsent("overhead", name -> new LiveStats(this.getDecayConfig.apply((String)name), this.quantiles)).add(overhead);
            }
        }
    }

    private static class NoopServiceStats
    extends ServiceStats {
        private NoopServiceStats() {
        }

        @Override
        public Stats[] consume() {
            return new Stats[0];
        }

        @Override
        public Stream<Stats> get(String ... statsNames) {
            return Stream.of(new Stats[0]);
        }

        @Override
        protected void addTiming(String key, long nanos, long endNanos) {
        }
    }
}

