/*
 * Decompiled with CFR 0.152.
 */
package io.praesid.livestats;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.concurrent.locks.StampedLock;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class Quantile
implements Serializable {
    private static final int N_MARKERS = 5;
    private static final double[] POSITION_DELTA_CONSTANT_PART = new double[]{0.0, 0.0, 0.5, 1.0};
    private static final double[] POSITION_DELTA_MULTIPLIER = new double[]{0.5, 1.0, 0.5, 0.0};
    private final transient StampedLock lock = new StampedLock();
    private final transient StampedLock initLock = new StampedLock();
    @GuardedBy(value="lock")
    private final double[] idealPositions;
    @GuardedBy(value="lock")
    private final double[] positions;
    @GuardedBy(value="lock")
    private final double[] heights;
    @GuardedBy(value="initLock,lock")
    private int initializedMarkers = 0;
    public final double percentile;

    public Quantile(double percentile) {
        this.percentile = percentile;
        this.idealPositions = new double[]{1.0 + 2.0 * percentile, 1.0 + 4.0 * percentile, 3.0 + 2.0 * percentile, 5.0};
        this.positions = new double[]{1.0, 2.0, 3.0, 4.0, 5.0};
        this.heights = new double[5];
    }

    private Quantile() {
        this.percentile = Double.NaN;
        this.idealPositions = null;
        this.positions = null;
        this.heights = null;
    }

    private Quantile(Quantile quantile) {
        this.idealPositions = quantile.idealPositions;
        this.positions = quantile.positions;
        this.heights = quantile.heights;
        this.initializedMarkers = quantile.initializedMarkers;
        this.percentile = quantile.percentile;
    }

    private Object readResolve() throws ObjectStreamException {
        if (this.lock != null) {
            throw new IllegalStateException("Impossible: Transient field already set");
        }
        return new Quantile(this);
    }

    public double quantile() {
        long optimisticStamp = this.lock.tryOptimisticRead();
        double quantile = this.heights[this.initializedMarkers / 2];
        if (!this.lock.validate(optimisticStamp)) {
            long readStamp = this.lock.readLock();
            quantile = this.heights[this.initializedMarkers / 2];
            this.lock.unlock(readStamp);
        }
        return quantile;
    }

    public void decay(double decayMultiplier) {
        if (decayMultiplier == 1.0) {
            return;
        }
        long writeStamp = this.lock.writeLock();
        if (this.initializedMarkers == 5) {
            for (int i = 0; i < this.idealPositions.length; ++i) {
                int n = i;
                this.idealPositions[n] = this.idealPositions[n] * decayMultiplier;
                int n2 = i + 1;
                this.positions[n2] = this.positions[n2] * decayMultiplier;
            }
        }
        this.lock.unlock(writeStamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(double item, double targetMin, double targetMax) {
        long writeStamp = this.lock.writeLock();
        try {
            if (this.initializedMarkers < 5) {
                this.heights[this.initializedMarkers] = item;
                long initWriteStamp = this.initLock.writeLock();
                ++this.initializedMarkers;
                this.initLock.unlock(initWriteStamp);
                Arrays.sort(this.heights, 0, this.initializedMarkers);
                return;
            }
            this.heights[4] = targetMax > this.heights[3] ? targetMax : this.heights[3] + Math.ulp(this.heights[3]);
            this.heights[0] = targetMin < this.heights[1] ? targetMin : this.heights[1] - Math.ulp(this.heights[1]);
            this.positions[4] = this.positions[4] + 1.0;
            int i = 3;
            while (this.heights[i] > item) {
                int n = i--;
                this.positions[n] = this.positions[n] + 1.0;
            }
            for (i = 0; i < this.idealPositions.length; ++i) {
                int n = i;
                this.idealPositions[n] = this.idealPositions[n] + Quantile.getPositionDelta(this.percentile, i);
            }
            this.adjust();
        }
        finally {
            this.lock.unlock(writeStamp);
        }
    }

    private void adjust() {
        for (int i = 1; i < 4; ++i) {
            double lowerHalf;
            double xAbove;
            double heightAbove;
            double xBelow;
            double upperHalf;
            double positionBelow;
            double positionAbove;
            double position = this.positions[i];
            double positionDelta = this.idealPositions[i - 1] - position;
            if (!(positionDelta >= 1.0 && this.positions[i + 1] > position + 1.0) && (!(positionDelta <= -1.0) || !(this.positions[i - 1] < position - 1.0))) continue;
            double heightBelow = this.heights[i - 1];
            double height = this.heights[i];
            int direction = positionDelta > 0.0 ? 1 : -1;
            double signedPositionRange = (double)direction / ((positionAbove = this.positions[i + 1]) - (positionBelow = this.positions[i - 1]));
            double newHeight = height + signedPositionRange * ((upperHalf = ((xBelow = position - positionBelow) + (double)direction) * ((heightAbove = this.heights[i + 1]) - height) / (xAbove = positionAbove - position)) + (lowerHalf = (xAbove - (double)direction) * (height - heightBelow) / xBelow));
            if (heightBelow < newHeight && newHeight < heightAbove) {
                this.heights[i] = newHeight;
            } else {
                double rise = this.heights[i + direction] - height;
                double run = this.positions[i + direction] - position;
                this.heights[i] = height + Math.copySign(rise / run, (double)direction);
            }
            this.positions[i] = position + (double)direction;
        }
    }

    public static double getPositionDelta(double percentile, int pos) {
        return POSITION_DELTA_CONSTANT_PART[pos] + POSITION_DELTA_MULTIPLIER[pos] * percentile;
    }

    public String toString() {
        return "Quantile(idealPositions=" + Arrays.toString(this.idealPositions) + ", positions=" + Arrays.toString(this.positions) + ", heights=" + Arrays.toString(this.heights) + ", initializedMarkers=" + this.initializedMarkers + ", percentile=" + this.percentile + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Quantile)) {
            return false;
        }
        Quantile other = (Quantile)o;
        if (!Arrays.equals(this.idealPositions, other.idealPositions)) {
            return false;
        }
        if (!Arrays.equals(this.positions, other.positions)) {
            return false;
        }
        if (!Arrays.equals(this.heights, other.heights)) {
            return false;
        }
        if (this.initializedMarkers != other.initializedMarkers) {
            return false;
        }
        return Double.compare(this.percentile, other.percentile) == 0;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.idealPositions);
        result = result * 59 + Arrays.hashCode(this.positions);
        result = result * 59 + Arrays.hashCode(this.heights);
        result = result * 59 + this.initializedMarkers;
        long $percentile = Double.doubleToLongBits(this.percentile);
        result = result * 59 + (int)($percentile >>> 32 ^ $percentile);
        return result;
    }
}

