/*
 * Decompiled with CFR 0.152.
 */
package io.praesid.livestats;

import io.praesid.livestats.DecayConfig;
import io.praesid.livestats.Quantile;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.StampedLock;
import java.util.function.DoubleConsumer;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class LiveStats
implements DoubleConsumer,
Serializable {
    private final transient StampedLock lock;
    @GuardedBy(value="lock")
    private double min = Double.MAX_VALUE;
    @GuardedBy(value="lock")
    private double decayedMin = Double.MAX_VALUE;
    @GuardedBy(value="lock")
    private double max = -1.7976931348623157E308;
    @GuardedBy(value="lock")
    private double decayedMax = -1.7976931348623157E308;
    @GuardedBy(value="lock")
    private double sum = 0.0;
    @GuardedBy(value="lock")
    private double sumCentralMoment2 = 0.0;
    @GuardedBy(value="lock")
    private double sumCentralMoment3 = 0.0;
    @GuardedBy(value="lock")
    private double sumCentralMoment4 = 0.0;
    @GuardedBy(value="lock")
    private long count = 0L;
    @GuardedBy(value="lock")
    private double decayedCount = 0.0;
    @GuardedBy(value="lock")
    private int decayCount = 0;
    private final Quantile[] quantiles;
    private final long startNanos;
    private final DecayConfig decayConfig;

    public LiveStats(double ... quantiles) {
        this(DecayConfig.NEVER, quantiles);
    }

    private LiveStats() {
        this.lock = new StampedLock();
        this.quantiles = null;
        this.startNanos = 0L;
        this.decayConfig = null;
    }

    public LiveStats(DecayConfig decayConfig, double ... quantiles) {
        this.lock = new StampedLock();
        this.quantiles = (Quantile[])Arrays.stream(quantiles).mapToObj(Quantile::new).toArray(Quantile[]::new);
        this.decayConfig = decayConfig;
        this.startNanos = System.nanoTime();
    }

    private LiveStats(LiveStats liveStats) {
        this.lock = new StampedLock();
        this.min = liveStats.min;
        this.decayedMin = liveStats.decayedMin;
        this.max = liveStats.max;
        this.decayedMax = liveStats.decayedMax;
        this.sum = liveStats.sum;
        this.sumCentralMoment2 = liveStats.sumCentralMoment2;
        this.sumCentralMoment3 = liveStats.sumCentralMoment3;
        this.sumCentralMoment4 = liveStats.sumCentralMoment4;
        this.count = liveStats.count;
        this.decayedCount = liveStats.decayedCount;
        this.decayCount = liveStats.decayCount;
        this.quantiles = liveStats.quantiles;
        this.startNanos = liveStats.startNanos;
        this.decayConfig = liveStats.decayConfig;
    }

    private Object readResolve() throws ObjectStreamException {
        if (this.lock != null) {
            throw new IllegalStateException("Impossible: Transient field already set");
        }
        return new LiveStats(this);
    }

    public void decayByTime() {
        if (this.decayConfig.multiplier == 1.0 || this.decayConfig.period == 0L) {
            return;
        }
        int expectedDecays = (int)((System.nanoTime() - this.startNanos) / this.decayConfig.period);
        long optimisticStamp = this.lock.tryOptimisticRead();
        int myDecayCount = this.decayCount;
        if (!this.lock.validate(optimisticStamp)) {
            long readStamp = this.lock.readLock();
            myDecayCount = this.decayCount;
            this.lock.unlock(readStamp);
        }
        if (expectedDecays == myDecayCount) {
            return;
        }
        this.decayTo(this.lock.writeLock(), expectedDecays);
    }

    public void decay() {
        if (this.decayConfig.multiplier == 1.0 || this.decayConfig.period != 0L) {
            return;
        }
        long writeStamp = this.lock.writeLock();
        this.decayTo(writeStamp, this.decayCount + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decayTo(long writeStamp, int expectedDecays) {
        double myDecayMultiplier;
        try {
            myDecayMultiplier = Math.pow(this.decayConfig.multiplier, expectedDecays - this.decayCount);
            if (this.count != 0L) {
                double minMaxDecay = (this.decayedMax - this.decayedMin) * (myDecayMultiplier / 2.0);
                this.decayedMin += minMaxDecay;
                this.decayedMax -= minMaxDecay;
            }
            this.sum *= myDecayMultiplier;
            this.decayedCount *= myDecayMultiplier;
            this.sumCentralMoment2 *= myDecayMultiplier;
            this.sumCentralMoment3 *= myDecayMultiplier;
            this.sumCentralMoment4 *= myDecayMultiplier;
            this.decayCount = expectedDecays;
        }
        finally {
            this.lock.unlock(writeStamp);
        }
        for (Quantile quantile : this.quantiles) {
            quantile.decay(myDecayMultiplier);
        }
    }

    @Override
    public void accept(double item) {
        this.add(item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(double item) {
        double targetMax;
        double targetMin;
        this.decayByTime();
        long stamp = this.lock.writeLock();
        try {
            this.min = Math.min(this.min, item);
            targetMin = this.decayedMin = Math.min(this.decayedMin, item);
            this.max = Math.max(this.max, item);
            targetMax = this.decayedMax = Math.max(this.decayedMax, item);
            ++this.count;
            this.decayedCount += 1.0;
            this.sum += item;
            double delta = item - this.sum / this.decayedCount;
            double delta2 = delta * delta;
            this.sumCentralMoment2 += delta2;
            double delta3 = delta2 * delta;
            this.sumCentralMoment3 += delta3;
            double delta4 = delta3 * delta;
            this.sumCentralMoment4 += delta4;
        }
        finally {
            this.lock.unlock(stamp);
        }
        for (Quantile quantile : this.quantiles) {
            quantile.add(item, targetMin, targetMax);
        }
    }

    public double maximum() {
        long optimisticStamp = this.lock.tryOptimisticRead();
        double maximum = this.max;
        if (!this.lock.validate(optimisticStamp)) {
            long readStamp = this.lock.readLock();
            maximum = this.max;
            this.lock.unlock(readStamp);
        }
        return maximum;
    }

    public double decayedMaximum() {
        long optimisticStamp = this.lock.tryOptimisticRead();
        double decayedMaximum = this.decayedMax;
        if (!this.lock.validate(optimisticStamp)) {
            long readStamp = this.lock.readLock();
            decayedMaximum = this.decayedMax;
            this.lock.unlock(readStamp);
        }
        return decayedMaximum;
    }

    public double mean() {
        long optimisticStamp = this.lock.tryOptimisticRead();
        double mean = this.sum / this.decayedCount;
        if (!this.lock.validate(optimisticStamp)) {
            long readStamp = this.lock.readLock();
            mean = this.sum / this.decayedCount;
            this.lock.unlock(readStamp);
        }
        return mean;
    }

    public double minimum() {
        long optimisticStamp = this.lock.tryOptimisticRead();
        double minimum = this.min;
        if (!this.lock.validate(optimisticStamp)) {
            long readStamp = this.lock.readLock();
            minimum = this.min;
            this.lock.unlock(readStamp);
        }
        return minimum;
    }

    public double decayedMinimum() {
        long optimisticStamp = this.lock.tryOptimisticRead();
        double decayedMinimum = this.decayedMin;
        if (!this.lock.validate(optimisticStamp)) {
            long readStamp = this.lock.readLock();
            decayedMinimum = this.decayedMin;
            this.lock.unlock(readStamp);
        }
        return decayedMinimum;
    }

    public long num() {
        long optimisticStamp = this.lock.tryOptimisticRead();
        long num = this.count;
        if (!this.lock.validate(optimisticStamp)) {
            long readStamp = this.lock.readLock();
            num = this.count;
            this.lock.unlock(readStamp);
        }
        return num;
    }

    public double decayedNum() {
        long optimisticStamp = this.lock.tryOptimisticRead();
        double decayedNum = this.decayedCount;
        if (!this.lock.validate(optimisticStamp)) {
            long readStamp = this.lock.readLock();
            decayedNum = this.decayedCount;
            this.lock.unlock(readStamp);
        }
        return decayedNum;
    }

    public int decayCount() {
        long optimisticStamp = this.lock.tryOptimisticRead();
        int myDecayCount = this.decayCount;
        if (!this.lock.validate(optimisticStamp)) {
            long readStamp = this.lock.readLock();
            myDecayCount = this.decayCount;
            this.lock.unlock(readStamp);
        }
        return myDecayCount;
    }

    public Map<Double, Double> quantiles() {
        HashMap<Double, Double> quantileMap = new HashMap<Double, Double>();
        for (Quantile quantile : this.quantiles) {
            quantileMap.put(quantile.percentile, quantile.quantile());
        }
        return quantileMap;
    }

    public double variance() {
        long optimisticStamp = this.lock.tryOptimisticRead();
        double variance = this.sumCentralMoment2 / this.decayedCount;
        if (!this.lock.validate(optimisticStamp)) {
            long readStamp = this.lock.readLock();
            variance = this.sumCentralMoment2 / this.decayedCount;
            this.lock.unlock(readStamp);
        }
        return variance;
    }

    public double kurtosis() {
        long optimisticStamp = this.lock.tryOptimisticRead();
        double mySumCentralMoment2 = this.sumCentralMoment2;
        double mySumCentralMoment4 = this.sumCentralMoment4;
        double myDecayedCount = this.decayedCount;
        if (!this.lock.validate(optimisticStamp)) {
            long readStamp = this.lock.readLock();
            mySumCentralMoment2 = this.sumCentralMoment2;
            mySumCentralMoment4 = this.sumCentralMoment4;
            myDecayedCount = this.decayedCount;
            this.lock.unlock(readStamp);
        }
        if (mySumCentralMoment4 == 0.0) {
            return 0.0;
        }
        return mySumCentralMoment4 * myDecayedCount / Math.pow(mySumCentralMoment2, 2.0) - 3.0;
    }

    public double skewness() {
        long optimisticStamp = this.lock.tryOptimisticRead();
        double mySumCentralMoment2 = this.sumCentralMoment2;
        double mySumCentralMoment3 = this.sumCentralMoment3;
        double myDecayedCount = this.decayedCount;
        if (!this.lock.validate(optimisticStamp)) {
            long readStamp = this.lock.readLock();
            mySumCentralMoment2 = this.sumCentralMoment2;
            mySumCentralMoment3 = this.sumCentralMoment3;
            myDecayedCount = this.decayedCount;
            this.lock.unlock(readStamp);
        }
        if (mySumCentralMoment3 == 0.0) {
            return 0.0;
        }
        return mySumCentralMoment3 * Math.sqrt(myDecayedCount / mySumCentralMoment2) / mySumCentralMoment2;
    }

    public String toString() {
        return "LiveStats(min=" + this.min + ", decayedMin=" + this.decayedMin + ", max=" + this.max + ", decayedMax=" + this.decayedMax + ", sum=" + this.sum + ", sumCentralMoment2=" + this.sumCentralMoment2 + ", sumCentralMoment3=" + this.sumCentralMoment3 + ", sumCentralMoment4=" + this.sumCentralMoment4 + ", count=" + this.count + ", decayedCount=" + this.decayedCount + ", decayCount=" + this.decayCount + ", quantiles=" + Arrays.deepToString(this.quantiles) + ", startNanos=" + this.startNanos + ", decayConfig=" + this.decayConfig + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LiveStats)) {
            return false;
        }
        LiveStats other = (LiveStats)o;
        if (Double.compare(this.min, other.min) != 0) {
            return false;
        }
        if (Double.compare(this.decayedMin, other.decayedMin) != 0) {
            return false;
        }
        if (Double.compare(this.max, other.max) != 0) {
            return false;
        }
        if (Double.compare(this.decayedMax, other.decayedMax) != 0) {
            return false;
        }
        if (Double.compare(this.sum, other.sum) != 0) {
            return false;
        }
        if (Double.compare(this.sumCentralMoment2, other.sumCentralMoment2) != 0) {
            return false;
        }
        if (Double.compare(this.sumCentralMoment3, other.sumCentralMoment3) != 0) {
            return false;
        }
        if (Double.compare(this.sumCentralMoment4, other.sumCentralMoment4) != 0) {
            return false;
        }
        if (this.count != other.count) {
            return false;
        }
        if (Double.compare(this.decayedCount, other.decayedCount) != 0) {
            return false;
        }
        if (this.decayCount != other.decayCount) {
            return false;
        }
        if (!Arrays.deepEquals(this.quantiles, other.quantiles)) {
            return false;
        }
        DecayConfig this$decayConfig = this.decayConfig;
        DecayConfig other$decayConfig = other.decayConfig;
        return !(this$decayConfig == null ? other$decayConfig != null : !((Object)this$decayConfig).equals(other$decayConfig));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $min = Double.doubleToLongBits(this.min);
        result = result * 59 + (int)($min >>> 32 ^ $min);
        long $decayedMin = Double.doubleToLongBits(this.decayedMin);
        result = result * 59 + (int)($decayedMin >>> 32 ^ $decayedMin);
        long $max = Double.doubleToLongBits(this.max);
        result = result * 59 + (int)($max >>> 32 ^ $max);
        long $decayedMax = Double.doubleToLongBits(this.decayedMax);
        result = result * 59 + (int)($decayedMax >>> 32 ^ $decayedMax);
        long $sum = Double.doubleToLongBits(this.sum);
        result = result * 59 + (int)($sum >>> 32 ^ $sum);
        long $sumCentralMoment2 = Double.doubleToLongBits(this.sumCentralMoment2);
        result = result * 59 + (int)($sumCentralMoment2 >>> 32 ^ $sumCentralMoment2);
        long $sumCentralMoment3 = Double.doubleToLongBits(this.sumCentralMoment3);
        result = result * 59 + (int)($sumCentralMoment3 >>> 32 ^ $sumCentralMoment3);
        long $sumCentralMoment4 = Double.doubleToLongBits(this.sumCentralMoment4);
        result = result * 59 + (int)($sumCentralMoment4 >>> 32 ^ $sumCentralMoment4);
        long $count = this.count;
        result = result * 59 + (int)($count >>> 32 ^ $count);
        long $decayedCount = Double.doubleToLongBits(this.decayedCount);
        result = result * 59 + (int)($decayedCount >>> 32 ^ $decayedCount);
        result = result * 59 + this.decayCount;
        result = result * 59 + Arrays.deepHashCode(this.quantiles);
        DecayConfig $decayConfig = this.decayConfig;
        result = result * 59 + ($decayConfig == null ? 43 : ((Object)$decayConfig).hashCode());
        return result;
    }
}

