/*
 * Decompiled with CFR 0.152.
 */
package io.praesid.livestats;

import java.io.Serializable;
import java.time.Duration;

public final class DecayConfig
implements Serializable {
    public static final DecayConfig NEVER = new DecayConfig();
    public final double multiplier;
    public final long period;

    public DecayConfig(double multiplier) {
        if (multiplier < 0.0 || multiplier >= 1.0) {
            throw new IllegalArgumentException("Multiplier must be >= 0 and < 1");
        }
        this.multiplier = multiplier;
        this.period = 0L;
    }

    public DecayConfig(double multiplier, Duration period) {
        if (multiplier < 0.0 || multiplier >= 1.0) {
            throw new IllegalArgumentException("Multiplier must be >= 0 and < 1");
        }
        if (period == null || period.isNegative() || period.isZero()) {
            throw new NullPointerException("Period must be specified and positive");
        }
        this.multiplier = multiplier;
        this.period = period.toNanos();
    }

    private DecayConfig() {
        this.multiplier = 1.0;
        this.period = 0L;
    }

    public String toString() {
        return "DecayConfig(multiplier=" + this.multiplier + ", period=" + this.period + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DecayConfig)) {
            return false;
        }
        DecayConfig other = (DecayConfig)o;
        if (Double.compare(this.multiplier, other.multiplier) != 0) {
            return false;
        }
        return this.period == other.period;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $multiplier = Double.doubleToLongBits(this.multiplier);
        result = result * 59 + (int)($multiplier >>> 32 ^ $multiplier);
        long $period = this.period;
        result = result * 59 + (int)($period >>> 32 ^ $period);
        return result;
    }
}

