/*
 * Decompiled with CFR 0.152.
 */
package io.poyarzun.concoursedsl.printer;

import com.squareup.kotlinpoet.CodeBlock;
import com.squareup.kotlinpoet.CodeBlocks;
import com.squareup.kotlinpoet.FileSpec;
import com.squareup.kotlinpoet.FunSpec;
import io.poyarzun.concoursedsl.domain.GenericGetStep;
import io.poyarzun.concoursedsl.domain.GenericPutStep;
import io.poyarzun.concoursedsl.domain.GenericResource;
import io.poyarzun.concoursedsl.domain.Group;
import io.poyarzun.concoursedsl.domain.Job;
import io.poyarzun.concoursedsl.domain.Pipeline;
import io.poyarzun.concoursedsl.domain.ResourceType;
import io.poyarzun.concoursedsl.domain.Step;
import io.poyarzun.concoursedsl.domain.Task;
import io.poyarzun.concoursedsl.dsl.DslList;
import io.poyarzun.concoursedsl.dsl.DslMap;
import io.poyarzun.concoursedsl.dsl.DslObject;
import io.poyarzun.concoursedsl.dsl.GenerateYMLKt;
import io.poyarzun.concoursedsl.printer.Printer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KCallable;
import kotlin.reflect.KClass;
import kotlin.reflect.KClassifier;
import kotlin.reflect.KFunction;
import kotlin.reflect.KParameter;
import kotlin.reflect.KProperty;
import kotlin.reflect.KProperty1;
import kotlin.reflect.full.KClasses;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001!B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J9\u0010\u0006\u001a\u0004\u0018\u00010\u0001\"\b\b\u0000\u0010\u0007*\u00020\u00012\u0006\u0010\b\u001a\u0002H\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00070\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0004H\u0002\u00a2\u0006\u0002\u0010\fJ-\u0010\r\u001a\u00020\u000e\"\b\b\u0000\u0010\u0007*\u00020\u00012\u0006\u0010\b\u001a\u0002H\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00070\nH\u0002\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\u000e2\b\u0010\b\u001a\u0004\u0018\u00010\u0001J3\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\"\b\b\u0000\u0010\u0007*\u00020\u00012\u0006\u0010\b\u001a\u0002H\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00070\nH\u0002\u00a2\u0006\u0002\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J \u0010\u0019\u001a\u00020\u0004\"\b\b\u0000\u0010\u0007*\u00020\u00012\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00070\nH\u0002J;\u0010\u001a\u001a\u00020\u001b\"\b\b\u0000\u0010\u0007*\u00020\u0001*\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\b\u001a\u0002H\u0007H\u0002\u00a2\u0006\u0002\u0010\u001fJ;\u0010 \u001a\u00020\u001b\"\b\b\u0000\u0010\u0007*\u00020\u0001*\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\b\u001a\u0002H\u0007H\u0002\u00a2\u0006\u0002\u0010\u001f\u00a8\u0006\""}, d2={"Lio/poyarzun/concoursedsl/printer/Printer;", "", "()V", "convertYamlToDsl", "", "yaml", "findPropertyValue", "T", "value", "type", "Lkotlin/reflect/KClass;", "param", "(Ljava/lang/Object;Lkotlin/reflect/KClass;Ljava/lang/String;)Ljava/lang/Object;", "generateDsl", "Lcom/squareup/kotlinpoet/CodeBlock;", "(Ljava/lang/Object;Lkotlin/reflect/KClass;)Lcom/squareup/kotlinpoet/CodeBlock;", "generateLiteral", "getRequiredConstructorParameters", "", "Lio/poyarzun/concoursedsl/printer/Printer$ConfiguredContructorArg;", "(Ljava/lang/Object;Lkotlin/reflect/KClass;)Ljava/util/List;", "pipelineToSource", "Lcom/squareup/kotlinpoet/FunSpec;", "pipeline", "Lio/poyarzun/concoursedsl/domain/Pipeline;", "typeToName", "generateConstructorDsl", "Lcom/squareup/kotlinpoet/CodeBlock$Builder;", "prefix", "suffix", "name", "(Lcom/squareup/kotlinpoet/CodeBlock$Builder;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Object;)Lcom/squareup/kotlinpoet/CodeBlock$Builder;", "generatePropertyDsl", "ConfiguredContructorArg", "concourse-dsl"})
public final class Printer {
    public static final Printer INSTANCE;

    @NotNull
    public final String convertYamlToDsl(@NotNull String yaml) {
        Intrinsics.checkParameterIsNotNull((Object)yaml, (String)"yaml");
        Pipeline pipeline = GenerateYMLKt.readYML(yaml);
        FileSpec file = FileSpec.Companion.builder("pipeline", "Main").addImport("io.poyarzun.concoursedsl.domain", new String[]{"pipeline", "group", "aggregate", "cache", "input", "output", "task", "do", "resourceType", "try", "job", "resource", "put", "get"}).addImport("io.poyarzun.concoursedsl.dsl", new String[]{"generateYML"}).addFunction(this.pipelineToSource(pipeline)).addFunction(FunSpec.Companion.builder("main").addStatement("println(generateYML(mainPipeline()))", new Object[0]).build()).build();
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder $receiver = stringBuilder;
        file.writeTo((Appendable)$receiver);
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply {\n\u2026his)\n        }.toString()");
        return string;
    }

    private final FunSpec pipelineToSource(Pipeline pipeline) {
        return FunSpec.Companion.builder("mainPipeline").addStatement("return %L", new Object[]{this.generateDsl(pipeline, Reflection.getOrCreateKotlinClass(Pipeline.class))}).build();
    }

    private final <T> CodeBlock generateDsl(T value, KClass<T> type) {
        CodeBlock.Builder builder;
        CodeBlock.Builder $receiver = builder = CodeBlock.Companion.builder();
        INSTANCE.generateConstructorDsl($receiver, "", "", INSTANCE.typeToName(type), value);
        return builder.build();
    }

    /*
     * WARNING - void declaration
     */
    private final <T> CodeBlock.Builder generateConstructorDsl(@NotNull CodeBlock.Builder $receiver, String prefix, String suffix, String name, T value) {
        void $this$mapTo$iv$iv;
        T t = value;
        if (t instanceof Step.AggregateStep) {
            return this.generatePropertyDsl($receiver, prefix, suffix, "aggregate", ((Step.AggregateStep)value).getAggregate());
        }
        if (t instanceof Step.DoStep) {
            return this.generatePropertyDsl($receiver, prefix, suffix, "`do`", ((Step.DoStep)value).getDo());
        }
        if (t instanceof Step.TryStep) {
            return $receiver.add(prefix + "`try`(%L)" + suffix, new Object[]{this.generateDsl(((Step.TryStep)value).getTry(), JvmClassMappingKt.getKotlinClass(((Step.TryStep)value).getTry().getClass()))});
        }
        KClass type = JvmClassMappingKt.getKotlinClass(value.getClass());
        List<ConfiguredContructorArg> params2 = this.getRequiredConstructorParameters(value, type);
        String argList2 = CollectionsKt.joinToString$default((Iterable)params2, (CharSequence)", ", null, null, (int)0, null, (Function1)generateConstructorDsl.argList.1.INSTANCE, (int)30, null);
        CharSequence charSequence = argList2;
        boolean bl = false;
        String paramTemplate = charSequence.length() > 0 ? '(' + argList2 + ')' : "";
        Iterable $this$map$iv = params2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ConfiguredContructorArg configuredContructorArg = (ConfiguredContructorArg)item$iv$iv;
            Collection collection = destination$iv$iv;
            Object object = it.getValue();
            collection.add(object);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Object[] objectArray = thisCollection$iv.toArray(new Object[0]);
        if (objectArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Object[] args = objectArray;
        $receiver.beginControlFlow(prefix + name + paramTemplate + suffix, Arrays.copyOf(args, args.length));
        Iterable $this$forEach$iv = KClasses.getMemberProperties((KClass)type);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object propValue;
            KClassifier classifier;
            boolean specifiedInConstructor;
            boolean bl2;
            KProperty1 prop;
            block10: {
                prop = (KProperty1)element$iv;
                Iterable $this$any$iv = params2;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv2 : $this$any$iv) {
                        ConfiguredContructorArg it = (ConfiguredContructorArg)element$iv2;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)prop.getName())) continue;
                        bl2 = true;
                        break block10;
                    }
                    bl2 = false;
                }
            }
            if ((specifiedInConstructor = bl2) || !((classifier = prop.getReturnType().getClassifier()) instanceof KClass)) continue;
            if (prop.get(value) == null) {
                continue;
            }
            INSTANCE.generatePropertyDsl($receiver, "", "", prop.getName(), propValue);
        }
        return $receiver.endControlFlow();
    }

    private final <T> CodeBlock.Builder generatePropertyDsl(@NotNull CodeBlock.Builder $receiver, String prefix, String suffix, String name, T value) {
        CodeBlock.Builder builder;
        T t = value;
        if (t instanceof String) {
            builder = $receiver.addStatement(name + " = %S", new Object[]{value});
        } else if (t instanceof Integer) {
            builder = $receiver.addStatement(name + " = %L", new Object[]{value});
        } else if (t instanceof Boolean) {
            builder = $receiver.addStatement(name + " = %L", new Object[]{value});
        } else if (t instanceof DslMap) {
            if (((DslMap)value).isEmpty()) {
                return $receiver;
            }
            $receiver.beginControlFlow(name, new Object[0]);
            Map $this$forEach$iv = (Map)value;
            boolean $i$f$forEach = false;
            Map map = $this$forEach$iv;
            boolean bl = false;
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry it = element$iv = iterator.next();
                $receiver.addStatement("put(%S, %L)", new Object[]{it.getKey(), INSTANCE.generateLiteral(it.getValue())});
            }
            builder = $receiver.endControlFlow();
        } else if (t instanceof DslList) {
            if (((DslList)value).isEmpty()) {
                return $receiver;
            }
            $receiver.beginControlFlow(prefix + name + suffix, new Object[0]);
            T t2 = value;
            if (t2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type io.poyarzun.concoursedsl.dsl.DslList<kotlin.Any>");
            }
            Iterable $this$forEach$iv = (DslList)t2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Object it = element$iv;
                Object t3 = it;
                if (t3 instanceof String) {
                    $receiver.addStatement("+%S", new Object[]{it});
                    continue;
                }
                INSTANCE.generateConstructorDsl($receiver, "+", "", INSTANCE.typeToName(JvmClassMappingKt.getKotlinClass(it.getClass())), it);
            }
            builder = $receiver.endControlFlow();
        } else if (t instanceof DslObject) {
            Object t4 = ((DslObject)value).getValue();
            if (t4 == null) {
                return $receiver;
            }
            Object innerVal = t4;
            builder = this.generateConstructorDsl($receiver, prefix, suffix, name, innerVal);
        } else {
            builder = this.generateConstructorDsl($receiver, name + " = ", "", this.typeToName(JvmClassMappingKt.getKotlinClass(value.getClass())), value);
        }
        return builder;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final CodeBlock generateLiteral(@Nullable Object value) {
        CodeBlock.Builder builder;
        CodeBlock.Builder $receiver = builder = CodeBlock.Companion.builder();
        Object object = value;
        if (object instanceof String) {
            $receiver.add("%S", new Object[]{value});
        } else if (object instanceof List) {
            Collection<CodeBlock> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = (Iterable)value;
            Printer printer = INSTANCE;
            CodeBlock.Builder builder2 = $receiver;
            boolean $i$f$map2 = false;
            void var9_14 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void p1;
                Object item$iv$iv;
                Object t = item$iv$iv = iterator.next();
                collection = destination$iv$iv;
                CodeBlock codeBlock = printer.generateLiteral(p1);
                collection.add(codeBlock);
            }
            collection = (List)destination$iv$iv;
            builder2.add(CodeBlocks.joinToCode$default((Collection)collection, null, (CharSequence)"listOf(", (CharSequence)")", (int)1, null));
        } else if (object instanceof Integer) {
            $receiver.add("%L", new Object[]{value});
        } else if (object instanceof Boolean) {
            $receiver.add("%L", new Object[]{value});
        } else if (object instanceof Map) {
            Collection<CodeBlock> collection;
            void $this$mapTo$iv$iv;
            Map $this$map$iv = (Map)value;
            CodeBlock.Builder builder3 = $receiver;
            boolean $i$f$map = false;
            Map $i$f$map2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            void var11_19 = $this$mapTo$iv$iv;
            boolean bl = false;
            Iterator iterator = var11_19.entrySet().iterator();
            while (iterator.hasNext()) {
                void it;
                CodeBlock.Builder builder4;
                Map.Entry item$iv$iv;
                Map.Entry $i$a$1$unknown = item$iv$iv = iterator.next();
                collection = destination$iv$iv;
                CodeBlock.Builder $receiver2 = builder4 = CodeBlock.Companion.builder();
                $receiver2.add("%S to %L", new Object[]{it.getKey(), INSTANCE.generateLiteral(it.getValue())});
                CodeBlock codeBlock = builder4.build();
                collection.add(codeBlock);
            }
            collection = (List)destination$iv$iv;
            builder3.add(CodeBlocks.joinToCode$default((Collection)collection, null, (CharSequence)"mapOf(", (CharSequence)")", (int)1, null));
        } else {
            Object object2 = value;
            if (object2 == null) {
                $receiver.add("null", new Object[0]);
            } else {
                $receiver.add("TODO(%S)", new Object[]{"Cannot generate dsl for literal: " + value});
            }
        }
        return builder.build();
    }

    private final <T> List<ConfiguredContructorArg> getRequiredConstructorParameters(T value, KClass<T> type) {
        boolean bl = false;
        List params2 = new ArrayList();
        KFunction kFunction = KClasses.getPrimaryConstructor(type);
        if (kFunction == null) {
            return params2;
        }
        KFunction primaryConstructor = kFunction;
        Iterable $this$forEach$iv = primaryConstructor.getParameters();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KParameter param = (KParameter)element$iv;
            if (param.isOptional()) continue;
            Object backingPropertyValue = INSTANCE.findPropertyValue(value, type, param.getName());
            if (backingPropertyValue == null) {
                params2.add(new ConfiguredContructorArg(param.getName(), "TODO(%S)", "Could not determine value for required parameter: " + param.getName()));
                continue;
            }
            params2.add(new ConfiguredContructorArg(param.getName(), "%S", backingPropertyValue));
        }
        return params2;
    }

    private final <T> String typeToName(KClass<T> type) {
        String string;
        if (KClasses.isSubclassOf(type, (KClass)Reflection.getOrCreateKotlinClass(Pipeline.class))) {
            string = "pipeline";
        } else if (KClasses.isSubclassOf(type, (KClass)Reflection.getOrCreateKotlinClass(Group.class))) {
            string = "group";
        } else if (KClasses.isSubclassOf(type, (KClass)Reflection.getOrCreateKotlinClass(Job.class))) {
            string = "job";
        } else if (KClasses.isSubclassOf(type, (KClass)Reflection.getOrCreateKotlinClass(Step.AggregateStep.class))) {
            string = "aggregate";
        } else if (KClasses.isSubclassOf(type, (KClass)Reflection.getOrCreateKotlinClass(GenericGetStep.class))) {
            string = "get";
        } else if (KClasses.isSubclassOf(type, (KClass)Reflection.getOrCreateKotlinClass(GenericPutStep.class))) {
            string = "put";
        } else if (KClasses.isSubclassOf(type, (KClass)Reflection.getOrCreateKotlinClass(Step.TaskStep.class))) {
            string = "task";
        } else if (KClasses.isSubclassOf(type, (KClass)Reflection.getOrCreateKotlinClass(Step.DoStep.class))) {
            string = "`do`";
        } else if (KClasses.isSubclassOf(type, (KClass)Reflection.getOrCreateKotlinClass(Step.TryStep.class))) {
            string = "`try`";
        } else if (KClasses.isSubclassOf(type, (KClass)Reflection.getOrCreateKotlinClass(ResourceType.class))) {
            string = "resourceType";
        } else if (KClasses.isSubclassOf(type, (KClass)Reflection.getOrCreateKotlinClass(GenericResource.class))) {
            string = "resource";
        } else if (KClasses.isSubclassOf(type, (KClass)Reflection.getOrCreateKotlinClass(Task.Cache.class))) {
            string = "cache";
        } else if (KClasses.isSubclassOf(type, (KClass)Reflection.getOrCreateKotlinClass(Task.Input.class))) {
            string = "input";
        } else if (KClasses.isSubclassOf(type, (KClass)Reflection.getOrCreateKotlinClass(Task.Output.class))) {
            string = "output";
        } else {
            String string2 = "typeToName(" + type + ')';
            boolean bl = false;
            throw (Throwable)new NotImplementedError("An operation is not implemented: " + string2);
        }
        return string;
    }

    private final <T> Object findPropertyValue(T value, KClass<T> type, String param) {
        Iterable $this$forEach$iv = type.getMembers();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KCallable it = (KCallable)element$iv;
            if (!(it instanceof KProperty) || !Intrinsics.areEqual((Object)it.getName(), (Object)param)) continue;
            return ((KProperty)it).getGetter().call(new Object[]{value});
        }
        return null;
    }

    private Printer() {
    }

    static {
        Printer printer;
        INSTANCE = printer = new Printer();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0006J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0001H\u00c6\u0003J)\u0010\u000f\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0001H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lio/poyarzun/concoursedsl/printer/Printer$ConfiguredContructorArg;", "", "name", "", "template", "value", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Object;)V", "getName", "()Ljava/lang/String;", "getTemplate", "getValue", "()Ljava/lang/Object;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "concourse-dsl"})
    public static final class ConfiguredContructorArg {
        @Nullable
        private final String name;
        @NotNull
        private final String template;
        @NotNull
        private final Object value;

        @Nullable
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String getTemplate() {
            return this.template;
        }

        @NotNull
        public final Object getValue() {
            return this.value;
        }

        public ConfiguredContructorArg(@Nullable String name, @NotNull String template, @NotNull Object value) {
            Intrinsics.checkParameterIsNotNull((Object)template, (String)"template");
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            this.name = name;
            this.template = template;
            this.value = value;
        }

        @Nullable
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final String component2() {
            return this.template;
        }

        @NotNull
        public final Object component3() {
            return this.value;
        }

        @NotNull
        public final ConfiguredContructorArg copy(@Nullable String name, @NotNull String template, @NotNull Object value) {
            Intrinsics.checkParameterIsNotNull((Object)template, (String)"template");
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            return new ConfiguredContructorArg(name, template, value);
        }

        @NotNull
        public static /* synthetic */ ConfiguredContructorArg copy$default(ConfiguredContructorArg configuredContructorArg, String string, String string2, Object object, int n, Object object2) {
            if ((n & 1) != 0) {
                string = configuredContructorArg.name;
            }
            if ((n & 2) != 0) {
                string2 = configuredContructorArg.template;
            }
            if ((n & 4) != 0) {
                object = configuredContructorArg.value;
            }
            return configuredContructorArg.copy(string, string2, object);
        }

        @NotNull
        public String toString() {
            return "ConfiguredContructorArg(name=" + this.name + ", template=" + this.template + ", value=" + this.value + ")";
        }

        public int hashCode() {
            String string = this.name;
            String string2 = this.template;
            Object object = this.value;
            return ((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (object != null ? object.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ConfiguredContructorArg)) break block3;
                    ConfiguredContructorArg configuredContructorArg = (ConfiguredContructorArg)object;
                    if (!Intrinsics.areEqual((Object)this.name, (Object)configuredContructorArg.name) || !Intrinsics.areEqual((Object)this.template, (Object)configuredContructorArg.template) || !Intrinsics.areEqual((Object)this.value, (Object)configuredContructorArg.value)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

