package io.polywrap.configBuilder

import io.polywrap.core.WrapEnv
import io.polywrap.core.resolution.Uri
import io.polywrap.wasm.WasmPackage

fun validateUri(uri: String): String = Uri(uri).uri

fun validateMapAsEnv(map: Map<*, *>): WrapEnv {
    return map.entries.associate { (key, value) ->
        if (key !is String || value == null) {
            throw IllegalArgumentException("Expected WrapEnv or serializable class instance. If you are passing a map, keys must be strings and values must not be null.")
        }
        key to value
    }
}

class ResourceReader {
    companion object {
        fun readResource(path: String): Result<ByteArray> = runCatching {
            ClassLoader.getSystemResourceAsStream(path)?.use {
                it.readBytes()
            } ?: throw Exception("Resource not found: $path")
        }

        fun readWasmPackage(name: String): WasmPackage {
            val module: ByteArray = readResource("embeds/$name/wrap.wasm").getOrThrow()
            val manifest: ByteArray = readResource("embeds/$name/wrap.info").getOrThrow()
            return WasmPackage(manifest, module)
        }
    }
}
