/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.common.model;

import io.polyglotted.common.model.GeoPoint;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import lombok.NonNull;

public final class GeoHash {
    private static int numbits = 30;
    static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'j', 'k', 'm', 'n', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    static final Map<Character, Integer> lookup = new HashMap<Character, Integer>();
    @NonNull
    public final GeoPoint point;

    public boolean equals(Object o) {
        return this == o || o != null && this.getClass() == o.getClass() && this.point.equals(((GeoHash)o).point);
    }

    public int hashCode() {
        return Objects.hash(this.point);
    }

    public String toString() {
        return GeoHash.encodeGeoHash(this.point.lat, this.point.lon);
    }

    public static GeoHash decodeGeoHash(String geohash) {
        boolean isSet;
        int i;
        StringBuilder buffer = new StringBuilder();
        for (char c : geohash.toCharArray()) {
            int i2 = lookup.get(Character.valueOf(c)) + 32;
            buffer.append(Integer.toString(i2, 2).substring(1));
        }
        BitSet lonset = new BitSet();
        BitSet latset = new BitSet();
        int j = 0;
        for (i = 0; i < numbits * 2; i += 2) {
            isSet = false;
            if (i < buffer.length()) {
                isSet = buffer.charAt(i) == '1';
            }
            lonset.set(j++, isSet);
        }
        j = 0;
        for (i = 1; i < numbits * 2; i += 2) {
            isSet = false;
            if (i < buffer.length()) {
                isSet = buffer.charAt(i) == '1';
            }
            latset.set(j++, isSet);
        }
        return new GeoHash(new GeoPoint(GeoHash.decode(latset, -90.0, 90.0), GeoHash.decode(lonset, -180.0, 180.0)));
    }

    public static String encodeGeoHash(double lat, double lon) {
        BitSet latbits = GeoHash.getBits(lat, -90.0, 90.0);
        BitSet lonbits = GeoHash.getBits(lon, -180.0, 180.0);
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < numbits; ++i) {
            buffer.append(lonbits.get(i) ? (char)'1' : '0');
            buffer.append(latbits.get(i) ? (char)'1' : '0');
        }
        return GeoHash.base32(Long.parseLong(buffer.toString(), 2));
    }

    private static BitSet getBits(double lat, double floor, double ceiling) {
        BitSet buffer = new BitSet(numbits);
        for (int i = 0; i < numbits; ++i) {
            double mid = (floor + ceiling) / 2.0;
            if (lat >= mid) {
                buffer.set(i);
                floor = mid;
                continue;
            }
            ceiling = mid;
        }
        return buffer;
    }

    private static String base32(long i) {
        boolean negative;
        char[] buf = new char[65];
        int charPos = 64;
        boolean bl = negative = i < 0L;
        if (!negative) {
            i = -i;
        }
        while (i <= -32L) {
            buf[charPos--] = digits[(int)(-(i % 32L))];
            i /= 32L;
        }
        buf[charPos] = digits[(int)(-i)];
        if (negative) {
            buf[--charPos] = 45;
        }
        return new String(buf, charPos, 65 - charPos);
    }

    private static double decode(BitSet bs, double floor, double ceiling) {
        double mid = 0.0;
        for (int i = 0; i < bs.length(); ++i) {
            mid = (floor + ceiling) / 2.0;
            if (bs.get(i)) {
                floor = mid;
                continue;
            }
            ceiling = mid;
        }
        return mid;
    }

    @NonNull
    public GeoPoint point() {
        return this.point;
    }

    public GeoHash(@NonNull GeoPoint point) {
        if (point == null) {
            throw new NullPointerException("point is marked non-null but is null");
        }
        this.point = point;
    }

    static {
        int i = 0;
        for (char c : digits) {
            lookup.put(Character.valueOf(c), i++);
        }
    }
}

