/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.common.util;

import com.google.common.io.ByteStreams;
import com.google.common.io.Resources;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public abstract class ResourceUtil {
    public static Map<String, String> readResourceAsMap(Class<?> clazz, String file) {
        return ResourceUtil.readResourceAsMap(clazz, file, "=");
    }

    public static Map<String, String> readResourceAsMap(Class<?> clazz, String file, String splitter) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        List<String> lines = ResourceUtil.readResourceList(clazz, file);
        for (String line : lines) {
            if (line.trim().isEmpty() || line.startsWith("#")) continue;
            int eqIndex = line.indexOf(splitter);
            result.put(line.substring(0, eqIndex), line.substring(eqIndex + 1));
        }
        return result;
    }

    public static byte[] readResourceBytes(Class<?> clazz, String resource) {
        return ResourceUtil.readResourceBytes(ResourceUtil.urlStream(clazz, resource));
    }

    public static byte[] readResourceBytes(InputStream stream) {
        return ByteStreams.toByteArray((InputStream)stream);
    }

    public static String readResource(Class<?> clazz, String resource) {
        return ResourceUtil.readResource(ResourceUtil.urlResource(clazz, resource));
    }

    public static String readResource(URL url) {
        return Resources.toString((URL)url, (Charset)StandardCharsets.UTF_8);
    }

    public static List<String> readResourceList(Class<?> clazz, String resource) {
        return ResourceUtil.readResourceList(ResourceUtil.urlResource(clazz, resource));
    }

    public static List<String> readResourceList(URL resource) {
        return Resources.readLines((URL)Objects.requireNonNull(resource), (Charset)StandardCharsets.UTF_8);
    }

    public static InputStream urlStream(Class<?> clazz, String resource) {
        return clazz.getClassLoader().getResourceAsStream(resource);
    }

    public static URL urlResource(Class<?> clazz, String resource) {
        return clazz.getClassLoader().getResource(resource);
    }

    public static Enumeration<URL> urlResources(Class<?> clazz, String resource) {
        return clazz.getClassLoader().getResources(resource);
    }
}

