/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.common.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import io.polyglotted.common.util.Assertions;
import io.polyglotted.common.util.ReflectionUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Supplier;

public interface ListBuilder<E, L extends Collection<E>, LB extends ListBuilder<E, L, LB>> {
    public LB add(E var1);

    public LB addAll(Iterable<? extends E> var1);

    public int size();

    public L build();

    default public L atleastOne() {
        Assertions.checkGte(this.size(), 1, "size");
        return this.build();
    }

    public static <E> ImmutableListBuilder<E> immutableListBuilder() {
        return new ImmutableListBuilder();
    }

    public static <E> ImmutableList<E> immutableList() {
        return ImmutableList.of();
    }

    @SafeVarargs
    public static <E> ImmutableList<E> immutableList(E ... elems) {
        return ListBuilder.immutableList(Arrays.asList(elems));
    }

    public static <E> ImmutableList<E> immutableList(Iterable<? extends E> coll) {
        return ((ImmutableListBuilder)ListBuilder.immutableListBuilder().addAll(coll)).build();
    }

    public static <E> SimpleListBuilder<E> simpleListBuilder(Collection<E> coll) {
        return ListBuilder.simpleListBuilder().addAll((Iterable)coll);
    }

    public static <E> SimpleListBuilder<E> simpleListBuilder() {
        return ListBuilder.simpleListBuilder(LinkedList::new);
    }

    public static <E> SimpleListBuilder<E> simpleListBuilder(Supplier<List<E>> supplier) {
        return new SimpleListBuilder(supplier.get());
    }

    public static <E> List<E> simpleList() {
        return new LinkedList();
    }

    @SafeVarargs
    public static <E> List<E> simpleList(E ... elems) {
        return ListBuilder.simpleList(Arrays.asList(elems));
    }

    public static <E> List<E> simpleList(Iterable<? extends E> coll) {
        return ((SimpleListBuilder)ListBuilder.simpleListBuilder().addAll(coll)).build();
    }

    public static <E> SimpleSetBuilder<E> simpleSetBuilder(Collection<E> coll) {
        return ListBuilder.simpleSetBuilder().addAll((Iterable)coll);
    }

    public static <E> SimpleSetBuilder<E> simpleSetBuilder() {
        return ListBuilder.simpleSetBuilder(TreeSet::new);
    }

    public static <E> SimpleSetBuilder<E> simpleSetBuilder(Supplier<Set<E>> supplier) {
        return new SimpleSetBuilder(supplier.get());
    }

    public static <E> ImmutableSet<E> immutableSet() {
        return ImmutableSet.of();
    }

    @SafeVarargs
    public static <E> Set<E> immutableSet(E ... elems) {
        return ListBuilder.immutableSet(Arrays.asList(elems));
    }

    public static <E> ImmutableSet<E> immutableSet(SimpleSetBuilder<E> builder) {
        return ListBuilder.immutableSet(builder.build());
    }

    public static <E> ImmutableSet<E> immutableSet(Iterable<E> iterable) {
        return ImmutableSet.copyOf(iterable);
    }

    @SafeVarargs
    public static <E> ImmutableSortedSet<E> immutableSortedSet(E ... elems) {
        return ListBuilder.immutableSortedSet(Arrays.asList(elems));
    }

    public static <E> ImmutableSortedSet<E> immutableSortedSet(SimpleSetBuilder<E> builder) {
        return ListBuilder.immutableSortedSet(builder.build());
    }

    public static <E> ImmutableSortedSet<E> immutableSortedSet(Iterable<E> iterable) {
        return ImmutableSortedSet.copyOf(iterable);
    }

    public static class SimpleSetBuilder<E>
    implements ListBuilder<E, Set<E>, SimpleSetBuilder<E>> {
        private final Set<E> builder;

        @Override
        public SimpleSetBuilder<E> add(E elem) {
            if (elem != null) {
                this.builder.add(elem);
            }
            return this;
        }

        public SimpleSetBuilder<E> remove(E elem) {
            this.builder.remove(elem);
            return this;
        }

        @Override
        public SimpleSetBuilder<E> addAll(Iterable<? extends E> elems) {
            for (E elem : elems) {
                this.add((Object)elem);
            }
            return this;
        }

        public SimpleSetBuilder<E> removeAll(Collection<? extends E> elems) {
            this.builder.removeAll(elems);
            return this;
        }

        @Override
        public int size() {
            return this.builder.size();
        }

        @Override
        public Set<E> build() {
            return this.builder;
        }

        public ImmutableSet<E> immutable() {
            return ListBuilder.immutableSet(this.builder);
        }

        public ImmutableSortedSet<E> immutableSorted() {
            return ListBuilder.immutableSortedSet(this.builder);
        }

        private SimpleSetBuilder(Set<E> builder) {
            this.builder = builder;
        }

        public Set<E> builder() {
            return this.builder;
        }
    }

    public static class SimpleListBuilder<E>
    implements ListBuilder<E, List<E>, SimpleListBuilder<E>> {
        private final List<E> builder;

        @Override
        public SimpleListBuilder<E> add(E elem) {
            if (elem != null) {
                this.builder.add(elem);
            }
            return this;
        }

        public SimpleListBuilder<E> remove(E elem) {
            this.builder.remove(elem);
            return this;
        }

        @Override
        public SimpleListBuilder<E> addAll(Iterable<? extends E> elems) {
            for (E elem : elems) {
                this.add((Object)elem);
            }
            return this;
        }

        public SimpleListBuilder<E> removeAll(Collection<? extends E> elems) {
            this.builder.removeAll(elems);
            return this;
        }

        @Override
        public int size() {
            return this.builder.size();
        }

        @Override
        public List<E> build() {
            return this.builder;
        }

        private SimpleListBuilder(List<E> builder) {
            this.builder = builder;
        }

        public List<E> builder() {
            return this.builder;
        }
    }

    public static class ImmutableListBuilder<E>
    implements ListBuilder<E, ImmutableList<E>, ImmutableListBuilder<E>> {
        private final ImmutableList.Builder<E> builder = ImmutableList.builder();

        @Override
        public ImmutableListBuilder<E> add(E elem) {
            if (elem != null) {
                this.builder.add(elem);
            }
            return this;
        }

        @Override
        public ImmutableListBuilder<E> addAll(Iterable<? extends E> elems) {
            for (E elem : elems) {
                this.add((Object)elem);
            }
            return this;
        }

        @Override
        public int size() {
            return (Integer)ReflectionUtil.fieldValue(this.builder, "size");
        }

        @Override
        public ImmutableList<E> build() {
            return this.builder.build();
        }

        private ImmutableListBuilder() {
        }
    }
}

