/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.common.web;

import com.google.common.base.Strings;
import io.polyglotted.common.util.BaseSerializer;
import io.polyglotted.common.util.MapBuilder;
import io.polyglotted.common.web.GatewayResponse;
import java.io.OutputStream;
import java.util.Base64;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WebHttpResponder {
    private static final Logger log = LoggerFactory.getLogger(WebHttpResponder.class);
    final boolean isLoadBalanced;
    final OutputStream outputStream;

    public void sendBytes(int status, byte[] bytes) {
        GatewayResponse.sendResult(this.isLoadBalanced, this.outputStream, status, Base64.getEncoder().encodeToString(bytes), true, MapBuilder.immutableMap("Content-Length", String.valueOf(bytes.length), "Content-Type", "application/octet-stream"));
    }

    public void sendObject(Object result) {
        this.sendObject(200, result);
    }

    public void sendObject(int status, Object result) {
        this.sendJson(status, BaseSerializer.serialize(result));
    }

    public void sendJson(String json) {
        this.sendJson(200, json);
    }

    public void sendJson(int status, String json) {
        this.sendString(status, json, "application/json");
    }

    public void sendString(String data, String contentType) {
        this.sendString(200, data, contentType);
    }

    public void sendString(int status, String data, String contentType) {
        if (Strings.isNullOrEmpty((String)data)) {
            this.sendStatus(status);
            return;
        }
        GatewayResponse.sendResult(this.isLoadBalanced, this.outputStream, status, data, false, MapBuilder.immutableMap("Content-Type", contentType));
    }

    public void sendStatus(int status) {
        this.sendStatus(status, (Map<String, String>)MapBuilder.immutableMap());
    }

    public void sendStatus(int status, Map<String, String> headers) {
        GatewayResponse.sendResult(this.isLoadBalanced, this.outputStream, status, null, false, headers);
    }

    public WebHttpResponder(boolean isLoadBalanced, OutputStream outputStream) {
        this.isLoadBalanced = isLoadBalanced;
        this.outputStream = outputStream;
    }
}

