/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.common.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.polyglotted.common.model.MapResult;
import io.polyglotted.common.util.ListBuilder;
import io.polyglotted.common.util.MapBuilder;
import io.polyglotted.common.util.NullUtil;
import io.polyglotted.common.util.UrnUtil;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.commons.codec.digest.DigestUtils;

@JsonPropertyOrder(value={"_meta", "principal", "attributes", "roles"})
public final class Subject {
    public final String principal;
    public final MapResult attributes;
    public final List<String> roles;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private final Map<String, Object> _meta;

    private Subject() {
        this(null, MapResult.immutableResult(), (List<String>)ListBuilder.immutableList(), (Map<String, Object>)MapBuilder.immutableMap());
    }

    public <T> T attribute(String key) {
        return this.attributes.optValue(key);
    }

    public String id() {
        return this.principal;
    }

    public String realm() {
        return (String)this.attribute("REALM");
    }

    public String userId() {
        return (String)this.attribute("USER_ID");
    }

    public String credential() {
        return (String)this.attribute("CREDENTIAL");
    }

    public String token() {
        return (String)this.attribute("ACCESS_TOKEN");
    }

    public String proxyUser() {
        return (String)this.attribute("PROXY_USER");
    }

    public String email() {
        return (String)this.attribute("EMAIL");
    }

    public String remoteAddr() {
        return NullUtil.nonNull(this.attribute("REMOTE_ADDR"), "10.0.0.1");
    }

    public boolean isPartial() {
        return Boolean.TRUE.equals(this.attribute("PARTIAL_AUTH"));
    }

    public String authScheme() {
        return NullUtil.nonNull(this.attribute("AUTH_SCHEME"), "Basic");
    }

    public String user() {
        return NullUtil.nonNull(this.attribute("DISPLAY_NAME"), this.principal);
    }

    public boolean isTrusted() {
        return Boolean.TRUE.equals(this.attribute("TRUSTED"));
    }

    public long userTtl() {
        return NullUtil.nonNull(this.attribute("USER_TTL"), 3600000L);
    }

    public static Subject buildWith(Map<String, Object> map) {
        return (Subject)io.polyglotted.common.model.Builder.buildWith(map, Builder.class);
    }

    public static Builder subjectBuilder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Subject)) {
            return false;
        }
        Subject other = (Subject)o;
        String this$principal = this.principal;
        String other$principal = other.principal;
        if (this$principal == null ? other$principal != null : !this$principal.equals(other$principal)) {
            return false;
        }
        MapResult this$attributes = this.attributes;
        MapResult other$attributes = other.attributes;
        if (this$attributes == null ? other$attributes != null : !this$attributes.equals(other$attributes)) {
            return false;
        }
        List<String> this$roles = this.roles;
        List<String> other$roles = other.roles;
        return !(this$roles == null ? other$roles != null : !((Object)this$roles).equals(other$roles));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $principal = this.principal;
        result = result * 59 + ($principal == null ? 43 : $principal.hashCode());
        MapResult $attributes = this.attributes;
        result = result * 59 + ($attributes == null ? 43 : $attributes.hashCode());
        List<String> $roles = this.roles;
        result = result * 59 + ($roles == null ? 43 : ((Object)$roles).hashCode());
        return result;
    }

    public String toString() {
        return "Subject(principal=" + this.principal + ", attributes=" + this.attributes + ", roles=" + this.roles + ", _meta=" + this._meta + ")";
    }

    public Subject(String principal, MapResult attributes, List<String> roles, Map<String, Object> _meta) {
        this.principal = principal;
        this.attributes = attributes;
        this.roles = roles;
        this._meta = _meta;
    }

    public Map<String, Object> _meta() {
        return this._meta;
    }

    public static class Builder
    implements io.polyglotted.common.model.Builder<Subject> {
        private String principal;
        private final MapBuilder.ImmutableMapBuilder<String, Object> attributes = MapResult.immutableResultBuilder();
        private final ListBuilder.ImmutableListBuilder<String> roles = ListBuilder.immutableListBuilder();
        private final MapBuilder.SimpleMapBuilder<String, Object> _meta = MapBuilder.simpleMapBuilder(TreeMap::new);

        public Builder usernameMd5(Object ... parts) {
            return this.principal(DigestUtils.md5Hex((String)UrnUtil.safeUrnOf(parts)));
        }

        public Builder role(String role) {
            this.roles.add((Object)role);
            return this;
        }

        public Builder roles(Iterable<String> roles) {
            this.roles.addAll((Iterable)roles);
            return this;
        }

        public Builder attribute(String key, Object value) {
            this.attributes.put((Object)key, value);
            return this;
        }

        public Builder attributes(Map<String, Object> meta) {
            this.attributes.putAll(meta);
            return this;
        }

        public Builder _meta(String name, String value) {
            this._meta.put((Object)name, (Object)value);
            return this;
        }

        public Builder _meta(Map<String, Object> map) {
            this._meta.putAll(map);
            return this;
        }

        @Override
        public Subject build() {
            return new Subject(Objects.requireNonNull(this.principal, "principal"), this.attributes.immutableResult(), (List<String>)this.roles.build(), this._meta.build());
        }

        public Builder principal(String principal) {
            this.principal = principal;
            return this;
        }

        private Builder() {
        }
    }
}

