/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.common.web;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import io.polyglotted.common.model.MapResult;
import io.polyglotted.common.util.MapRetriever;
import io.polyglotted.common.util.StrUtil;
import io.polyglotted.common.web.HttpMethod;
import java.util.Map;

public final class WebHttpRequest {
    public final HttpMethod method;
    public final String uriPath;
    public final String body;
    public final Map<String, Object> requestContext;
    public final ListMultimap<String, String> headers;
    public final ListMultimap<String, String> queryParams;

    static WebHttpRequest from(MapResult event) {
        return new WebHttpRequest(HttpMethod.valueOf(event.reqdStr("httpMethod")), event.reqdStr("path"), event.optStr("body"), event.mapVal("requestContext"), WebHttpRequest.buildParams(event, "headers", "multiValueHeaders", true), WebHttpRequest.buildParams(event, "queryStringParameters", "multiValueQueryStringParameters", false));
    }

    private static ListMultimap<String, String> buildParams(MapResult event, String singleParam, String multiParam, boolean lower) {
        ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
        for (Map.Entry<String, Object> entry : event.mapVal(singleParam).entrySet()) {
            builder.put((Object)(lower ? StrUtil.toLower(entry.getKey()) : entry.getKey()), (Object)((String)entry.getValue()));
        }
        for (Map.Entry<String, Object> entry : event.mapVal(multiParam).entrySet()) {
            builder.putAll((Object)(lower ? StrUtil.toLower(entry.getKey()) : entry.getKey()), (Iterable)MapRetriever.STRING_LIST_CLASS.cast(entry.getValue()));
        }
        return builder.build();
    }

    public WebHttpRequest(HttpMethod method, String uriPath, String body, Map<String, Object> requestContext, ListMultimap<String, String> headers, ListMultimap<String, String> queryParams) {
        this.method = method;
        this.uriPath = uriPath;
        this.body = body;
        this.requestContext = requestContext;
        this.headers = headers;
        this.queryParams = queryParams;
    }
}

