/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.common.web;

import org.apache.commons.text.StringEscapeUtils;

public class WebHttpException
extends RuntimeException {
    public final int httpStatus;

    public WebHttpException(int httpStatus, String message) {
        this(httpStatus, message, null);
    }

    public WebHttpException(int httpStatus, String message, Throwable cause) {
        super(StringEscapeUtils.escapeHtml4((String)message), cause);
        this.httpStatus = httpStatus;
    }

    public static WebHttpException asInternalServerException(Throwable ex) {
        return ex.getCause() instanceof WebHttpException ? (WebHttpException)ex.getCause() : new WebHttpException(500, ex.getMessage(), ex);
    }

    public static WebHttpException internalServerException(String message, Throwable ex) {
        return new WebHttpException(500, message, ex);
    }

    public static WebHttpException internalServerException(String message) {
        return new WebHttpException(500, message);
    }

    public static WebHttpException badRequestException(String message) {
        return new WebHttpException(400, message);
    }

    public static WebHttpException forbiddenException(String message) {
        return new WebHttpException(403, message);
    }

    public static WebHttpException unauthorisedException(String message) {
        return new WebHttpException(401, message);
    }

    public static WebHttpException notFoundException(String item) {
        return new WebHttpException(404, item + ": Not Found");
    }

    public static WebHttpException methodNotAllowedException(String message) {
        return new WebHttpException(405, message);
    }

    public static WebHttpException conflictException(String message) {
        return new WebHttpException(409, message);
    }

    public static void checkBadRequest(boolean condition, String message) {
        WebHttpException.checkBadRequest(condition, message, null);
    }

    public static <T> T checkBadRequest(boolean condition, String message, T r) {
        if (!condition) {
            throw WebHttpException.badRequestException(message);
        }
        return r;
    }
}

