/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.common.util;

import io.polyglotted.common.model.Pair;
import io.polyglotted.common.util.MapRetriever;
import io.polyglotted.common.util.ReflectionUtil;
import io.polyglotted.common.util.Sanitizer;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class ObjConstructor {
    public static <T> T construct(Map<String, Object> map, T builder) {
        for (Field field : builder.getClass().getDeclaredFields()) {
            Object value = map.get(field.getName());
            if (value == null) continue;
            if (value instanceof Collection) {
                if (ReflectionUtil.isAssignable(Set.class, field.getType())) {
                    ReflectionUtil.fieldValue(builder, field, ObjConstructor.collectInto(field, (List)value, new LinkedHashSet()));
                    continue;
                }
                ReflectionUtil.fieldValue(builder, field, ObjConstructor.collectInto(field, (List)value, new LinkedList()));
                continue;
            }
            if (value instanceof Map) {
                if (ReflectionUtil.isAssignable(Map.class, field.getType())) {
                    ReflectionUtil.fieldValue(builder, field, ObjConstructor.mapInto(field, MapRetriever.asMap(value)));
                    continue;
                }
                ReflectionUtil.fieldValue(builder, field, ObjConstructor.construct((Map)value, ReflectionUtil.create(field.getType())));
                continue;
            }
            ReflectionUtil.fieldValue(builder, field, Sanitizer.sanitize(field.getType(), value));
        }
        return builder;
    }

    private static <T, C extends Collection<T>> C collectInto(Field field, List<?> objects, C result) {
        Class<?> elemClass = ReflectionUtil.getCollTypeArg(field);
        for (Object obj : objects) {
            if (obj == null) continue;
            result.add(ObjConstructor.getElem(elemClass, obj));
        }
        return result;
    }

    private static Map<Object, Object> mapInto(Field field, Map<?, ?> map) {
        LinkedHashMap<Object, Object> result = new LinkedHashMap<Object, Object>();
        Pair<Class<?>, Class<?>> mapTypeArgs = ReflectionUtil.getMapTypeArgs(field);
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            result.put(ObjConstructor.getElem((Class)mapTypeArgs._a, entry.getKey()), ObjConstructor.getElem((Class)mapTypeArgs._b, entry.getValue()));
        }
        return result;
    }

    private static <T> T getElem(Class<?> elemClass, Object obj) {
        return (T)(Sanitizer.isSanitizable(elemClass) ? Sanitizer.sanitize(elemClass, obj) : (obj instanceof Map && !Object.class.equals(elemClass) ? ObjConstructor.construct(MapRetriever.asMap(obj), ReflectionUtil.create(elemClass)) : obj));
    }
}

