/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.common.util;

import com.google.common.annotations.VisibleForTesting;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;

public abstract class DigestUtil {
    private static final ThreadLocal<MessageDigest> SHA1 = ThreadLocal.withInitial(() -> DigestUtil.createMessageDigest("SHA1"));

    public static byte[] sha1Digest(byte[] bytes) {
        MessageDigest sha1 = SHA1.get();
        sha1.reset();
        sha1.update(Base64.getDecoder().decode("E1vHqXA4RYe9TgfVsyyKtw=="));
        sha1.update(bytes);
        byte[] digest = sha1.digest();
        digest[6] = (byte)(digest[6] & 0xF | 0x50);
        digest[8] = (byte)(digest[8] & 0x3F | 0x80);
        return digest;
    }

    @VisibleForTesting
    public static MessageDigest createMessageDigest(String algo) {
        try {
            return MessageDigest.getInstance(algo);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

