/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.common.util;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import io.polyglotted.common.model.MapResult;
import io.polyglotted.common.model.Serializers;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Collection;
import java.util.Map;

public abstract class BaseSerializer {
    private static final ObjectMapper MAPPER = BaseSerializer.buildMapper();

    private static ObjectMapper buildMapper() {
        return new ObjectMapper().registerModule((Module)Serializers.baseModule()).registerModule((Module)new GuavaModule()).registerModule((Module)new JavaTimeModule()).registerModule((Module)new Jdk8Module()).registerModule((Module)new ParameterNamesModule()).configure(DeserializationFeature.READ_ENUMS_USING_TO_STRING, true).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES, true).configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true).configure(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, true).configure(DeserializationFeature.ADJUST_DATES_TO_CONTEXT_TIME_ZONE, false).configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true).setSerializationInclusion(JsonInclude.Include.NON_NULL).setVisibility((VisibilityChecker)new VisibilityChecker.Std(JsonAutoDetect.Visibility.NONE, JsonAutoDetect.Visibility.NONE, JsonAutoDetect.Visibility.NONE, JsonAutoDetect.Visibility.ANY, JsonAutoDetect.Visibility.ANY));
    }

    public static <T> byte[] serializeBytes(T object) {
        return MAPPER.writeValueAsBytes(object);
    }

    public static String serialize(Object object) {
        return MAPPER.writeValueAsString(object);
    }

    public static <T> T deserialize(String json, Class<T> clazz) {
        return (T)MAPPER.readValue(json, clazz);
    }

    public static <T> T deserialize(byte[] bytes, Class<T> clazz) {
        return (T)MAPPER.readValue(bytes, clazz);
    }

    public static <T> T deserialize(InputStream stream, Class<T> clazz) {
        return (T)MAPPER.readValue(stream, clazz);
    }

    public static <T> T deserialize(Reader reader, Class<T> clazz) {
        return (T)MAPPER.readValue(reader, clazz);
    }

    public static MapResult deserialize(byte[] bytes) {
        return BaseSerializer.deserialize(bytes, MapResult.SimpleMapResult.class);
    }

    public static MapResult deserialize(String json) {
        return BaseSerializer.deserialize(json, MapResult.SimpleMapResult.class);
    }

    public static void writeNotEmptyMap(JsonGenerator gen, String name, Map<?, ?> map) throws IOException {
        if (!map.isEmpty()) {
            gen.writeObjectField(name, map);
        }
    }

    public static void writeNotEmptyColl(JsonGenerator gen, String name, Collection<?> coll) throws IOException {
        if (!coll.isEmpty()) {
            gen.writeObjectField(name, coll);
        }
    }

    public static void writeNotNull(JsonGenerator gen, String name, Object obj) throws IOException {
        if (obj != null) {
            gen.writeObjectField(name, obj);
        }
    }

    public static void writeNotNullOrEmpty(JsonGenerator gen, String name, Object obj) throws IOException {
        if (obj instanceof Map) {
            BaseSerializer.writeNotEmptyMap(gen, name, (Map)obj);
        } else if (obj instanceof Collection) {
            BaseSerializer.writeNotEmptyColl(gen, name, (Collection)obj);
        } else if (obj != null) {
            gen.writeObjectField(name, obj);
        }
    }
}

