/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.common.model;

import io.polyglotted.common.model.HasMeta;
import io.polyglotted.common.util.NullUtil;
import io.polyglotted.common.util.ReflectionUtil;
import io.polyglotted.common.util.Sanitizer;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.Map;

public interface Builder<T> {
    public T build();

    public static <T, C extends Builder<T>> T buildWith(Map<String, Object> mapResult, Class<C> clazz) {
        return Builder.buildWith(mapResult, clazz, false);
    }

    public static <T, C extends Builder<T>> T buildWith(Map<String, Object> mapResult, Class<C> clazz, boolean inclMeta) {
        T built = Builder.buildWith(mapResult, clazz, (Builder)ReflectionUtil.create(clazz)).build();
        return inclMeta && built instanceof HasMeta ? ((HasMeta)built).withMetas(mapResult) : built;
    }

    public static <T, C extends Builder<T>> C buildWith(Map<String, Object> mapResult, Class<C> clazz, C builder) {
        for (Field field : clazz.getDeclaredFields()) {
            Object value = mapResult.get(field.getName());
            if (value == null) {
                value = mapResult.get(NullUtil.nonNullFn(ReflectionUtil.annotation(field, Name.class), Name::value, "_$"));
            }
            if (value == null) continue;
            Class<?> valueClass = ReflectionUtil.detectValueClass(value, () -> ReflectionUtil.declaredField(clazz, field.getName()));
            try {
                ReflectionUtil.safeInvoke(ReflectionUtil.declaredMethod(clazz, field.getName(), new Class[]{valueClass}), builder, Sanitizer.sanitize(valueClass, value));
            }
            catch (Exception ex) {
                throw new RuntimeException("failed invoke " + field.getName(), ex);
            }
        }
        return builder;
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Name {
        public String value();
    }
}

