/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.common.util;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import io.polyglotted.common.util.DigestUtil;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.UUID;

public abstract class UuidUtil {
    private static final int[] HEX_DIGITS;

    public static String genUuidStr(String name) {
        return UuidUtil.generateUuid(name.getBytes(Charsets.UTF_8)).toString().toLowerCase();
    }

    public static UUID generateUuid(byte[] nameBytes) {
        return UuidUtil.uuidFrom(DigestUtil.sha1Digest(nameBytes));
    }

    public static UUID uuidFrom(String uuid) {
        long[] bits = UuidUtil.gatherLong(uuid);
        return new UUID(bits[0], bits[1]);
    }

    public static UUID uuidFrom(byte[] bytes) {
        ByteBuffer buffer = ByteBuffer.wrap(bytes).order(ByteOrder.BIG_ENDIAN);
        return new UUID(buffer.getLong(), buffer.getLong());
    }

    public static byte[] toBytes(String uuid) {
        long[] bits = UuidUtil.gatherLong(uuid);
        return UuidUtil.getBytes(bits[0], bits[1]);
    }

    public static byte[] toBytes(UUID uuid) {
        return UuidUtil.getBytes(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
    }

    private static long[] gatherLong(String id) {
        Preconditions.checkArgument((((String)Preconditions.checkNotNull((Object)id, (Object)"Null string passed")).length() == 36 ? 1 : 0) != 0, (Object)"UUID has to be represented by the standard 36-char representation");
        if (id.charAt(8) != '-' || id.charAt(13) != '-' || id.charAt(18) != '-' || id.charAt(23) != '-') {
            throw new NumberFormatException("UUID has to be represented by the standard 36-char representation");
        }
        long l1 = (long)UuidUtil.intFromChars(id, 0) << 32;
        long l2 = (long)UuidUtil.shortFromChars(id, 9) << 16 | (long)UuidUtil.shortFromChars(id, 14);
        long l3 = ((long)(UuidUtil.shortFromChars(id, 19) << 16) | (long)UuidUtil.shortFromChars(id, 24)) << 32;
        long l4 = (long)UuidUtil.intFromChars(id, 28) << 32 >>> 32;
        return new long[]{l1 + l2, l3 | l4};
    }

    private static byte[] getBytes(long mostSignificantBits, long leastSignificantBits) {
        return ByteBuffer.allocate(16).order(ByteOrder.BIG_ENDIAN).putLong(mostSignificantBits).putLong(leastSignificantBits).array();
    }

    private static int intFromChars(String str, int index) {
        return (UuidUtil.byteFromChars(str, index) << 24) + (UuidUtil.byteFromChars(str, index + 2) << 16) + (UuidUtil.byteFromChars(str, index + 4) << 8) + UuidUtil.byteFromChars(str, index + 6);
    }

    private static int shortFromChars(String str, int index) {
        return (UuidUtil.byteFromChars(str, index) << 8) + UuidUtil.byteFromChars(str, index + 2);
    }

    private static int byteFromChars(String str, int index) {
        int hex;
        char c1 = str.charAt(index);
        char c2 = str.charAt(index + 1);
        if (c1 <= '\u007f' && c2 <= '\u007f' && (hex = HEX_DIGITS[c1] << 4 | HEX_DIGITS[c2]) >= 0) {
            return hex;
        }
        throw c1 > '\u007f' || HEX_DIGITS[c1] < 0 ? UuidUtil.badChar(str, c1) : UuidUtil.badChar(str, c2);
    }

    private static NumberFormatException badChar(String uuidStr, char c) {
        return new NumberFormatException("Non-hex character '" + c + "', not valid character for a UUID String' (value 0x" + Integer.toHexString(c) + ") for UUID String \"" + uuidStr + "\"");
    }

    static {
        int i;
        HEX_DIGITS = new int[127];
        Arrays.fill(HEX_DIGITS, -1);
        for (i = 0; i < 10; ++i) {
            UuidUtil.HEX_DIGITS[48 + i] = i;
        }
        for (i = 0; i < 6; ++i) {
            UuidUtil.HEX_DIGITS[97 + i] = 10 + i;
            UuidUtil.HEX_DIGITS[65 + i] = 10 + i;
        }
    }
}

