/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.common.model;

import io.polyglotted.common.util.StrUtil;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;

public class AuthHeader {
    @Nullable
    public final String authHeader;

    public Header[] headers() {
        Header[] headerArray;
        if (StrUtil.nullOrEmpty(this.authHeader)) {
            headerArray = new Header[]{};
        } else {
            Header[] headerArray2 = new Header[1];
            headerArray = headerArray2;
            headerArray2[0] = new BasicHeader("Authorization", this.authHeader);
        }
        return headerArray;
    }

    public static AuthHeader basicAuth(String user, String passwd) {
        return new AuthHeader(AuthType.BASIC.header(user, passwd));
    }

    public static AuthHeader bearerToken(String token) {
        return new AuthHeader(AuthType.BEARER.header(null, token));
    }

    public static AuthHeader authHeader(Object auth) {
        return new AuthHeader(auth == null ? null : String.valueOf(auth));
    }

    public AuthHeader(@Nullable String authHeader) {
        this.authHeader = authHeader;
    }

    public static enum AuthType {
        BASIC{

            @Override
            String header(String user, String creds) {
                return "Basic " + Base64.encodeBase64String((byte[])(user + ":" + creds).getBytes(StandardCharsets.UTF_8));
            }
        }
        ,
        BEARER{

            @Override
            String header(String user, String token) {
                return "Bearer " + token;
            }
        };


        abstract String header(String var1, String var2);
    }
}

