/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.common.model;

import io.polyglotted.common.model.Builder;
import io.polyglotted.common.model.Jsoner;
import io.polyglotted.common.util.BaseSerializer;
import java.util.Map;
import java.util.Objects;

public final class AuthToken
implements Jsoner {
    public final String accessToken;
    public final Integer expiresIn;
    public final String tokenType;
    public final String refreshToken;

    private AuthToken() {
        this(null, null, null, null);
    }

    @Override
    public String toJson() {
        return BaseSerializer.serialize(this);
    }

    public static AuthToken buildWith(Map<String, Object> map) {
        return (AuthToken)io.polyglotted.common.model.Builder.buildWith(map, Builder.class);
    }

    public static AuthToken authToken(String token) {
        return AuthToken.tokenBuilder().accessToken(token).build();
    }

    public static Builder tokenBuilder() {
        return new Builder();
    }

    public AuthToken(String accessToken, Integer expiresIn, String tokenType, String refreshToken) {
        this.accessToken = accessToken;
        this.expiresIn = expiresIn;
        this.tokenType = tokenType;
        this.refreshToken = refreshToken;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuthToken)) {
            return false;
        }
        AuthToken other = (AuthToken)o;
        String this$accessToken = this.accessToken;
        String other$accessToken = other.accessToken;
        if (this$accessToken == null ? other$accessToken != null : !this$accessToken.equals(other$accessToken)) {
            return false;
        }
        Integer this$expiresIn = this.expiresIn;
        Integer other$expiresIn = other.expiresIn;
        if (this$expiresIn == null ? other$expiresIn != null : !((Object)this$expiresIn).equals(other$expiresIn)) {
            return false;
        }
        String this$tokenType = this.tokenType;
        String other$tokenType = other.tokenType;
        if (this$tokenType == null ? other$tokenType != null : !this$tokenType.equals(other$tokenType)) {
            return false;
        }
        String this$refreshToken = this.refreshToken;
        String other$refreshToken = other.refreshToken;
        return !(this$refreshToken == null ? other$refreshToken != null : !this$refreshToken.equals(other$refreshToken));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $accessToken = this.accessToken;
        result = result * 59 + ($accessToken == null ? 43 : $accessToken.hashCode());
        Integer $expiresIn = this.expiresIn;
        result = result * 59 + ($expiresIn == null ? 43 : ((Object)$expiresIn).hashCode());
        String $tokenType = this.tokenType;
        result = result * 59 + ($tokenType == null ? 43 : $tokenType.hashCode());
        String $refreshToken = this.refreshToken;
        result = result * 59 + ($refreshToken == null ? 43 : $refreshToken.hashCode());
        return result;
    }

    public static class Builder
    implements io.polyglotted.common.model.Builder<AuthToken> {
        @Builder.Name(value="access_token")
        private String accessToken;
        @Builder.Name(value="expires_in")
        private Integer expiresIn = 0;
        @Builder.Name(value="type")
        private String tokenType = "Bearer";
        @Builder.Name(value="refresh_token")
        private String refreshToken;

        @Override
        public AuthToken build() {
            return new AuthToken(Objects.requireNonNull(this.accessToken, "accessToken"), this.expiresIn, this.tokenType, this.refreshToken);
        }

        public Builder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public Builder expiresIn(Integer expiresIn) {
            this.expiresIn = expiresIn;
            return this;
        }

        public Builder tokenType(String tokenType) {
            this.tokenType = tokenType;
            return this;
        }

        public Builder refreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
            return this;
        }

        private Builder() {
        }
    }
}

