/*
 * Decompiled with CFR 0.152.
 */
package io.polyglotted.common.util;

import io.polyglotted.common.util.InsecureSslFactory;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

public class HttpConfig {
    int connectTimeout = 3000;
    int socketTimeout = 10000;
    boolean insecure = false;
    String scheme = "https";
    String host = "localhost";
    int port = 443;

    public String url() {
        return this.scheme + "://" + this.host + (this.port == 80 || this.port == 443 ? "" : ":" + this.port);
    }

    private HostnameVerifier hostnameVerifier() {
        return this.insecure ? new NoopHostnameVerifier() : null;
    }

    private SSLContext insecureContext() {
        return this.insecure ? InsecureSslFactory.insecureSslContext(this.host, this.port) : null;
    }

    private RequestConfig requestConfig() {
        return RequestConfig.custom().setConnectTimeout(this.connectTimeout).setSocketTimeout(this.socketTimeout).build();
    }

    public static CloseableHttpClient httpClient(HttpConfig config) {
        return HttpClientBuilder.create().setDefaultRequestConfig(config.requestConfig()).setSSLContext(config.insecureContext()).setSSLHostnameVerifier(config.hostnameVerifier()).build();
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public boolean isInsecure() {
        return this.insecure;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public HttpConfig setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public HttpConfig setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
        return this;
    }

    public HttpConfig setInsecure(boolean insecure) {
        this.insecure = insecure;
        return this;
    }

    public HttpConfig setScheme(String scheme) {
        this.scheme = scheme;
        return this;
    }

    public HttpConfig setHost(String host) {
        this.host = host;
        return this;
    }

    public HttpConfig setPort(int port) {
        this.port = port;
        return this;
    }
}

